/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.SliceChecksumDictHelper;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AccessDeniedException;
import com.zeroc.IceGrid.AdapterInfo;
import com.zeroc.IceGrid.AdapterInfoSeqHelper;
import com.zeroc.IceGrid.AdapterNotExistException;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGrid.ApplicationInfo;
import com.zeroc.IceGrid.ApplicationNotExistException;
import com.zeroc.IceGrid.ApplicationUpdateDescriptor;
import com.zeroc.IceGrid.BadSignalException;
import com.zeroc.IceGrid.DeploymentException;
import com.zeroc.IceGrid.LoadInfo;
import com.zeroc.IceGrid.NodeInfo;
import com.zeroc.IceGrid.NodeNotExistException;
import com.zeroc.IceGrid.NodeUnreachableException;
import com.zeroc.IceGrid.ObjectExistsException;
import com.zeroc.IceGrid.ObjectInfo;
import com.zeroc.IceGrid.ObjectInfoSeqHelper;
import com.zeroc.IceGrid.ObjectNotRegisteredException;
import com.zeroc.IceGrid.PatchException;
import com.zeroc.IceGrid.RegistryInfo;
import com.zeroc.IceGrid.RegistryNotExistException;
import com.zeroc.IceGrid.RegistryUnreachableException;
import com.zeroc.IceGrid.ServerInfo;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.ServerNotExistException;
import com.zeroc.IceGrid.ServerStartException;
import com.zeroc.IceGrid.ServerState;
import com.zeroc.IceGrid.ServerStopException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface Admin
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void addApplication(ApplicationDescriptor var1, Current var2) throws AccessDeniedException, DeploymentException;

    public void syncApplication(ApplicationDescriptor var1, Current var2) throws AccessDeniedException, ApplicationNotExistException, DeploymentException;

    public void updateApplication(ApplicationUpdateDescriptor var1, Current var2) throws AccessDeniedException, ApplicationNotExistException, DeploymentException;

    public void syncApplicationWithoutRestart(ApplicationDescriptor var1, Current var2) throws AccessDeniedException, ApplicationNotExistException, DeploymentException;

    public void updateApplicationWithoutRestart(ApplicationUpdateDescriptor var1, Current var2) throws AccessDeniedException, ApplicationNotExistException, DeploymentException;

    public void removeApplication(String var1, Current var2) throws AccessDeniedException, ApplicationNotExistException, DeploymentException;

    public void instantiateServer(String var1, String var2, ServerInstanceDescriptor var3, Current var4) throws AccessDeniedException, ApplicationNotExistException, DeploymentException;

    public CompletionStage<Void> patchApplicationAsync(String var1, boolean var2, Current var3) throws ApplicationNotExistException, PatchException;

    public ApplicationInfo getApplicationInfo(String var1, Current var2) throws ApplicationNotExistException;

    public ApplicationDescriptor getDefaultApplicationDescriptor(Current var1) throws DeploymentException;

    public String[] getAllApplicationNames(Current var1);

    public ServerInfo getServerInfo(String var1, Current var2) throws ServerNotExistException;

    public ServerState getServerState(String var1, Current var2) throws DeploymentException, NodeUnreachableException, ServerNotExistException;

    public int getServerPid(String var1, Current var2) throws DeploymentException, NodeUnreachableException, ServerNotExistException;

    public String getServerAdminCategory(Current var1);

    public ObjectPrx getServerAdmin(String var1, Current var2) throws DeploymentException, NodeUnreachableException, ServerNotExistException;

    public void enableServer(String var1, boolean var2, Current var3) throws DeploymentException, NodeUnreachableException, ServerNotExistException;

    public boolean isServerEnabled(String var1, Current var2) throws DeploymentException, NodeUnreachableException, ServerNotExistException;

    public CompletionStage<Void> startServerAsync(String var1, Current var2) throws DeploymentException, NodeUnreachableException, ServerNotExistException, ServerStartException;

    public CompletionStage<Void> stopServerAsync(String var1, Current var2) throws DeploymentException, NodeUnreachableException, ServerNotExistException, ServerStopException;

    public CompletionStage<Void> patchServerAsync(String var1, boolean var2, Current var3) throws DeploymentException, NodeUnreachableException, PatchException, ServerNotExistException;

    public void sendSignal(String var1, String var2, Current var3) throws BadSignalException, DeploymentException, NodeUnreachableException, ServerNotExistException;

    public String[] getAllServerIds(Current var1);

    public AdapterInfo[] getAdapterInfo(String var1, Current var2) throws AdapterNotExistException;

    public void removeAdapter(String var1, Current var2) throws AdapterNotExistException, DeploymentException;

    public String[] getAllAdapterIds(Current var1);

    public void addObject(ObjectPrx var1, Current var2) throws DeploymentException, ObjectExistsException;

    public void updateObject(ObjectPrx var1, Current var2) throws DeploymentException, ObjectNotRegisteredException;

    public void addObjectWithType(ObjectPrx var1, String var2, Current var3) throws DeploymentException, ObjectExistsException;

    public void removeObject(Identity var1, Current var2) throws DeploymentException, ObjectNotRegisteredException;

    public ObjectInfo getObjectInfo(Identity var1, Current var2) throws ObjectNotRegisteredException;

    public ObjectInfo[] getObjectInfosByType(String var1, Current var2);

    public ObjectInfo[] getAllObjectInfos(String var1, Current var2);

    public boolean pingNode(String var1, Current var2) throws NodeNotExistException;

    public LoadInfo getNodeLoad(String var1, Current var2) throws NodeNotExistException, NodeUnreachableException;

    public NodeInfo getNodeInfo(String var1, Current var2) throws NodeNotExistException, NodeUnreachableException;

    public ObjectPrx getNodeAdmin(String var1, Current var2) throws NodeNotExistException, NodeUnreachableException;

    public int getNodeProcessorSocketCount(String var1, Current var2) throws NodeNotExistException, NodeUnreachableException;

    public void shutdownNode(String var1, Current var2) throws NodeNotExistException, NodeUnreachableException;

    public String getNodeHostname(String var1, Current var2) throws NodeNotExistException, NodeUnreachableException;

    public String[] getAllNodeNames(Current var1);

    public boolean pingRegistry(String var1, Current var2) throws RegistryNotExistException;

    public RegistryInfo getRegistryInfo(String var1, Current var2) throws RegistryNotExistException, RegistryUnreachableException;

    public ObjectPrx getRegistryAdmin(String var1, Current var2) throws RegistryNotExistException;

    public void shutdownRegistry(String var1, Current var2) throws RegistryNotExistException, RegistryUnreachableException;

    public String[] getAllRegistryNames(Current var1);

    public void shutdown(Current var1);

    public Map<String, String> getSliceChecksums(Current var1);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return Admin.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::Admin";
    }

    public static CompletionStage<OutputStream> _iceD_addApplication(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ApplicationDescriptor iceP_descriptor = ApplicationDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.addApplication(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_syncApplication(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ApplicationDescriptor iceP_descriptor = ApplicationDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.syncApplication(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_updateApplication(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ApplicationUpdateDescriptor iceP_descriptor = ApplicationUpdateDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.updateApplication(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_syncApplicationWithoutRestart(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ApplicationDescriptor iceP_descriptor = ApplicationDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.syncApplicationWithoutRestart(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_updateApplicationWithoutRestart(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ApplicationUpdateDescriptor iceP_descriptor = ApplicationUpdateDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.updateApplicationWithoutRestart(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_removeApplication(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        obj.removeApplication(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_instantiateServer(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_application = istr.readString();
        String iceP_node = istr.readString();
        ServerInstanceDescriptor iceP_desc = ServerInstanceDescriptor.ice_read(istr);
        inS.endReadParams();
        obj.instantiateServer(iceP_application, iceP_node, iceP_desc, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_patchApplication(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        boolean iceP_shutdown = istr.readBool();
        inS.endReadParams();
        return inS.setResultFuture(obj.patchApplicationAsync(iceP_name, iceP_shutdown, current));
    }

    public static CompletionStage<OutputStream> _iceD_getApplicationInfo(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        ApplicationInfo ret = obj.getApplicationInfo(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ApplicationInfo.ice_write(ostr, ret);
        ostr.writePendingValues();
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getDefaultApplicationDescriptor(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ApplicationDescriptor ret = obj.getDefaultApplicationDescriptor(current);
        OutputStream ostr = inS.startWriteParams();
        ApplicationDescriptor.ice_write(ostr, ret);
        ostr.writePendingValues();
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getAllApplicationNames(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllApplicationNames(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getServerInfo(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        ServerInfo ret = obj.getServerInfo(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ServerInfo.ice_write(ostr, ret);
        ostr.writePendingValues();
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getServerState(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        ServerState ret = obj.getServerState(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ServerState.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getServerPid(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        int ret = obj.getServerPid(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getServerAdminCategory(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getServerAdminCategory(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getServerAdmin(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        ObjectPrx ret = obj.getServerAdmin(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_enableServer(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        boolean iceP_enabled = istr.readBool();
        inS.endReadParams();
        obj.enableServer(iceP_id, iceP_enabled, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_isServerEnabled(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        boolean ret = obj.isServerEnabled(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_startServer(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.startServerAsync(iceP_id, current));
    }

    public static CompletionStage<OutputStream> _iceD_stopServer(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.stopServerAsync(iceP_id, current));
    }

    public static CompletionStage<OutputStream> _iceD_patchServer(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        boolean iceP_shutdown = istr.readBool();
        inS.endReadParams();
        return inS.setResultFuture(obj.patchServerAsync(iceP_id, iceP_shutdown, current));
    }

    public static CompletionStage<OutputStream> _iceD_sendSignal(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        String iceP_signal = istr.readString();
        inS.endReadParams();
        obj.sendSignal(iceP_id, iceP_signal, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getAllServerIds(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllServerIds(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getAdapterInfo(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        AdapterInfo[] ret = obj.getAdapterInfo(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        AdapterInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_removeAdapter(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        obj.removeAdapter(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getAllAdapterIds(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllAdapterIds(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_addObject(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx iceP_obj = istr.readProxy();
        inS.endReadParams();
        obj.addObject(iceP_obj, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_updateObject(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx iceP_obj = istr.readProxy();
        inS.endReadParams();
        obj.updateObject(iceP_obj, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_addObjectWithType(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx iceP_obj = istr.readProxy();
        String iceP_type = istr.readString();
        inS.endReadParams();
        obj.addObjectWithType(iceP_obj, iceP_type, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_removeObject(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_id = Identity.ice_read(istr);
        inS.endReadParams();
        obj.removeObject(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getObjectInfo(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_id = Identity.ice_read(istr);
        inS.endReadParams();
        ObjectInfo ret = obj.getObjectInfo(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getObjectInfosByType(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_type = istr.readString();
        inS.endReadParams();
        ObjectInfo[] ret = obj.getObjectInfosByType(iceP_type, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getAllObjectInfos(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_expr = istr.readString();
        inS.endReadParams();
        ObjectInfo[] ret = obj.getAllObjectInfos(iceP_expr, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_pingNode(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        boolean ret = obj.pingNode(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getNodeLoad(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        LoadInfo ret = obj.getNodeLoad(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        LoadInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getNodeInfo(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        NodeInfo ret = obj.getNodeInfo(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        NodeInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getNodeAdmin(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        ObjectPrx ret = obj.getNodeAdmin(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getNodeProcessorSocketCount(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        int ret = obj.getNodeProcessorSocketCount(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_shutdownNode(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        obj.shutdownNode(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getNodeHostname(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        String ret = obj.getNodeHostname(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getAllNodeNames(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllNodeNames(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_pingRegistry(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        boolean ret = obj.pingRegistry(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getRegistryInfo(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        RegistryInfo ret = obj.getRegistryInfo(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        RegistryInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getRegistryAdmin(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        ObjectPrx ret = obj.getRegistryAdmin(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_shutdownRegistry(Admin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        obj.shutdownRegistry(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getAllRegistryNames(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllRegistryNames(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_shutdown(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.shutdown(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getSliceChecksums(Admin obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        Map<String, String> ret = obj.getSliceChecksums(current);
        OutputStream ostr = inS.startWriteParams();
        SliceChecksumDictHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Admin._iceD_addApplication(this, in, current);
            }
            case 1: {
                return Admin._iceD_addObject(this, in, current);
            }
            case 2: {
                return Admin._iceD_addObjectWithType(this, in, current);
            }
            case 3: {
                return Admin._iceD_enableServer(this, in, current);
            }
            case 4: {
                return Admin._iceD_getAdapterInfo(this, in, current);
            }
            case 5: {
                return Admin._iceD_getAllAdapterIds(this, in, current);
            }
            case 6: {
                return Admin._iceD_getAllApplicationNames(this, in, current);
            }
            case 7: {
                return Admin._iceD_getAllNodeNames(this, in, current);
            }
            case 8: {
                return Admin._iceD_getAllObjectInfos(this, in, current);
            }
            case 9: {
                return Admin._iceD_getAllRegistryNames(this, in, current);
            }
            case 10: {
                return Admin._iceD_getAllServerIds(this, in, current);
            }
            case 11: {
                return Admin._iceD_getApplicationInfo(this, in, current);
            }
            case 12: {
                return Admin._iceD_getDefaultApplicationDescriptor(this, in, current);
            }
            case 13: {
                return Admin._iceD_getNodeAdmin(this, in, current);
            }
            case 14: {
                return Admin._iceD_getNodeHostname(this, in, current);
            }
            case 15: {
                return Admin._iceD_getNodeInfo(this, in, current);
            }
            case 16: {
                return Admin._iceD_getNodeLoad(this, in, current);
            }
            case 17: {
                return Admin._iceD_getNodeProcessorSocketCount(this, in, current);
            }
            case 18: {
                return Admin._iceD_getObjectInfo(this, in, current);
            }
            case 19: {
                return Admin._iceD_getObjectInfosByType(this, in, current);
            }
            case 20: {
                return Admin._iceD_getRegistryAdmin(this, in, current);
            }
            case 21: {
                return Admin._iceD_getRegistryInfo(this, in, current);
            }
            case 22: {
                return Admin._iceD_getServerAdmin(this, in, current);
            }
            case 23: {
                return Admin._iceD_getServerAdminCategory(this, in, current);
            }
            case 24: {
                return Admin._iceD_getServerInfo(this, in, current);
            }
            case 25: {
                return Admin._iceD_getServerPid(this, in, current);
            }
            case 26: {
                return Admin._iceD_getServerState(this, in, current);
            }
            case 27: {
                return Admin._iceD_getSliceChecksums(this, in, current);
            }
            case 28: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 29: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 30: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 31: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 32: {
                return Admin._iceD_instantiateServer(this, in, current);
            }
            case 33: {
                return Admin._iceD_isServerEnabled(this, in, current);
            }
            case 34: {
                return Admin._iceD_patchApplication(this, in, current);
            }
            case 35: {
                return Admin._iceD_patchServer(this, in, current);
            }
            case 36: {
                return Admin._iceD_pingNode(this, in, current);
            }
            case 37: {
                return Admin._iceD_pingRegistry(this, in, current);
            }
            case 38: {
                return Admin._iceD_removeAdapter(this, in, current);
            }
            case 39: {
                return Admin._iceD_removeApplication(this, in, current);
            }
            case 40: {
                return Admin._iceD_removeObject(this, in, current);
            }
            case 41: {
                return Admin._iceD_sendSignal(this, in, current);
            }
            case 42: {
                return Admin._iceD_shutdown(this, in, current);
            }
            case 43: {
                return Admin._iceD_shutdownNode(this, in, current);
            }
            case 44: {
                return Admin._iceD_shutdownRegistry(this, in, current);
            }
            case 45: {
                return Admin._iceD_startServer(this, in, current);
            }
            case 46: {
                return Admin._iceD_stopServer(this, in, current);
            }
            case 47: {
                return Admin._iceD_syncApplication(this, in, current);
            }
            case 48: {
                return Admin._iceD_syncApplicationWithoutRestart(this, in, current);
            }
            case 49: {
                return Admin._iceD_updateApplication(this, in, current);
            }
            case 50: {
                return Admin._iceD_updateApplicationWithoutRestart(this, in, current);
            }
            case 51: {
                return Admin._iceD_updateObject(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::Admin"};
        _iceOps = new String[]{"addApplication", "addObject", "addObjectWithType", "enableServer", "getAdapterInfo", "getAllAdapterIds", "getAllApplicationNames", "getAllNodeNames", "getAllObjectInfos", "getAllRegistryNames", "getAllServerIds", "getApplicationInfo", "getDefaultApplicationDescriptor", "getNodeAdmin", "getNodeHostname", "getNodeInfo", "getNodeLoad", "getNodeProcessorSocketCount", "getObjectInfo", "getObjectInfosByType", "getRegistryAdmin", "getRegistryInfo", "getServerAdmin", "getServerAdminCategory", "getServerInfo", "getServerPid", "getServerState", "getSliceChecksums", "ice_id", "ice_ids", "ice_isA", "ice_ping", "instantiateServer", "isServerEnabled", "patchApplication", "patchServer", "pingNode", "pingRegistry", "removeAdapter", "removeApplication", "removeObject", "sendSignal", "shutdown", "shutdownNode", "shutdownRegistry", "startServer", "stopServer", "syncApplication", "syncApplicationWithoutRestart", "updateApplication", "updateApplicationWithoutRestart", "updateObject"};
    }
}

