/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.FogRetained;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

class BoundingLeafRetained
extends LeafRetained {
    static final int REGION_CHANGED = 1;
    static final Integer REGION_CHANGED_MESSAGE = new Integer(1);
    Bounds region = null;
    Bounds transformedRegion = null;
    BoundingLeafRetained mirrorBoundingLeaf;
    ArrayList users = new ArrayList();
    int targetThreads = 4224;
    int transformTargetThreads = 4160;

    BoundingLeafRetained() {
        this.nodeType = 25;
    }

    void createBoundingLeaf() {
        this.nodeType = 25;
        this.mirrorBoundingLeaf = new BoundingLeafRetained();
    }

    void initRegion(Bounds bounds) {
        this.region = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.staticTransform != null) {
            this.region.transform(this.staticTransform.transform);
        }
    }

    void setRegion(Bounds bounds) {
        this.initRegion(bounds);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = this.mirrorBoundingLeaf.targetThreads;
        j3dMessage.type = 23;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = REGION_CHANGED_MESSAGE;
        j3dMessage.args[2] = bounds != null ? (Bounds)bounds.clone() : null;
        j3dMessage.args[3] = this.mirrorBoundingLeaf.users.toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    Bounds getRegion() {
        Bounds bounds = null;
        if (this.region != null) {
            bounds = (Bounds)this.region.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    @Override
    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("BoundingLeafRetained0"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BoundingLeafRetained1"));
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this.mirrorBoundingLeaf, 5);
            setLiveState.notifyThreads |= 0x2000;
        }
        this.mirrorBoundingLeaf.localToVworld = new Transform3D[1][];
        this.mirrorBoundingLeaf.localToVworldIndex = new int[1][];
        this.mirrorBoundingLeaf.localToVworld[0] = this.localToVworld[0];
        this.mirrorBoundingLeaf.localToVworldIndex[0] = this.localToVworldIndex[0];
        this.mirrorBoundingLeaf.parent = this.parent;
        if (this.region != null) {
            this.mirrorBoundingLeaf.region = (Bounds)this.region.clone();
            this.mirrorBoundingLeaf.transformedRegion = (Bounds)this.region.clone();
            this.mirrorBoundingLeaf.transformedRegion.transform(this.mirrorBoundingLeaf.getCurrentLocalToVworld());
        } else {
            this.mirrorBoundingLeaf.region = null;
            this.mirrorBoundingLeaf.transformedRegion = null;
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this.mirrorBoundingLeaf, 5);
        }
        this.mirrorBoundingLeaf.switchState = setLiveState.switchStates.get(0);
        super.markAsLive();
    }

    synchronized void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        Bounds bounds = (Bounds)objectArray[2];
        if ((n & 1) != 0) {
            this.mirrorBoundingLeaf.region = bounds;
            if (bounds != null) {
                this.mirrorBoundingLeaf.transformedRegion = (Bounds)bounds.clone();
                Transform3D transform3D = this.mirrorBoundingLeaf.getCurrentLocalToVworld();
                this.mirrorBoundingLeaf.transformedRegion.transform(bounds, transform3D);
            } else {
                this.mirrorBoundingLeaf.transformedRegion = null;
            }
        }
    }

    synchronized void addUser(LeafRetained leafRetained) {
        this.users.add(leafRetained);
        if (leafRetained.nodeType == 1 || leafRetained.nodeType == 2 || leafRetained.nodeType == 27 || leafRetained instanceof FogRetained || leafRetained instanceof LightRetained) {
            this.transformTargetThreads |= 0x80;
        } else if (leafRetained instanceof BehaviorRetained) {
            this.transformTargetThreads |= 0x100;
            this.targetThreads |= 0x100;
        } else if (leafRetained instanceof SoundRetained || leafRetained.nodeType == 15) {
            this.transformTargetThreads |= 0x200;
        }
    }

    synchronized void removeUser(LeafRetained leafRetained) {
        this.users.remove(this.users.indexOf(leafRetained));
        this.transformTargetThreads = 4096;
        this.targetThreads = 4224;
        for (int i = 0; i < this.users.size(); ++i) {
            LeafRetained leafRetained2 = (LeafRetained)this.users.get(i);
            if (leafRetained2.nodeType == 1 || leafRetained2.nodeType == 2 || leafRetained2.nodeType == 27 || leafRetained2 instanceof FogRetained || leafRetained2 instanceof LightRetained) {
                this.transformTargetThreads |= 0x80;
                continue;
            }
            if (leafRetained2.nodeType == 17) {
                this.transformTargetThreads |= 0x100;
                this.targetThreads |= 0x100;
                continue;
            }
            if (!(leafRetained2 instanceof SoundRetained) && leafRetained2.nodeType != 15) continue;
            this.transformTargetThreads |= 0x200;
        }
    }

    void updateImmediateTransformChange() {
        Transform3D transform3D = this.getCurrentLocalToVworld();
        if (this.region != null) {
            this.transformedRegion.transform(this.region, transform3D);
        }
    }

    @Override
    void clearLive(SetLiveState setLiveState) {
        super.clearLive();
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this.mirrorBoundingLeaf, 5);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this.mirrorBoundingLeaf, 5);
            setLiveState.notifyThreads |= 0x2000;
        }
    }

    @Override
    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        this.region.transform(transformGroupRetained.transform);
    }
}

