/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.util.concurrency.Semaphore;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolBeforeRunTask<ToolBeforeRunTask extends AbstractToolBeforeRunTask, T extends Tool>
extends BeforeRunTask<ToolBeforeRunTask> {
    @NonNls
    private static final String ACTION_ID_ATTRIBUTE = "actionId";
    private static final Logger LOG = Logger.getInstance(AbstractToolBeforeRunTask.class);
    protected String myToolActionId;

    public AbstractToolBeforeRunTask(Key<ToolBeforeRunTask> providerId) {
        super(providerId);
    }

    @Nullable
    public String getToolActionId() {
        return this.myToolActionId;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            AbstractToolBeforeRunTask.$$$reportNull$$$0(0);
        }
        super.writeExternal(element);
        if (this.myToolActionId != null) {
            element.setAttribute(ACTION_ID_ATTRIBUTE, this.myToolActionId);
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            AbstractToolBeforeRunTask.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        this.myToolActionId = element.getAttributeValue(ACTION_ID_ATTRIBUTE);
    }

    public ToolBeforeRunTask clone() {
        return (ToolBeforeRunTask)((Object)((AbstractToolBeforeRunTask)super.clone()));
    }

    public void setToolActionId(String toolActionId) {
        this.myToolActionId = toolActionId;
    }

    public boolean isExecutable() {
        return this.myToolActionId != null;
    }

    public boolean execute(DataContext context, long executionId) {
        T tool = this.findCorrespondingTool();
        if (tool != null && !((Tool)tool).isEnabled()) {
            return true;
        }
        final Semaphore targetDone = new Semaphore();
        final Ref result2 = new Ref((Object)false);
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> ToolAction.runTool(this.myToolActionId, context, null, executionId, (ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    targetDone.down();
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    result2.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                    targetDone.up();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/tools/AbstractToolBeforeRunTask$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }), ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        targetDone.waitFor();
        return (Boolean)result2.get();
    }

    @Nullable
    public T findCorrespondingTool() {
        if (this.myToolActionId == null) {
            return null;
        }
        List<T> tools = this.getTools();
        for (Tool tool : tools) {
            if (!this.myToolActionId.equals(tool.getActionId())) continue;
            return (T)tool;
        }
        return null;
    }

    protected abstract List<T> getTools();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/tools/AbstractToolBeforeRunTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

