/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PluginPathManager {
    private PluginPathManager() {
    }

    public static File getPluginHome(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            return subrepo;
        }
        return new File(PathManager.getHomePath(), "plugins/" + pluginName);
    }

    private static File findSubrepo(String pluginName) {
        for (File subrepo : SubrepoHolder.subrepos) {
            File candidate = new File(subrepo, pluginName);
            if (!candidate.isDirectory()) continue;
            return candidate;
        }
        return null;
    }

    public static String getPluginHomePath(String pluginName) {
        return PluginPathManager.getPluginHome(pluginName).getPath();
    }

    public static String getPluginHomePathRelative(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
            return "/" + FileUtil.getRelativePath((String)homePath, (String)FileUtil.toSystemIndependentName((String)subrepo.getPath()), (char)'/');
        }
        return "/plugins/" + pluginName;
    }

    private static class SubrepoHolder {
        public static List<File> subrepos = SubrepoHolder.findSubrepos();

        private SubrepoHolder() {
        }

        private static List<File> findSubrepos() {
            File[] gitRoots;
            ArrayList<File> result2 = new ArrayList<File>();
            for (File subdir : gitRoots = SubrepoHolder.getSortedGitRoots(new File(PathManager.getHomePath()))) {
                File pluginsDir = new File(subdir, "plugins");
                if (pluginsDir.exists()) {
                    result2.add(pluginsDir);
                } else {
                    result2.add(subdir);
                }
                result2.addAll(Arrays.asList(SubrepoHolder.getSortedGitRoots(subdir)));
            }
            return result2;
        }

        @NotNull
        private static File[] getSortedGitRoots(@NotNull File dir) {
            File[] gitRoots;
            if (dir == null) {
                SubrepoHolder.$$$reportNull$$$0(0);
            }
            if ((gitRoots = dir.listFiles(child2 -> child2.isDirectory() && new File(child2, ".git").exists())) == null) {
                File[] fileArray = new File[]{};
                if (fileArray == null) {
                    SubrepoHolder.$$$reportNull$$$0(1);
                }
                return fileArray;
            }
            Arrays.sort(gitRoots, (file2, file22) -> FileUtil.compareFiles((File)file2, (File)file22));
            if (gitRoots == null) {
                SubrepoHolder.$$$reportNull$$$0(2);
            }
            return gitRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/PluginPathManager$SubrepoHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/PluginPathManager$SubrepoHolder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedGitRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortedGitRoots";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

