/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.admin;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.IRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.request.ResponseExpectingRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public class AdminCommand
extends AbstractCommand {
    private boolean setLock;
    private boolean resetLock;

    protected void resetCvsCommand() {
        super.resetCvsCommand();
        this.setSetLock(false);
        this.setResetLock(false);
    }

    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        BugLog.getInstance().assertTrue(this.isSetLock() || this.isResetLock(), "Nothing specified");
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests((ResponseExpectingRequest)CommandRequest.ADMIN, clientEnvironment);
        requests.addArgumentRequest(this.isSetLock(), "-l");
        requests.addArgumentRequest(this.isResetLock(), "-u");
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        IRequestsProgressHandler requestsProgressHandler = FileStateRequestsProgressHandler.create((IProgressViewer)progressViewer, (ICvsFiles)cvsFiles);
        return requestProcessor.processRequests(requests, requestsProgressHandler);
    }

    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("admin ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    public boolean isSetLock() {
        return this.setLock;
    }

    public void setSetLock(boolean setLock) {
        this.setLock = setLock;
    }

    public boolean isResetLock() {
        return this.resetLock;
    }

    public void setResetLock(boolean resetLock) {
        this.resetLock = resetLock;
    }

    private String getCvsArguments() {
        StringBuilder arguments = new StringBuilder();
        if (this.isSetLock()) {
            arguments.append("-l ");
        }
        if (this.isResetLock()) {
            arguments.append("-u ");
        }
        return arguments.toString();
    }
}

