/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReadEnv;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EnvironmentUtil");
    private static final int SHELL_ENV_READING_TIMEOUT = 20000;
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final Future<Map<String, String>> ourEnvGetter = SystemInfo.isMac && "unlocked".equals(System.getProperty("__idea.mac.env.lock")) && SystemProperties.getBooleanProperty("idea.fix.mac.env", true) ? AppExecutorUtil.getAppExecutorService().submit(new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            return Collections.unmodifiableMap(EnvironmentUtil.setCharsetVar(EnvironmentUtil.getShellEnv()));
        }
    }) : new FixedFuture<Map<String, String>>(EnvironmentUtil.getSystemEnv());
    private static final NotNullLazyValue<Map<String, String>> ourEnvironment = new AtomicNotNullLazyValue<Map<String, String>>(){

        @Override
        @NotNull
        protected Map<String, String> compute() {
            Map map;
            try {
                map = (Map)ourEnvGetter.get();
            }
            catch (Throwable t) {
                LOG.warn("can't get shell environment", t);
                Map map2 = EnvironmentUtil.getSystemEnv();
                if (map2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map2;
            }
            if (map == null) {
                2.$$$reportNull$$$0(0);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$2", "compute"));
        }
    };
    private static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    private static final String INTELLIJ_ENVIRONMENT_READER = "INTELLIJ_ENVIRONMENT_READER";

    private static Map<String, String> getSystemEnv() {
        if (SystemInfo.isWindows) {
            return Collections.unmodifiableMap(new THashMap(System.getenv(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
        }
        return System.getenv();
    }

    private EnvironmentUtil() {
    }

    public static boolean isEnvironmentReady() {
        return ourEnvGetter.isDone();
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map = ourEnvironment.getValue();
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            EnvironmentUtil.$$$reportNull$$$0(1);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    public static String[] getEnvironment() {
        return EnvironmentUtil.flattenEnvironment(EnvironmentUtil.getEnvironmentMap());
    }

    public static String[] flattenEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            EnvironmentUtil.$$$reportNull$$$0(2);
        }
        String[] array = new String[environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            array[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return array;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty() && name.indexOf(0) == -1 && name.indexOf(61, SystemInfo.isWindows ? 1 : 0) == -1;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.indexOf(0) == -1;
    }

    private static Map<String, String> getShellEnv() throws Exception {
        return new ShellEnvReader().readShellEnv();
    }

    @NotNull
    public static Map<String, String> parseEnv(String ... lines) throws Exception {
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL", DISABLE_OMZ_AUTO_UPDATE, INTELLIJ_ENVIRONMENT_READER));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new Exception("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            EnvironmentUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, String> parseEnv(String text) throws Exception {
        String[] lines = text.split("\u0000");
        Map<String, String> map = EnvironmentUtil.parseEnv(lines);
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return map;
    }

    private static int waitAndTerminateAfter(@NotNull Process process, int timeoutMillis) {
        Integer exitCode;
        if (process == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        if ((exitCode = EnvironmentUtil.waitFor(process, timeoutMillis)) != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        if (!SystemInfo.isWindows) {
            UnixProcessManager.sendSigIntToProcessTree(process);
            exitCode = EnvironmentUtil.waitFor(process, 1000);
            if (exitCode != null) {
                return exitCode;
            }
            LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        }
        if (SystemInfo.isWindows) {
            WinProcessManager.kill(process, true);
        } else {
            UnixProcessManager.sendSigKillToProcessTree(process);
        }
        exitCode = EnvironmentUtil.waitFor(process, 1000);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process, int timeoutMillis) {
        if (process == null) {
            EnvironmentUtil.$$$reportNull$$$0(6);
        }
        long stop = System.currentTimeMillis() + (long)timeoutMillis;
        while (System.currentTimeMillis() < stop) {
            TimeoutUtil.sleep(100L);
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
        return null;
    }

    private static Map<String, String> setCharsetVar(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(7);
        }
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            String value = EnvironmentUtil.setLocaleEnv(env, CharsetToolkit.getDefaultSystemCharset());
            LOG.info("LC_CTYPE=" + value);
        }
        return env;
    }

    private static boolean checkIfLocaleAvailable(String candidateLanguageTerritory) {
        Locale[] available;
        for (Locale l : available = Locale.getAvailableLocales()) {
            if (!StringUtil.equals(l.toString(), candidateLanguageTerritory)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        String languageTerritoryFromLocale;
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(8);
        }
        if (charset == null) {
            EnvironmentUtil.$$$reportNull$$$0(9);
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String languageTerritory = "en_US";
        if (!language.isEmpty() && !country.isEmpty() && EnvironmentUtil.checkIfLocaleAvailable(languageTerritoryFromLocale = language + '_' + country)) {
            languageTerritory = languageTerritoryFromLocale;
        }
        String result = languageTerritory + '.' + charset.name();
        env.put(LC_CTYPE, result);
        String string = result;
        if (string == null) {
            EnvironmentUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(11);
        }
        return !env.isEmpty() && (env.containsKey(LANG) || env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE));
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(12);
        }
        EnvironmentUtil.inlineParentOccurrences(envs, EnvironmentUtil.getEnvironmentMap());
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs, @NotNull Map<String, String> parentEnv) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(13);
        }
        if (parentEnv == null) {
            EnvironmentUtil.$$$reportNull$$$0(14);
        }
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = parentEnv.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    private static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    static Map<String, String> testLoader() {
        try {
            return EnvironmentUtil.getShellEnv();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, String> testParser(@NotNull String lines) {
        if (lines == null) {
            EnvironmentUtil.$$$reportNull$$$0(15);
        }
        try {
            return EnvironmentUtil.parseEnv(lines);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "flattenEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StreamGobbler
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean splitToLines() {
                return false;
            }
        };
        private final StringBuffer myBuffer;

        StreamGobbler(@NotNull InputStream stream) {
            if (stream == null) {
                StreamGobbler.$$$reportNull$$$0(0);
            }
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myBuffer = new StringBuffer();
            this.start("stdout/stderr streams of shell env loading process");
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                StreamGobbler.$$$reportNull$$$0(1);
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(runnable);
            if (future == null) {
                StreamGobbler.$$$reportNull$$$0(2);
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                StreamGobbler.$$$reportNull$$$0(3);
            }
            this.myBuffer.append(text);
        }

        @NotNull
        public String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                StreamGobbler.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$StreamGobbler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$StreamGobbler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ShellEnvReader {
        public Map<String, String> readShellEnv() throws Exception {
            return this.readShellEnv(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> readShellEnv(@Nullable Map<String, String> additionalEnvironment) throws Exception {
            File reader = PathManager.findBinFileWithException("printenv.py");
            File envFile = FileUtil.createTempFile("intellij-shell-env.", ".tmp", false);
            try {
                List<String> command = this.getShellProcessCommand();
                int idx = command.indexOf("-c");
                if (idx >= 0) {
                    command.set(idx + 1, command.get(idx + 1) + ";'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                } else {
                    command.add("-c");
                    command.add("'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                }
                LOG.info("loading shell env: " + StringUtil.join(command, " "));
                Map map = (Map)ShellEnvReader.runProcessAndReadOutputAndEnvs(command, null, additionalEnvironment, (File)envFile).second;
                return map;
            }
            finally {
                FileUtil.delete(envFile);
            }
        }

        @NotNull
        public Map<String, String> readBatEnv(@NotNull File batchFile, List<String> args) throws Exception {
            if (batchFile == null) {
                ShellEnvReader.$$$reportNull$$$0(0);
            }
            Map map = (Map)this.readBatOutputAndEnv((File)batchFile, args).second;
            if (map == null) {
                ShellEnvReader.$$$reportNull$$$0(1);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected Pair<String, Map<String, String>> readBatOutputAndEnv(@NotNull File batchFile, List<String> args) throws Exception {
            if (batchFile == null) {
                ShellEnvReader.$$$reportNull$$$0(2);
            }
            File envFile = FileUtil.createTempFile("intellij-cmd-env.", ".tmp", false);
            ArrayList<String> cl = new ArrayList<String>();
            cl.add(CommandLineUtil.getWinShellName());
            cl.add("/c");
            cl.add("call");
            cl.add(batchFile.getPath());
            cl.addAll(args);
            cl.add("&&");
            cl.addAll(ShellEnvReader.getReadEnvCommand());
            cl.add(envFile.getPath());
            cl.addAll(Arrays.asList("||", "exit", "/B", "%ERRORLEVEL%"));
            Pair<String, Map<String, String>> pair = ShellEnvReader.runProcessAndReadOutputAndEnvs(cl, batchFile.getParentFile(), null, envFile);
            Pair<String, Map<String, String>> pair2 = pair;
            if (pair2 == null) {
                ShellEnvReader.$$$reportNull$$$0(3);
            }
            return pair2;
            finally {
                FileUtil.delete(envFile);
            }
        }

        @NotNull
        private static List<String> getReadEnvCommand() {
            List<String> list = Arrays.asList(FileUtil.toSystemDependentName(System.getProperty("java.home") + "/bin/java"), "-cp", PathManager.getJarPathForClass(ReadEnv.class), ReadEnv.class.getCanonicalName());
            if (list == null) {
                ShellEnvReader.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        protected static Pair<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command, @Nullable File workingDir, @Nullable Map<String, String> scriptEnvironment, @NotNull File envFile) throws Exception {
            if (command == null) {
                ShellEnvReader.$$$reportNull$$$0(5);
            }
            if (envFile == null) {
                ShellEnvReader.$$$reportNull$$$0(6);
            }
            ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
            if (scriptEnvironment != null) {
                builder.environment().putAll(scriptEnvironment);
            }
            if (workingDir != null) {
                builder.directory(workingDir);
            }
            builder.environment().put(EnvironmentUtil.DISABLE_OMZ_AUTO_UPDATE, "true");
            builder.environment().put(EnvironmentUtil.INTELLIJ_ENVIRONMENT_READER, "true");
            Process process = builder.start();
            StreamGobbler gobbler = new StreamGobbler(process.getInputStream());
            int rv = EnvironmentUtil.waitAndTerminateAfter(process, 20000);
            gobbler.stop();
            String lines = FileUtil.loadFile(envFile);
            if (rv != 0 || lines.isEmpty()) {
                throw new Exception("rv:" + rv + " text:" + lines.length() + " out:" + StringUtil.trimEnd(gobbler.getText(), '\n'));
            }
            Pair<String, Map<String, String>> pair = Pair.create(gobbler.getText(), EnvironmentUtil.parseEnv(lines));
            if (pair == null) {
                ShellEnvReader.$$$reportNull$$$0(7);
            }
            return pair;
        }

        @NotNull
        protected List<String> getShellProcessCommand() throws Exception {
            String shell = this.getShell();
            if (shell == null || !new File(shell).canExecute()) {
                throw new Exception("shell:" + shell);
            }
            ArrayList<String> commands = ContainerUtil.newArrayList(new String[]{shell});
            if (!shell.endsWith("/tcsh") && !shell.endsWith("/csh")) {
                commands.add("-l");
            }
            commands.add("-i");
            ArrayList<String> arrayList = commands;
            if (arrayList == null) {
                ShellEnvReader.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        @Nullable
        protected String getShell() {
            return System.getenv("SHELL");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "batchFile";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBatEnv";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBatOutputAndEnv";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadEnvCommand";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runProcessAndReadOutputAndEnvs";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShellProcessCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readBatEnv";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "readBatOutputAndEnv";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "runProcessAndReadOutputAndEnvs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

