/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.util;

import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecVersionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SpecVersionUtils.class);
    public static final int EXPECTED_HEADER_LENGTH = 8;
    public static final String PDF_HEADER = "%PDF-";
    public static final String V1_0 = "1.0";
    public static final String V1_1 = "1.1";
    public static final String V1_2 = "1.2";
    public static final String V1_3 = "1.3";
    public static final String V1_4 = "1.4";
    public static final String V1_5 = "1.5";
    public static final String V1_6 = "1.6";
    public static final String V1_7 = "1.7";
    public static final String V2_0 = "2.0";
    private static final String VERSION_PATTERN = "^(\\d)\\.(\\d)$";

    private SpecVersionUtils() {
    }

    public static String parseHeaderString(String header) {
        String version = SpecVersionUtils.sanitizeVersion(header.substring(5, 8));
        if (!version.matches(VERSION_PATTERN)) {
            LOG.warn("Invalid header version {}, falling back to {}", (Object)version, (Object)V1_6);
            return V1_6;
        }
        return version;
    }

    private static String sanitizeVersion(String version) {
        return version.replace(',', '.');
    }

    public static boolean isAtLeast(String version, String atLeast) {
        RequireUtils.requireNotNullArg((Object)version, (String)"Cannot compare a null version");
        RequireUtils.requireNotNullArg((Object)atLeast, (String)"Cannot compare a null version");
        return version.compareTo(atLeast) >= 0;
    }
}

