/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;

public abstract class PDTerminalField
extends PDField {
    protected PDTerminalField(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDTerminalField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public void setActions(PDFormFieldAdditionalActions actions) {
        this.getCOSObject().setItem(COSName.AA, (COSObjectable)actions);
    }

    @Override
    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getCOSObject().getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        } else if (this.getParent() != null) {
            retval = this.getParent().getFieldFlags();
        }
        return retval;
    }

    @Override
    public String getFieldType() {
        String fieldType = this.getCOSObject().getNameAsString(COSName.FT);
        if (fieldType == null && this.getParent() != null) {
            fieldType = this.getParent().getFieldType();
        }
        return fieldType;
    }

    @Override
    public List<PDAnnotationWidget> getWidgets() {
        COSArray kids = this.getCOSObject().getDictionaryObject(COSName.KIDS, COSArray.class);
        if (Objects.isNull(kids)) {
            return Arrays.asList(new PDAnnotationWidget(this.getCOSObject()));
        }
        if (kids.size() > 0) {
            return kids.stream().filter(k -> Objects.nonNull(k)).map(k -> k.getCOSObject()).filter(k -> k instanceof COSDictionary).map(k -> new PDAnnotationWidget((COSDictionary)k)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void addWidgetIfMissing(PDAnnotationWidget widget) {
        if (Objects.nonNull(widget)) {
            COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
            if (kids == null) {
                kids = new COSArray(widget.getCOSObject());
                widget.getCOSObject().setItem(COSName.PARENT, (COSObjectable)this);
                this.getCOSObject().setItem(COSName.KIDS, (COSBase)kids);
            } else if (!kids.contains(widget.getCOSObject())) {
                kids.add(widget.getCOSObject());
                widget.getCOSObject().setItem(COSName.PARENT, (COSObjectable)this);
            }
        }
    }

    public void setWidgets(List<PDAnnotationWidget> children) {
        this.getCOSObject().setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(children));
        for (PDAnnotationWidget widget : children) {
            widget.getCOSObject().setItem(COSName.PARENT, (COSObjectable)this);
        }
    }

    protected final void applyChange() throws IOException {
        this.constructAppearances();
    }

    abstract void constructAppearances() throws IOException;

    @Override
    public boolean isTerminal() {
        return true;
    }
}

