/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.PrefixTypesChain;
import org.sejda.core.support.prefix.processor.PrefixUtils;

public final class NameGenerator {
    private String prefix;
    private PrefixTypesChain prefixTypesChain;

    private NameGenerator(String prefix) {
        this.prefix = StringUtils.defaultString((String)prefix);
        this.prefixTypesChain = new PrefixTypesChain(prefix);
    }

    public static NameGenerator nameGenerator(String prefix) {
        return new NameGenerator(prefix);
    }

    public String generate(NameGenerationRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Unable to generate a name for a null request.");
        }
        String result = PrefixUtils.toSafeFilename(this.prefixTypesChain.process(this.prefix, this.preProcessRequest(request)));
        String osName = System.getProperty("os.name").toLowerCase();
        result = osName.contains("win") || osName.contains("mac") ? NameGenerator.shortenFilenameCharLength(result, 255) : NameGenerator.shortenFilenameBytesLength(result, 255, StandardCharsets.UTF_8);
        return result;
    }

    static String shortenFilenameCharLength(String input, int maxCharLength) {
        if (input.length() > 255) {
            String baseName = FilenameUtils.getBaseName((String)input);
            String ext = FilenameUtils.getExtension((String)input);
            baseName = baseName.substring(0, 254 - ext.length());
            return String.format("%s.%s", baseName, ext);
        }
        return input;
    }

    static String shortenFilenameBytesLength(String input, int maxBytesLength, Charset charset) {
        if (input.getBytes(charset).length > maxBytesLength) {
            String baseName = FilenameUtils.getBaseName((String)input);
            String ext = FilenameUtils.getExtension((String)input);
            baseName = baseName.substring(0, baseName.length() - 1);
            String shorterFilename = String.format("%s.%s", baseName, ext);
            while (shorterFilename.getBytes(charset).length > maxBytesLength) {
                baseName = baseName.substring(0, baseName.length() - 1);
                shorterFilename = String.format("%s.%s", baseName, ext);
            }
            return shorterFilename;
        }
        return input;
    }

    private NameGenerationRequest preProcessRequest(NameGenerationRequest request) {
        NameGenerationRequest retVal = request;
        if (request == null) {
            retVal = NameGenerationRequest.nameRequest();
        }
        return retVal;
    }
}

