/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.BlockDecomposerTransformer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "decomposerTransformer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerTransformer;", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "lower", "", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "irField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "container", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "toBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "containingFunction", "backend.js"})
public final class BlockDecomposerLowering
implements DeclarationContainerLoweringPass {
    private final BlockDecomposerTransformer decomposerTransformer;
    private final IrType nothingType;

    @Override
    public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
        Intrinsics.checkParameterIsNotNull(irDeclarationContainer, "irDeclarationContainer");
        TransformKt.transformDeclarationsFlat(irDeclarationContainer, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this, irDeclarationContainer){
            final /* synthetic */ BlockDecomposerLowering this$0;
            final /* synthetic */ IrDeclarationContainer $irDeclarationContainer;

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration declaration) {
                List<IrDeclaration> list2;
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                IrDeclaration irDeclaration = declaration;
                if (irDeclaration instanceof IrFunction) {
                    this.this$0.lower((IrFunction)declaration);
                    list2 = CollectionsKt.listOf(declaration);
                } else {
                    list2 = irDeclaration instanceof IrField ? this.this$0.lower((IrField)declaration, this.$irDeclarationContainer) : CollectionsKt.listOf(declaration);
                }
                return list2;
            }
            {
                this.this$0 = blockDecomposerLowering;
                this.$irDeclarationContainer = irDeclarationContainer;
                super(1);
            }
        });
    }

    public final void lower(@NotNull IrFunction irFunction) {
        Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
        IrBody irBody = irFunction.getBody();
        if (!(irBody instanceof IrExpressionBody)) {
            irBody = null;
        }
        IrExpressionBody irExpressionBody = (IrExpressionBody)irBody;
        if (irExpressionBody != null) {
            IrExpressionBody irExpressionBody2 = irExpressionBody;
            boolean bl = false;
            boolean bl2 = false;
            IrExpressionBody $this$apply = irExpressionBody2;
            boolean bl3 = false;
            irFunction.setBody(this.toBlockBody($this$apply, irFunction));
        }
        irFunction.accept(this.decomposerTransformer, null);
    }

    private final IrBlockBody toBlockBody(@NotNull IrExpressionBody $this$toBlockBody, IrFunction containingFunction) {
        PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$toBlockBody.getExpression(), containingFunction);
        IrReturnImpl returnStatement = JsIrBuilder.INSTANCE.buildReturn(containingFunction.getSymbol(), $this$toBlockBody.getExpression(), this.nothingType);
        IrBlockBodyImpl irBlockBodyImpl = new IrBlockBodyImpl($this$toBlockBody.getExpression().getStartOffset(), $this$toBlockBody.getExpression().getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        IrBlockBodyImpl $this$apply = irBlockBodyImpl;
        boolean bl3 = false;
        Collection collection = $this$apply.getStatements();
        IrReturnImpl irReturnImpl = returnStatement;
        boolean bl4 = false;
        collection.add(irReturnImpl);
        return irBlockBodyImpl;
    }

    @NotNull
    public final List<IrDeclaration> lower(@NotNull IrField irField, @NotNull IrDeclarationContainer container2) {
        Intrinsics.checkParameterIsNotNull(irField, "irField");
        Intrinsics.checkParameterIsNotNull(container2, "container");
        IrExpressionBody irExpressionBody = irField.getInitializer();
        if (irExpressionBody != null) {
            IrExpressionBody irExpressionBody2 = irExpressionBody;
            boolean bl = false;
            boolean bl2 = false;
            IrExpressionBody $this$apply = irExpressionBody2;
            boolean bl3 = false;
            IrSimpleFunction initFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, irField.getName().asString() + "$init$", $this$apply.getExpression().getType(), (IrDeclarationParent)container2, irField.getVisibility(), null, false, false, false, false, null, 1008, null);
            IrBlockBody newBody = this.toBlockBody($this$apply, initFunction);
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)newBody, initFunction);
            initFunction.setBody(newBody);
            this.lower(initFunction);
            IrStatement lastStatement = CollectionsKt.last(newBody.getStatements());
            if (newBody.getStatements().size() > 1 || !(lastStatement instanceof IrReturn) || Intrinsics.areEqual(((IrReturn)lastStatement).getValue(), $this$apply.getExpression()) ^ true) {
                $this$apply.setExpression(JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, initFunction.getSymbol(), $this$apply.getExpression().getType(), null, 4, null));
                return CollectionsKt.listOf(initFunction, irField);
            }
        }
        return CollectionsKt.listOf(irField);
    }

    public BlockDecomposerLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.decomposerTransformer = new BlockDecomposerTransformer(context);
        this.nothingType = context.getIrBuiltIns().getNothingType();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        DeclarationContainerLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

