'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaDatatable = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var kibanaDatatable = exports.kibanaDatatable = function kibanaDatatable() {
  return {
    name: 'kibana_datatable',
    from: {
      datatable: function datatable(context) {
        context.columns.forEach(function (c) {
          return c.id = c.name;
        });
        return {
          type: 'kibana_datatable',
          rows: context.rows,
          columns: context.columns
        };
      },
      pointseries: function pointseries(context) {
        var columns = (0, _lodash.map)(context.columns, function (column, name) {
          return (0, _extends3.default)({ id: name, name: name }, column);
        });
        return {
          type: 'kibana_datatable',
          rows: context.rows,
          columns: columns
        };
      }
    }
  };
}; /*
    * Licensed to Elasticsearch B.V. under one or more contributor
    * license agreements. See the NOTICE file distributed with
    * this work for additional information regarding copyright
    * ownership. Elasticsearch B.V. licenses this file to you under
    * the Apache License, Version 2.0 (the "License"); you may
    * not use this file except in compliance with the License.
    * You may obtain a copy of the License at
    *
    *    http://www.apache.org/licenses/LICENSE-2.0
    *
    * Unless required by applicable law or agreed to in writing,
    * software distributed under the License is distributed on an
    * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    * KIND, either express or implied.  See the License for the
    * specific language governing permissions and limitations
    * under the License.
    */