/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import javajs.util.DF;
import javajs.util.Lst;
import jspecview.common.CoordComparator;
import jspecview.common.Spectrum;
import jspecview.common.ViewData;

public class Coordinate {
    private double xVal = 0.0;
    private double yVal = 0.0;
    private static final Comparator<Coordinate> c = new CoordComparator();

    public Coordinate set(double d, double d2) {
        this.xVal = d;
        this.yVal = d2;
        return this;
    }

    public double getXVal() {
        return this.xVal;
    }

    public double getYVal() {
        return this.yVal;
    }

    public String getXString() {
        return DF.formatDecimalTrimmed(this.xVal, 8);
    }

    public String getYString() {
        return DF.formatDecimalTrimmed(this.yVal, 8);
    }

    public void setXVal(double d) {
        this.xVal = d;
    }

    public void setYVal(double d) {
        this.yVal = d;
    }

    public Coordinate copy() {
        return new Coordinate().set(this.xVal, this.yVal);
    }

    public boolean equals(Coordinate coordinate) {
        return coordinate.xVal == this.xVal && coordinate.yVal == this.yVal;
    }

    public String toString() {
        return "[" + this.xVal + ", " + this.yVal + "]";
    }

    public static boolean isYInRange(Coordinate[] coordinateArray, double d, double d2) {
        return Coordinate.getMinY(coordinateArray, 0, coordinateArray.length) >= d && Coordinate.getMaxY(coordinateArray, 0, coordinateArray.length) >= d2;
    }

    public static Coordinate[] normalise(Coordinate[] coordinateArray, double d, double d2) {
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        double d3 = Coordinate.getMinY(coordinateArray, 0, coordinateArray.length);
        double d4 = Coordinate.getMaxY(coordinateArray, 0, coordinateArray.length);
        double d5 = (d4 - d3) / (d2 - d);
        int n = 0;
        while (n < coordinateArray.length) {
            coordinateArray2[n] = new Coordinate().set(coordinateArray[n].getXVal(), (coordinateArray[n].getYVal() - d3) / d5 - d);
            ++n;
        }
        return coordinateArray2;
    }

    public static Coordinate[] reverse(Coordinate[] coordinateArray) {
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            coordinateArray[n2] = coordinateArray[--n];
            coordinateArray[n] = coordinate;
            ++n2;
        }
        return coordinateArray;
    }

    public static Coordinate[] parseDSV(String string, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        Lst<Coordinate> lst = new Lst<Coordinate>();
        String string2 = " \t\n\r\f,;";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer.nextToken().trim();
            d3 = Double.parseDouble(string3);
            d4 = Double.parseDouble(string4);
            Coordinate coordinate = new Coordinate().set(d3 * d, d4 * d2);
            lst.addLast(coordinate);
        }
        Coordinate[] coordinateArray = new Coordinate[lst.size()];
        return lst.toArray(coordinateArray);
    }

    public static double deltaX(double d, double d2, int n) {
        double d3 = (d - d2) / (double)(n - 1);
        return d3;
    }

    public static void removeScale(Coordinate[] coordinateArray, double d, double d2) {
        Coordinate.applyScale(coordinateArray, 1.0 / d, 1.0 / d2);
    }

    public static void applyScale(Coordinate[] coordinateArray, double d, double d2) {
        if (d != 1.0 || d2 != 1.0) {
            int n = 0;
            while (n < coordinateArray.length) {
                coordinateArray[n].setXVal(coordinateArray[n].getXVal() * d);
                coordinateArray[n].setYVal(coordinateArray[n].getYVal() * d2);
                ++n;
            }
        }
    }

    public static void applyShiftReference(Coordinate[] coordinateArray, int n, double d, double d2, double d3, double d4, int n2) throws IndexOutOfBoundsException {
        if (n > coordinateArray.length || n < 0) {
            return;
        }
        switch (n2) {
            case 0: {
                d3 = coordinateArray[coordinateArray.length - n].getXVal() - d3 * d4;
                break;
            }
            case 1: {
                d3 = d - d3 * d4;
                break;
            }
            case 2: {
                d3 = d2 + d3;
            }
        }
        int n3 = 0;
        while (n3 < coordinateArray.length) {
            Coordinate coordinate = coordinateArray[n3];
            coordinate.setXVal(coordinate.getXVal() - d3);
            coordinateArray[n3] = coordinate;
            ++n3;
        }
        d -= d3;
        d2 -= d3;
    }

    public static double getMinX(Coordinate[] coordinateArray, int n, int n2) {
        double d = Double.MAX_VALUE;
        int n3 = n;
        while (n3 < n2) {
            double d2 = coordinateArray[n3].getXVal();
            if (d2 < d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static double getMinX(Lst<Spectrum> lst, ViewData viewData) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < lst.size()) {
            Coordinate[] coordinateArray = ((Spectrum)lst.get(n)).getXYCoords();
            double d2 = Coordinate.getMinX(coordinateArray, viewData.getStartingPointIndex(n), viewData.getEndingPointIndex(n));
            if (d2 < d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public static double getMaxX(Coordinate[] coordinateArray, int n, int n2) {
        double d = -1.7976931348623157E308;
        int n3 = n;
        while (n3 < n2) {
            double d2 = coordinateArray[n3].getXVal();
            if (d2 > d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static double getMaxX(Lst<Spectrum> lst, ViewData viewData) {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < lst.size()) {
            Coordinate[] coordinateArray = ((Spectrum)lst.get(n)).getXYCoords();
            double d2 = Coordinate.getMaxX(coordinateArray, viewData.getStartingPointIndex(n), viewData.getEndingPointIndex(n));
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public static double getMinY(Coordinate[] coordinateArray, int n, int n2) {
        double d = Double.MAX_VALUE;
        int n3 = n;
        while (n3 < n2) {
            double d2 = coordinateArray[n3].getYVal();
            if (d2 < d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static double getMinYUser(Lst<Spectrum> lst, ViewData viewData) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < lst.size()) {
            double d2 = ((Spectrum)lst.get(n)).getUserYFactor();
            double d3 = ((Spectrum)lst.get(n)).getYRef();
            Coordinate[] coordinateArray = ((Spectrum)lst.get(n)).getXYCoords();
            double d4 = (Coordinate.getMinY(coordinateArray, viewData.getStartingPointIndex(n), viewData.getEndingPointIndex(n)) - d3) * d2 + d3;
            if (d4 < d) {
                d = d4;
            }
            ++n;
        }
        return d;
    }

    public static double getMaxY(Coordinate[] coordinateArray, int n, int n2) {
        double d = -1.7976931348623157E308;
        int n3 = n;
        while (n3 < n2) {
            double d2 = coordinateArray[n3].getYVal();
            if (d2 > d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static double getMaxYUser(Lst<Spectrum> lst, ViewData viewData) {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < lst.size()) {
            double d2 = ((Spectrum)lst.get(n)).getUserYFactor();
            double d3 = ((Spectrum)lst.get(n)).getYRef();
            Coordinate[] coordinateArray = ((Spectrum)lst.get(n)).getXYCoords();
            double d4 = (Coordinate.getMaxY(coordinateArray, viewData.getStartingPointIndex(n), viewData.getEndingPointIndex(n)) - d3) * d2 + d3;
            if (d4 > d) {
                d = d4;
            }
            ++n;
        }
        return d;
    }

    public static double getYValueAt(Coordinate[] coordinateArray, double d) {
        int n = Coordinate.getNearestIndexForX(coordinateArray, d);
        if (n == 0 || n == coordinateArray.length) {
            return Double.NaN;
        }
        double d2 = coordinateArray[n].getXVal();
        double d3 = coordinateArray[n - 1].getXVal();
        double d4 = coordinateArray[n].getYVal();
        double d5 = coordinateArray[n - 1].getYVal();
        if (d2 == d3) {
            return d4;
        }
        return d5 + (d4 - d5) / (d2 - d3) * (d - d3);
    }

    static int intoRange(int n, int n2, int n3) {
        return Math.max(Math.min(n, n3), n2);
    }

    public static int getNearestIndexForX(Coordinate[] coordinateArray, double d) {
        Coordinate coordinate = new Coordinate().set(d, 0.0);
        int n = Arrays.binarySearch(coordinateArray, coordinate, c);
        if (n < 0) {
            n = -1 - n;
        }
        if (n < 0) {
            return 0;
        }
        if (n > coordinateArray.length - 1) {
            return coordinateArray.length - 1;
        }
        return n;
    }

    public static double findXForPeakNearest(Coordinate[] coordinateArray, double d, boolean bl) {
        int n = Coordinate.getNearestIndexForX(coordinateArray, d);
        double d2 = bl ? -1 : 1;
        while (n < coordinateArray.length - 1 && d2 * (coordinateArray[n + 1].yVal - coordinateArray[n].yVal) > 0.0) {
            ++n;
        }
        while (n >= 1 && d2 * (coordinateArray[n - 1].yVal - coordinateArray[n].yVal) > 0.0) {
            --n;
        }
        if (n == 0 || n == coordinateArray.length - 1) {
            return coordinateArray[n].xVal;
        }
        return Coordinate.parabolicInterpolation(coordinateArray, n);
    }

    public static double parabolicInterpolation(Coordinate[] coordinateArray, int n) {
        double d = coordinateArray[n - 1].yVal;
        double d2 = coordinateArray[n].yVal;
        double d3 = coordinateArray[n + 1].yVal;
        double d4 = (d - d3) / 2.0 / (d - 2.0 * d2 + d3);
        return coordinateArray[n].xVal + d4 * (coordinateArray[n + 1].xVal - coordinateArray[n].xVal);
    }

    static boolean getPickedCoordinates(Coordinate[] coordinateArray, Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (coordinate == null) {
            return false;
        }
        double d = coordinate.getXVal();
        coordinate2.setXVal(d);
        coordinate2.setYVal(coordinate.getYVal());
        if (coordinate3 == null) {
            return true;
        }
        int n = Coordinate.getNearestIndexForX(coordinateArray, d);
        coordinate3.setXVal(coordinateArray[n].getXVal());
        coordinate3.setYVal(coordinateArray[n].getYVal());
        return true;
    }

    public static void shiftX(Coordinate[] coordinateArray, double d) {
        int n = coordinateArray.length;
        while (--n >= 0) {
            coordinateArray[n].xVal += d;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static double getNearestXWithYAbove(Coordinate[] var0, double var1_1, double var3_2, boolean var5_3, boolean var6_4) {
        block3: {
            var7_5 = Coordinate.getNearestIndexForX(var0, var1_1);
            var8_6 = var5_3 != false ? -1 : 1;
            if (!var6_4) ** GOTO lbl9
            while (var7_5 < var0.length && var8_6 * (var0[var7_5].yVal - var3_2) < 0.0) {
                ++var7_5;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --var7_5;
lbl9:
                // 2 sources

                ** while (var7_5 >= 0 && var8_6 * (var0[var7_5].yVal - var3_2) < 0.0)
            }
        }
        if (var7_5 == -1 || var7_5 == var0.length) {
            return NaN;
        }
        return Coordinate.findXForPeakNearest(var0, var0[var7_5].getXVal(), var5_3);
    }
}

