#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: uniplate
version: 1.6.12
id: uniplate-1.6.12-D1B9e4S36uhTArFMKIWAf
key: uniplate-1.6.12-D1B9e4S36uhTArFMKIWAf
license: BSD-3-Clause
copyright: Neil Mitchell 2006-2013
maintainer: Neil Mitchell <ndmitchell@gmail.com>
author: Neil Mitchell <ndmitchell@gmail.com>
homepage: http://community.haskell.org/~ndm/uniplate/
synopsis: Help writing simple, concise and fast generic operations.
description:
    Uniplate is library for writing simple and concise generic operations.
    Uniplate has similar goals to the original Scrap Your Boilerplate work,
    but is substantially simpler and faster. The Uniplate manual is available at
    <http://community.haskell.org/~ndm/darcs/uniplate/uniplate.htm>.
    .
    To get started with Uniplate you should import one of the three following
    modules:
    .
    * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
    Most users should start by importing this module.
    .
    * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
    with substantially higher performance (around 5 times), but requires writing
    instance declarations.
    .
    * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
    by Uniplate. Both the above two modules re-export this module.
    .
    In addition, some users may want to make use of the following modules:
    .
    * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
    .
    * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
    .
    * "Data.Generics.Compos" - users transitioning from the Compos library.
    .
    * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
    to avoid getting instance conflicts.
category: Generics
abi: 1aa16a449cbc041660b947de12c631bb
exposed: True
exposed-modules:
    Data.Generics.Biplate Data.Generics.Compos Data.Generics.PlateData
    Data.Generics.PlateDirect Data.Generics.PlateTypeable
    Data.Generics.SYB Data.Generics.Str Data.Generics.Uniplate
    Data.Generics.Uniplate.Data Data.Generics.Uniplate.Data.Instances
    Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
    Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
    Data.Generics.Uniplate.Zipper Data.Generics.UniplateOn
    Data.Generics.UniplateStr Data.Generics.UniplateStrOn
hidden-modules: Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
import-dirs: /usr/lib/ghc-8.6.5/site-local/uniplate-1.6.12
library-dirs: /usr/lib/ghc-8.6.5/site-local/uniplate-1.6.12
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/uniplate-1.6.12
hs-libraries: HSuniplate-1.6.12-D1B9e4S36uhTArFMKIWAf
depends:
    base-4.12.0.0 containers-0.6.0.1
    hashable-1.2.7.0-KHvCgUH7dIl7mI8fl4akIo
    syb-0.7-KRW1LCxdMiCJrmhxCvzo37
    unordered-containers-0.2.10.0-5bnYBnE7Vkj9Kd62fWith8
haddock-interfaces: /usr/share/doc/haskell-uniplate/html/uniplate.haddock
haddock-html: /usr/share/doc/haskell-uniplate/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

