/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ExporterVNA
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean exportVisible;
    private Workspace workspace;
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private boolean exportEdgeWeight = true;
    private boolean exportCoords = true;
    private boolean exportSize = true;
    private boolean exportShortLabel = true;
    private boolean exportColor = true;
    private boolean exportDynamicWeight = true;
    private boolean exportAttributes = true;
    private boolean normalize = false;
    private Writer writer;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minSize;
    private double maxSize;
    private double getLow;
    private double getHigh;
    static final String valueForEmptyAttributes = "\"\"";

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        Progress.start((ProgressTicket)this.progressTicket, (int)(graph.getNodeCount() * 2 + graph.getEdgeCount()));
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            Logger.getLogger(ExporterVNA.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws IOException {
        if (this.normalize) {
            this.calculateMinMaxForNormalization(graph);
        }
        if (this.exportAttributes && this.atLeastOneNonStandartAttribute(graph.getModel())) {
            this.exportNodeData(graph);
        }
        this.exportNodeProperties(graph);
        this.exportEdgeData(graph);
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    private String printParameter(Object val) {
        if (val == null) {
            return valueForEmptyAttributes;
        }
        String res = val.toString().replaceAll("\\r\\n|\\r|\\n", " ").replace('\"', ' ');
        if (res.contains(" ")) {
            return "\"" + res + "\"";
        }
        return res;
    }

    private boolean atLeastOneNonStandartAttribute(GraphModel graphModel) {
        for (Column col : graphModel.getNodeTable()) {
            if (col.isProperty()) continue;
            return true;
        }
        return false;
    }

    private void exportNodeData(Graph graph) throws IOException {
        this.writer.append("*Node data\n");
        this.writer.append("ID");
        for (Column column : graph.getModel().getNodeTable()) {
            if (column.isProperty()) continue;
            this.writer.append(" ").append(column.getTitle().replace(' ', '_'));
        }
        this.writer.append("\n");
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            this.writer.append(this.printParameter(node.getId()));
            for (Column column : node.getAttributeColumns()) {
                if (column.isProperty()) continue;
                Object value = node.getAttribute(column, graph.getView());
                if (value != null) {
                    this.writer.append(" ").append(this.printParameter(value));
                    continue;
                }
                this.writer.append(" ").append(valueForEmptyAttributes);
            }
            this.writer.append("\n");
            Progress.progress((ProgressTicket)this.progressTicket);
            if (!this.cancel) continue;
            nodeIterable.doBreak();
            return;
        }
    }

    private void calculateMinMaxForNormalization(Graph graph) {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.minSize = Double.POSITIVE_INFINITY;
        this.maxSize = Double.NEGATIVE_INFINITY;
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            if (this.cancel) {
                nodeIterable.doBreak();
                break;
            }
            this.minX = Math.min(this.minX, (double)node.x());
            this.maxX = Math.max(this.maxX, (double)node.x());
            this.minY = Math.min(this.minY, (double)node.y());
            this.maxY = Math.max(this.maxY, (double)node.y());
            this.minSize = Math.min(this.minSize, (double)node.r());
            this.maxSize = Math.max(this.maxSize, (double)node.r());
        }
    }

    private void exportNodeProperties(Graph graph) throws IOException {
        this.writer.append("*Node properties\n");
        this.writer.append("ID");
        if (this.exportCoords) {
            this.writer.append(" x y");
        }
        if (this.exportSize) {
            this.writer.append(" size");
        }
        if (this.exportColor) {
            this.writer.append(" color");
        }
        if (this.exportShortLabel) {
            this.writer.append(" shortlabel");
        }
        this.writer.append("\n");
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            Progress.progress((ProgressTicket)this.progressTicket);
            if (this.cancel) {
                nodeIterable.doBreak();
                return;
            }
            this.writer.append(node.getId().toString());
            if (this.exportCoords) {
                if (!this.normalize) {
                    this.writer.append(" ").append(Float.toString(node.x())).append(" ").append(Float.toString(node.y()));
                } else {
                    this.writer.append(" ").append(Double.toString(((double)node.x() - this.minX) / (this.maxX - this.minX))).append(" ").append(Double.toString(((double)node.y() - this.minY) / (this.maxY - this.minY)));
                }
            }
            if (this.exportSize) {
                if (!this.normalize) {
                    this.writer.append(" ").append(Float.toString(node.size()));
                } else {
                    this.writer.append(" ").append(Double.toString(((double)node.size() - this.minSize) / (this.maxSize - this.minSize)));
                }
            }
            if (this.exportColor) {
                this.writer.append(" ").append(Integer.toString((int)(node.r() * 255.0f)));
            }
            if (this.exportShortLabel) {
                if (node.getLabel() != null) {
                    this.writer.append(" ").append(this.printParameter(node.getLabel()));
                } else {
                    this.writer.append(" ").append(this.printParameter(node.getId()));
                }
            }
            this.writer.append("\n");
        }
    }

    void printEdgeData(Edge edge, Node source, Node target, Graph graph) throws IOException {
        this.writer.append(this.printParameter(source.getId()));
        this.writer.append(" ").append(this.printParameter(target.getId()));
        if (this.exportEdgeWeight) {
            Double weight = this.exportDynamicWeight ? Double.valueOf(edge.getWeight(graph.getView())) : Double.valueOf(edge.getWeight());
            this.writer.append(" ").append(weight.toString());
        }
        if (this.exportAttributes) {
            for (Column column : edge.getAttributeColumns()) {
                if (column.isProperty()) continue;
                Object value = edge.getAttribute(column, graph.getView());
                if (value != null) {
                    this.writer.append(" ").append(this.printParameter(value));
                    continue;
                }
                this.writer.append(" \"\"");
            }
        }
        this.writer.append("\n");
    }

    private void exportEdgeData(Graph graph) throws IOException {
        this.writer.append("*Tie data\n");
        this.writer.append("from to");
        if (this.exportEdgeWeight) {
            this.writer.append(" strength");
        }
        if (this.exportAttributes) {
            for (Column col : graph.getModel().getEdgeTable()) {
                if (col.isProperty()) continue;
                this.writer.append(" ").append(this.printParameter(col.getTitle()).replace(' ', '_'));
            }
        }
        this.writer.append("\n");
        EdgeIterable edgeIterable = graph.getEdges();
        for (Edge edge : edgeIterable) {
            this.printEdgeData(edge, edge.getSource(), edge.getTarget(), graph);
            if (!edge.isDirected() && !edge.isSelfLoop()) {
                this.printEdgeData(edge, edge.getTarget(), edge.getSource(), graph);
            }
            Progress.progress((ProgressTicket)this.progressTicket);
            if (!this.cancel) continue;
            edgeIterable.doBreak();
            return;
        }
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean isExportColor() {
        return this.exportColor;
    }

    public void setExportColor(boolean exportColor) {
        this.exportColor = exportColor;
    }

    public boolean isExportCoords() {
        return this.exportCoords;
    }

    public void setExportCoords(boolean exportCoords) {
        this.exportCoords = exportCoords;
    }

    public boolean isExportEdgeWeight() {
        return this.exportEdgeWeight;
    }

    public void setExportEdgeWeight(boolean exportEdgeWeight) {
        this.exportEdgeWeight = exportEdgeWeight;
    }

    public boolean isExportShortLabel() {
        return this.exportShortLabel;
    }

    public void setExportShortLabel(boolean exportShortLabel) {
        this.exportShortLabel = exportShortLabel;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }
}

