define(["idbcore"],function(idb){"use strict";function openLibraryDatabase(dbName){return new Promise(function(resolve,reject){if(dbName in databases)return void resolve(databases[dbName]);var request=indexedDB.open(dbName,libraryDbVersion);request.onerror=reject,request.onblocked=reject,request.onupgradeneeded=function(event){var db=request.result;if(event.oldVersion<1&&db.createObjectStore(dbName),event.oldVersion<3){var objectStore=request.transaction.objectStore(dbName);objectStore.createIndex("Index_ItemType","Item.Type"),objectStore.createIndex("Index_SyncStatus","SyncStatus")}},request.onsuccess=function(event){var db=event.target.result;db.onversionchange=function(){db.close(),delete databases[dbName]},databases[dbName]=db,resolve(db)}})}function getLibraryDb(serverId){return openLibraryDatabase("items_"+serverId)}function getLibarytemTypes(serverId){return getLibraryDb(serverId).then(function(db){return idb.getDistinctndexKeys(db,"Index_ItemType")})}function getLibraryItemsByIds(serverId,ids){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByKeys(db,ids).then(function(items){return items.sort(function(a,b){var indexA=ids.indexOf(a.Id),indexB=ids.indexOf(b.Id);return indexedDB.cmp(indexA,indexB)}),Promise.resolve(items)})})}function getLibraryItemsBySyncStatus(serverId,syncStati){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByIndexKeys(db,"Index_SyncStatus",syncStati)})}function getLibraryItemsByType(serverId,itemTypes){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByIndexKeys(db,"Index_ItemType",itemTypes)})}function getAllLibraryItems(serverId){return getLibraryDb(serverId).then(function(db){return idb.getAllObjects(db)})}function getLibraryItem(serverId,key){return getLibraryDb(serverId).then(function(db){return idb.getObjectByKey(db,key)})}function addLibraryItem(serverId,key,val){return getLibraryDb(serverId).then(function(db){return idb.addObject(db,key,val)})}function updateLibraryItem(serverId,key,val){return getLibraryDb(serverId).then(function(db){return idb.updateObject(db,key,val)})}function deleteLibraryItem(serverId,key){return getLibraryDb(serverId).then(function(db){return idb.deleteObject(db,key)})}function clearLibrary(serverId){return getLibraryDb(serverId).then(function(db){return idb.clearObjects(db)})}var indexedDB=self.indexedDB,libraryDbVersion=3,databases={};return{getLibarytemTypes:getLibarytemTypes,getLibraryItemsByIds:getLibraryItemsByIds,getLibraryItemsBySyncStatus:getLibraryItemsBySyncStatus,getLibraryItemsByType:getLibraryItemsByType,getAllLibraryItems:getAllLibraryItems,getLibraryItem:getLibraryItem,addLibraryItem:addLibraryItem,updateLibraryItem:updateLibraryItem,deleteLibraryItem:deleteLibraryItem,clearLibrary:clearLibrary}});