/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.core.IAnnotationsProvider;

public class AnnotationsProviderManager
extends RegistryReader {
    public static final AnnotationsProviderManager INSTANCE = new AnnotationsProviderManager();
    private List annotationsProviders;

    static {
        INSTANCE.readRegistry();
    }

    public AnnotationsProviderManager() {
        super("org.eclipse.jst.common.annotations.core", "annotationsProvider");
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals("annotationsProvider")) {
            return false;
        }
        this.addAnnotationsProvider(new Descriptor(element));
        return true;
    }

    protected void addAnnotationsProvider(Descriptor descriptor) {
        IAnnotationsProvider provider = descriptor.createInstance();
        if (provider != null) {
            this.getAnnotationsProviders().add(provider);
        }
    }

    public List getAnnotationsProviders() {
        if (this.annotationsProviders == null) {
            this.annotationsProviders = new ArrayList();
        }
        return this.annotationsProviders;
    }

    public static class Descriptor {
        public static final String EXTENSION_PT_PLUGIN = "org.eclipse.jst.common.annotations.core";
        public static final String ANNOTATIONS_PROVIDER = "annotationsProvider";
        public static final String CLASSNAME = "className";
        private final IConfigurationElement configElement;

        public Descriptor(IConfigurationElement aConfigElement) {
            this.configElement = aConfigElement;
        }

        public IAnnotationsProvider createInstance() {
            IAnnotationsProvider instance = null;
            try {
                instance = (IAnnotationsProvider)this.configElement.createExecutableExtension(CLASSNAME);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            return instance;
        }
    }
}

