/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.internal.tmf.ctf.core.Activator;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class CtfIterator
extends CTFTraceReader
implements ITmfContext,
Comparable<CtfIterator> {
    public static final CtfLocation NULL_LOCATION = new CtfLocation(CtfLocation.INVALID_LOCATION);
    private final @NonNull CtfTmfTrace fTrace;
    private CtfLocation fCurLocation;
    private long fCurRank;
    private CtfLocation fPreviousLocation;
    private CtfTmfEvent fPreviousEvent;

    public CtfIterator(CTFTrace ctfTrace, @NonNull CtfTmfTrace ctfTmfTrace) throws CTFException {
        super(ctfTrace);
        this.fTrace = ctfTmfTrace;
        if (this.hasMoreEvents()) {
            this.fCurLocation = new CtfLocation(ctfTmfTrace.getStartTime());
            this.fCurRank = 0L;
        } else {
            this.setUnknownLocation();
        }
    }

    public CtfIterator(CTFTrace ctfTrace, @NonNull CtfTmfTrace ctfTmfTrace, CtfLocationInfo ctfLocationData, long rank) throws CTFException {
        super(ctfTrace);
        this.fTrace = ctfTmfTrace;
        if (this.hasMoreEvents()) {
            this.fCurLocation = new CtfLocation(ctfLocationData);
            if (this.getCurrentEvent().getTimestamp().getValue() != ctfLocationData.getTimestamp()) {
                this.seek(ctfLocationData);
                this.fCurRank = rank;
            }
        } else {
            this.setUnknownLocation();
        }
    }

    public void dispose() {
        this.close();
    }

    private void setUnknownLocation() {
        this.fCurLocation = NULL_LOCATION;
        this.fCurRank = -1L;
    }

    public CtfTmfTrace getCtfTmfTrace() {
        return this.fTrace;
    }

    public synchronized CtfTmfEvent getCurrentEvent() {
        CTFStreamInputReader top = (CTFStreamInputReader)super.getPrio().peek();
        if (top != null) {
            if (!this.fCurLocation.equals((Object)this.fPreviousLocation)) {
                this.fPreviousLocation = this.fCurLocation;
                this.fPreviousEvent = this.fTrace.getEventFactory().createEvent(this.fTrace, (IEventDefinition)NonNullUtils.checkNotNull((Object)top.getCurrentEvent()), top.getFilename());
            }
            return this.fPreviousEvent;
        }
        return null;
    }

    public synchronized long getCurrentTimestamp() {
        IEventDefinition currentEvent;
        CTFStreamInputReader top = (CTFStreamInputReader)super.getPrio().peek();
        if (top != null && (currentEvent = top.getCurrentEvent()) != null) {
            long ts = currentEvent.getTimestamp();
            return this.fTrace.timestampCyclesToNanos(ts);
        }
        return 0L;
    }

    public synchronized boolean seek(CtfLocationInfo ctfLocationData) {
        boolean ret = false;
        if (ctfLocationData.equals(CtfLocation.INVALID_LOCATION)) {
            this.fCurLocation = NULL_LOCATION;
            return false;
        }
        if (this.fCurLocation.getLocationInfo().equals(ctfLocationData)) {
            return super.hasMoreEvents();
        }
        this.fCurLocation = new CtfLocation(ctfLocationData);
        long currTimestamp = ctfLocationData.getTimestamp();
        long offsetTimestamp = this.getCtfTmfTrace().timestampNanoToCycles(currTimestamp);
        try {
            ret = offsetTimestamp < 0L ? super.seek(0L) : super.seek(offsetTimestamp);
        }
        catch (CTFException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
        long index = 0L;
        CtfTmfEvent currentEvent = this.getCurrentEvent();
        if (currentEvent != null) {
            currTimestamp = currentEvent.getTimestamp().getValue();
            long i = 0L;
            while (i < ctfLocationData.getIndex()) {
                index = currTimestamp == currentEvent.getTimestamp().getValue() ? ++index : 0L;
                this.advance();
                ++i;
            }
        } else {
            ret = false;
        }
        this.fCurLocation = ret ? new CtfLocation(new CtfLocationInfo(this.getCurrentEvent().getTimestamp().getValue(), index)) : NULL_LOCATION;
        return ret;
    }

    public boolean seek(long timestamp) {
        return this.seek(new CtfLocationInfo(timestamp, 0L));
    }

    public synchronized boolean advance() {
        boolean ret = false;
        try {
            ret = super.advance();
        }
        catch (CTFException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        if (ret) {
            long timestampValue;
            long timestamp = this.fCurLocation.getLocationInfo().getTimestamp();
            if (timestamp == (timestampValue = this.getCurrentTimestamp())) {
                long index = this.fCurLocation.getLocationInfo().getIndex();
                this.fCurLocation = new CtfLocation(timestampValue, index + 1L);
            } else {
                this.fCurLocation = new CtfLocation(timestampValue, 0L);
            }
        } else {
            this.fCurLocation = NULL_LOCATION;
        }
        return ret;
    }

    public long getRank() {
        return this.fCurRank;
    }

    public void setRank(long rank) {
        this.fCurRank = rank;
    }

    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fCurRank;
        }
    }

    public boolean hasValidRank() {
        return this.getRank() >= 0L;
    }

    public void setLocation(ITmfLocation location) {
        this.fCurLocation = (CtfLocation)location;
        this.seek(((CtfLocation)location).getLocationInfo());
    }

    public CtfLocation getLocation() {
        return this.fCurLocation;
    }

    @Override
    public int compareTo(CtfIterator o) {
        if (this.getRank() < o.getRank()) {
            return -1;
        }
        if (this.getRank() > o.getRank()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + ((Object)((Object)this.fTrace)).hashCode();
        result = 31 * result + (this.fCurLocation == null ? 0 : this.fCurLocation.hashCode());
        result = 31 * result + (int)(this.fCurRank ^ this.fCurRank >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CtfIterator)) {
            return false;
        }
        CtfIterator other = (CtfIterator)obj;
        if (!Objects.equals((Object)this.fTrace, (Object)other.fTrace)) {
            return false;
        }
        if (!Objects.equals((Object)this.fCurLocation, (Object)other.fCurLocation)) {
            return false;
        }
        return this.fCurRank == other.fCurRank;
    }
}

