/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.tools.maintenance;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.ui.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class SQLServerToolTriggerToggle
implements IExternalTool {
    private boolean isEnable;

    protected SQLServerToolTriggerToggle(boolean enable) {
        this.isEnable = enable;
    }

    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        SQLDialog dialog;
        List triggeList = CommonUtils.filterCollection(objects, SQLServerTableTrigger.class);
        if (!triggeList.isEmpty() && (dialog = new SQLDialog(activePart.getSite(), triggeList)).open() == 0) {
            this.refreshObjectsState(triggeList);
        }
    }

    private void refreshObjectsState(List<SQLServerTableTrigger> triggeList) {
        try {
            UIUtils.runInProgressDialog(monitor -> {
                for (SQLServerTableTrigger trigger : triggeList) {
                    try {
                        DBNDatabaseNode triggerNode = NavigatorUtils.getNodeByObject((DBSObject)trigger);
                        if (triggerNode != null) {
                            triggerNode.refreshNode(monitor, (Object)this);
                            continue;
                        }
                        trigger.refreshObjectState(monitor);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Refresh triggers state", "Error refreshign trigger state", e.getTargetException());
        }
    }

    class SQLDialog
    extends TableToolDialog {
        public SQLDialog(IWorkbenchPartSite partSite, List<SQLServerTableTrigger> selectedTrigger) {
            super(partSite, String.valueOf(SQLServerToolTriggerToggle.this.isEnable ? "Enable" : "Disable") + " trigger", selectedTrigger);
        }

        protected void generateObjectCommand(List<String> lines, SQLServerObject object) {
            lines.add("ALTER TABLE " + ((SQLServerTableTrigger)object).getTable() + " " + (SQLServerToolTriggerToggle.this.isEnable ? "ENABLE" : "DISABLE") + " TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)object) + " ");
        }

        protected void createControls(Composite parent) {
            this.createObjectsSelector(parent);
        }
    }
}

