/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;

public class GeometryDataUtils {
    private static final Log log = Log.getLog(GeometryDataUtils.class);

    public static List<GeomAttrs> extractGeometryAttributes(IResultSetController controller) {
        ArrayList<GeomAttrs> result = new ArrayList<GeomAttrs>();
        ResultSetModel model = controller.getModel();
        List attributes = model.getVisibleAttributes();
        ArrayList<Object> descAttrs = new ArrayList<DBDAttributeBinding>();
        for (DBDAttributeBinding attr : attributes) {
            if (attr.getValueHandler().getValueObjectType((DBSTypedObject)attr.getAttribute()) == DBGeometry.class) {
                GeomAttrs geomAttrs = new GeomAttrs(attr, descAttrs);
                result.add(geomAttrs);
                descAttrs = new ArrayList();
                continue;
            }
            descAttrs.add(attr);
        }
        if (result.size() == 1) {
            ((GeomAttrs)result.get((int)0)).descAttrs.addAll(descAttrs);
        }
        return result;
    }

    public static void setGeometryProperties(IResultSetController controller, GeomAttrs geomAttrs, DBGeometry geometry, ResultSetRow row) {
        ResultSetModel model = controller.getModel();
        if (row != null && !geomAttrs.descAttrs.isEmpty()) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            for (DBDAttributeBinding da : geomAttrs.descAttrs) {
                Object descValue = model.getCellValue(da, row);
                properties.put(da.getName(), descValue);
            }
            geometry.setProperties(properties);
        }
    }

    public static class GeomAttrs {
        public final DBDAttributeBinding geomAttr;
        public final List<DBDAttributeBinding> descAttrs;

        public GeomAttrs(DBDAttributeBinding geomAttr, List<DBDAttributeBinding> descAttrs) {
            this.geomAttr = geomAttr;
            this.descAttrs = descAttrs;
        }

        public DBDAttributeBinding getGeomAttr() {
            return this.geomAttr;
        }

        public List<DBDAttributeBinding> getDescAttrs() {
            return this.descAttrs;
        }
    }
}

