/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.NodeEditorInput;

public class NodeEditorInputFactory
implements IElementFactory {
    private static final Log log = Log.getLog(NodeEditorInputFactory.class);
    public static final String ID_FACTORY = NodeEditorInputFactory.class.getName();
    private static final String TAG_NODE = "node";

    public IAdaptable createElement(IMemento memento) {
        String nodePath = memento.getString(TAG_NODE);
        if (nodePath == null) {
            return null;
        }
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        try {
            DBNNode node = navigatorModel.getNodeByPath((DBRProgressMonitor)new VoidProgressMonitor(), nodePath);
            if (node != null) {
                return new NodeEditorInput(node);
            }
        }
        catch (DBException e) {
            log.error((Object)("Error opening node '" + nodePath + "'"), (Throwable)e);
            return null;
        }
        return null;
    }

    public static void saveState(IMemento memento, NodeEditorInput input) {
        DBNNode node = input.getNavigatorNode();
        memento.putString(TAG_NODE, node.getNodeItemPath());
    }
}

