/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class MySQLToolRepair
implements IExternalTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, MySQLTable.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        private Button quickCheck;
        private Button extendedCheck;
        private Button frmCheck;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<MySQLTable> selectedTables) {
            super(partSite, "Repair table(s)", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, MySQLTable object) {
            String sql = "REPAIR TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
            if (this.quickCheck.getSelection()) {
                sql = String.valueOf(sql) + " QUICK";
            }
            if (this.extendedCheck.getSelection()) {
                sql = String.valueOf(sql) + " EXTENDED";
            }
            if (this.frmCheck.getSelection()) {
                sql = String.valueOf(sql) + " USE_FRM";
            }
            lines.add(sql);
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Options", (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.quickCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Quick", (boolean)false);
            this.quickCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.extendedCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Extended", (boolean)false);
            this.extendedCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.frmCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Use FRM", (boolean)false);
            this.frmCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }
    }
}

