/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ProgressStreamReader;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.DatabaseWizardPageLog;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public abstract class AbstractToolWizard<BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends Wizard
implements DBRRunnableWithProgress {
    private static final Log log = Log.getLog(AbstractToolWizard.class);
    private final String PROP_NAME_EXTRA_ARGS = "tools.wizard." + ((Object)((Object)this)).getClass().getSimpleName() + ".extraArgs";
    private final List<BASE_OBJECT> databaseObjects;
    private DBPNativeClientLocation clientHome;
    private DBPDataSourceContainer dataSourceContainer;
    private DBPConnectionConfiguration connectionInfo;
    private String toolUserName;
    private String toolUserPassword;
    private String extraCommandArgs;
    protected String task;
    protected final DatabaseWizardPageLog logPage;
    private boolean finished;
    protected boolean transferFinished;
    private boolean refreshObjects;

    protected AbstractToolWizard(Collection<BASE_OBJECT> databaseObjects, String task) {
        this.databaseObjects = new ArrayList<BASE_OBJECT>(databaseObjects);
        this.task = task;
        this.logPage = new DatabaseWizardPageLog(task);
        if (databaseObjects.isEmpty()) {
            throw new IllegalArgumentException("Empty object list");
        }
        for (DBSObject object : databaseObjects) {
            if (this.dataSourceContainer != null && this.dataSourceContainer != object.getDataSource().getContainer()) {
                throw new IllegalArgumentException("Objects from different data sources");
            }
            this.dataSourceContainer = object.getDataSource().getContainer();
            this.connectionInfo = this.dataSourceContainer.getActualConnectionConfiguration();
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.extraCommandArgs = store.getString(this.PROP_NAME_EXTRA_ARGS);
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.isSingleTimeWizard()) {
            return !this.finished;
        }
        return true;
    }

    protected boolean isSingleTimeWizard() {
        return false;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    public List<BASE_OBJECT> getDatabaseObjects() {
        return this.databaseObjects;
    }

    public DBPConnectionConfiguration getConnectionInfo() {
        return this.connectionInfo;
    }

    public DBPNativeClientLocation getClientHome() {
        return this.clientHome;
    }

    public String getToolUserName() {
        return this.toolUserName;
    }

    public void setToolUserName(String toolUserName) {
        this.toolUserName = toolUserName;
    }

    public String getToolUserPassword() {
        return this.toolUserPassword;
    }

    public void setToolUserPassword(String toolUserPassword) {
        this.toolUserPassword = toolUserPassword;
    }

    public String getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public void setExtraCommandArgs(String extraCommandArgs) {
        this.extraCommandArgs = extraCommandArgs;
    }

    protected void addExtraCommandArgs(List<String> cmd) {
        if (!CommonUtils.isEmptyTrimmed((String)this.extraCommandArgs)) {
            Collections.addAll(cmd, this.extraCommandArgs.split(" "));
        }
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public DBPNativeClientLocation findNativeClientHome(String clientHomeId) {
        return null;
    }

    public abstract Collection<PROCESS_ARG> getRunInfo();

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.updateErrorMessage();
    }

    public void updateErrorMessage() {
        WizardPage currentPage = (WizardPage)this.getStartingPage();
        if (this.isNativeClientHomeRequired()) {
            String clientHomeId = this.dataSourceContainer.getConnectionConfiguration().getClientHomeId();
            if (clientHomeId == null) {
                this.clientHome = null;
                currentPage.setErrorMessage(CoreMessages.tools_wizard_message_no_client_home);
                this.getContainer().updateMessage();
                return;
            }
            this.clientHome = (DBPNativeClientLocation)DBUtils.findObject((List)this.dataSourceContainer.getDriver().getNativeClientLocations(), (String)clientHomeId);
            if (this.clientHome == null) {
                this.clientHome = this.findNativeClientHome(clientHomeId);
            }
            if (this.clientHome == null) {
                currentPage.setErrorMessage(NLS.bind((String)CoreMessages.tools_wizard_message_client_home_not_found, (Object)clientHomeId));
            } else {
                currentPage.setErrorMessage(null);
            }
            this.getContainer().updateMessage();
        }
    }

    private boolean validateClientFiles() {
        if (!this.isNativeClientHomeRequired() || this.clientHome == null) {
            return true;
        }
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                try {
                    this.clientHome.validateFilesPresence(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Download native client file(s)", "Error downloading client file(s)", e.getTargetException());
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("Error downloading native client file(s)");
            this.getContainer().updateMessage();
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue(this.PROP_NAME_EXTRA_ARGS, this.extraCommandArgs);
        if (this.getContainer().getCurrentPage() != this.logPage) {
            this.getContainer().showPage((IWizardPage)this.logPage);
        }
        if (!this.validateClientFiles()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            try {
                UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)this);
            }
            catch (InterruptedException interruptedException) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)this.task, (String)NLS.bind((String)CoreMessages.tools_wizard_error_task_canceled, (Object)this.task, (Object)this.getObjectsName()), (int)1);
                this.getContainer().updateButtons();
                return false;
            }
            catch (InvocationTargetException ex) {
                DBWorkbench.getPlatformUI().showError(NLS.bind((String)CoreMessages.tools_wizard_error_task_error_title, (Object)this.task), String.valueOf(CoreMessages.tools_wizard_error_task_error_message) + this.task, ex.getTargetException());
                this.getContainer().updateButtons();
                return false;
            }
        }
        finally {
            this.getContainer().updateButtons();
        }
        long workTime = System.currentTimeMillis() - startTime;
        this.notifyToolFinish(String.valueOf(this.task) + " finished", workTime);
        this.onSuccess(workTime);
        return false;
    }

    protected void notifyToolFinish(String toolName, long workTime) {
        Display.getCurrent().beep();
        if (workTime > DBWorkbench.getPlatformUI().getLongOperationTimeout() * 1000L) {
            DBWorkbench.getPlatformUI().notifyAgent(toolName, 1);
        }
    }

    public String getObjectsName() {
        StringBuilder str = new StringBuilder();
        for (DBSObject object : this.databaseObjects) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(object.getName());
        }
        return str.toString();
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                boolean isSuccess = true;
                for (PROCESS_ARG arg : this.getRunInfo()) {
                    if (monitor.isCanceled()) break;
                    if (this.executeProcess(monitor, arg)) continue;
                    isSuccess = false;
                }
                boolean bl = this.refreshObjects = isSuccess && !monitor.isCanceled();
                if (this.refreshObjects && this.needsModelRefresh()) {
                    for (DBSObject object : this.databaseObjects) {
                        DBNDatabaseNode node = this.dataSourceContainer.getPlatform().getNavigatorModel().findNode(object);
                        if (node == null) continue;
                        node.refreshNode(monitor, (Object)this);
                    }
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.finished = true;
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    public boolean executeProcess(DBRProgressMonitor monitor, PROCESS_ARG arg) throws IOException, CoreException, InterruptedException {
        monitor.beginTask(this.getWindowTitle(), 1);
        List<String> commandLine = this.getCommandLine(arg);
        File execPath = new File(commandLine.get(0));
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.directory(execPath.getParentFile());
        if (this.isMergeProcessStreams()) {
            processBuilder.redirectErrorStream(true);
        }
        this.setupProcessParameters(processBuilder);
        Process process = processBuilder.start();
        this.startProcessHandler(monitor, arg, processBuilder, process);
        Thread.sleep(100L);
        while (true) {
            Thread.sleep(100L);
            if (monitor.isCanceled()) {
                process.destroy();
            }
            try {
                int exitCode = process.exitValue();
                if (exitCode != 0) {
                    this.logPage.appendLog(String.valueOf(NLS.bind((String)CoreMessages.tools_wizard_log_process_exit_code, (Object)exitCode)) + "\n", true);
                    return false;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    continue;
                }
                catch (IOException e) {
                    monitor.done();
                    log.error((Object)e);
                    this.logPage.appendLog(String.valueOf(NLS.bind((String)CoreMessages.tools_wizard_log_io_error, (Object)e.getMessage())) + "\n", true);
                    return false;
                }
            }
            break;
        }
        return true;
    }

    protected boolean isNativeClientHomeRequired() {
        return true;
    }

    protected boolean isMergeProcessStreams() {
        return false;
    }

    public boolean isVerbose() {
        return false;
    }

    protected void onSuccess(long workTime) {
    }

    protected abstract List<String> getCommandLine(PROCESS_ARG var1) throws IOException;

    public abstract void fillProcessParameters(List<String> var1, PROCESS_ARG var2) throws IOException;

    protected void setupProcessParameters(ProcessBuilder process) {
    }

    protected abstract void startProcessHandler(DBRProgressMonitor var1, PROCESS_ARG var2, ProcessBuilder var3, Process var4);

    public boolean isSecureString(String string) {
        String password = this.getToolUserPassword();
        return !CommonUtils.isEmpty((String)password) && string.contains(password);
    }

    public class BinaryFileTransformerJob
    extends Thread {
        private DBRProgressMonitor monitor;
        private OutputStream output;
        private File inputFile;

        public BinaryFileTransformerJob(DBRProgressMonitor monitor, File inputFile, OutputStream stream) {
            super(AbstractToolWizard.this.task);
            this.monitor = monitor;
            this.output = stream;
            this.inputFile = inputFile;
        }

        @Override
        public void run() {
            try {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, AbstractToolWizard.this.task, (InputStream)new FileInputStream(this.inputFile), this.inputFile.length());){
                        byte[] buffer = new byte[100000];
                        while (!this.monitor.isCanceled()) {
                            int readSize = scriptStream.read(buffer);
                            if (readSize < 0) break;
                            this.output.write(buffer, 0, readSize);
                            this.output.flush();
                        }
                        this.output.flush();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.debug((Object)e);
                    AbstractToolWizard.this.logPage.appendLog(String.valueOf(e.getMessage()) + "\n");
                    try {
                        this.output.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)e2);
                    }
                    this.monitor.done();
                    AbstractToolWizard.this.transferFinished = true;
                }
            }
            finally {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
                this.monitor.done();
                AbstractToolWizard.this.transferFinished = true;
            }
        }
    }

    public class DumpCopierJob
    extends DumpJob {
        public DumpCopierJob(DBRProgressMonitor monitor, String name, InputStream stream, File outFile) {
            super(name, monitor, stream, outFile);
        }

        @Override
        public void runDump() throws IOException {
            this.monitor.beginTask(this.getName(), 100);
            long totalBytesDumped = 0L;
            long prevStatusUpdateTime = 0L;
            byte[] buffer = new byte[10000];
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Throwable throwable = null;
                Object var8_7 = null;
                try (FileOutputStream output = new FileOutputStream(this.outFile);){
                    int count;
                    while ((count = this.input.read(buffer)) > 0) {
                        totalBytesDumped += (long)count;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - prevStatusUpdateTime > 300L) {
                            this.monitor.subTask(String.valueOf(numberFormat.format(totalBytesDumped)) + " bytes");
                            prevStatusUpdateTime = currentTime;
                        }
                        ((OutputStream)output).write(buffer, 0, count);
                    }
                    output.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    public abstract class DumpJob
    extends Thread {
        protected DBRProgressMonitor monitor;
        protected InputStream input;
        protected File outFile;

        protected DumpJob(String name, DBRProgressMonitor monitor, InputStream stream, File outFile) {
            super(name);
            this.monitor = monitor;
            this.input = stream;
            this.outFile = outFile;
        }

        @Override
        public final void run() {
            try {
                this.runDump();
            }
            catch (IOException e) {
                AbstractToolWizard.this.logPage.appendLog(e.getMessage());
            }
        }

        protected abstract void runDump() throws IOException;
    }

    public class TextFileTransformerJob
    extends Thread {
        private DBRProgressMonitor monitor;
        private OutputStream output;
        private File inputFile;
        private String inputCharset;
        private String outputCharset;

        public TextFileTransformerJob(DBRProgressMonitor monitor, File inputFile, OutputStream stream, String inputCharset, String outputCharset) {
            super(AbstractToolWizard.this.task);
            this.monitor = monitor;
            this.output = stream;
            this.inputFile = inputFile;
            this.inputCharset = inputCharset;
            this.outputCharset = outputCharset;
        }

        @Override
        public void run() {
            try {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, AbstractToolWizard.this.task, (InputStream)new FileInputStream(this.inputFile), this.inputFile.length());){
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptStream, this.inputCharset));
                            PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.output, this.outputCharset));
                            while (!this.monitor.isCanceled()) {
                                String line = reader.readLine();
                                if (line == null) break;
                                writer.println(line);
                                writer.flush();
                            }
                            this.output.flush();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        IOUtils.close((Closeable)this.output);
                    }
                }
                catch (IOException e) {
                    log.debug((Object)e);
                    AbstractToolWizard.this.logPage.appendLog(e.getMessage());
                    this.monitor.done();
                    AbstractToolWizard.this.transferFinished = true;
                }
            }
            finally {
                this.monitor.done();
                AbstractToolWizard.this.transferFinished = true;
            }
        }
    }
}

