/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */
'use strict';

var _require = require("relay-runtime"),
    RelayProfiler = _require.RelayProfiler;

function profileContainer(Container, containerName) {
  RelayProfiler.instrumentMethods(Container.prototype, {
    constructor: "".concat(containerName, ".prototype.constructor"),
    UNSAFE_componentWillReceiveProps: "".concat(containerName, ".prototype.UNSAFE_componentWillReceiveProps"),
    componentWillUnmount: "".concat(containerName, ".prototype.componentWillUnmount"),
    shouldComponentUpdate: "".concat(containerName, ".prototype.shouldComponentUpdate")
  }); // Copy static getDerivedStateFromProps() to the instrumented constructor.
  // This is necessary to support the react-lifecycle-compat poyfill.
  // This can be removed once react-relay requires React 16.3+.

  if (Container.prototype !== null && typeof Container.prototype === 'object' && typeof Container.getDerivedStateFromProps === 'function') {
    Container.prototype.constructor.getDerivedStateFromProps = Container.getDerivedStateFromProps;
  }
}

module.exports = {
  profileContainer: profileContainer
};