"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.watchWorkspaceItem = watchWorkspaceItem;

var _atom = require("atom");

var _uriPattern = _interopRequireDefault(require("./atom/uri-pattern"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ItemWatcher {
  constructor(workspace, pattern, component, stateKey) {
    _defineProperty(this, "updateActiveState", () => {
      const wasActive = this.activeItem;
      this.activeItem = this.isActiveItem(); // Update the component's state if it's changed as a result

      if (wasActive && !this.activeItem) {
        return new Promise(resolve => this.component.setState({
          [this.stateKey]: false
        }, resolve));
      } else if (!wasActive && this.activeItem) {
        return new Promise(resolve => this.component.setState({
          [this.stateKey]: true
        }, resolve));
      } else {
        return Promise.resolve();
      }
    });

    _defineProperty(this, "itemMatches", item => item && item.getURI && this.pattern.matches(item.getURI()).ok());

    this.workspace = workspace;
    this.pattern = pattern instanceof _uriPattern.default ? pattern : new _uriPattern.default(pattern);
    this.component = component;
    this.stateKey = stateKey;
    this.activeItem = this.isActiveItem();
    this.subs = new _atom.CompositeDisposable();
  }

  isActiveItem() {
    for (const pane of this.workspace.getPanes()) {
      if (this.itemMatches(pane.getActiveItem())) {
        return true;
      }
    }

    return false;
  }

  setInitialState() {
    if (!this.component.state) {
      this.component.state = {};
    }

    this.component.state[this.stateKey] = this.activeItem;
    return this;
  }

  subscribeToWorkspace() {
    this.subs.dispose();
    this.subs = new _atom.CompositeDisposable(this.workspace.getCenter().onDidChangeActivePaneItem(this.updateActiveState));
    return this;
  }

  setPattern(pattern) {
    this.pattern = pattern instanceof _uriPattern.default ? pattern : new _uriPattern.default(pattern);
    return this.updateActiveState();
  }

  dispose() {
    this.subs.dispose();
  }

}

function watchWorkspaceItem(workspace, pattern, component, stateKey) {
  return new ItemWatcher(workspace, pattern, component, stateKey).setInitialState().subscribeToWorkspace();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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