"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PrCommitsView = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _prCommitView = _interopRequireDefault(require("./pr-commit-view"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PrCommitsView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(_helpers.PAGE_SIZE, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("div", {
      className: "github-PrCommitsView-commitWrapper"
    }, this.renderCommits()), this.renderLoadMore());
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react.default.createElement("button", {
      className: "github-PrCommitsView-load-more-button btn",
      onClick: this.loadMore
    }, "Load more");
  }

  renderCommits() {
    return this.props.pullRequest.commits.edges.map(edge => {
      const commit = edge.node.commit;
      return _react.default.createElement(_prCommitView.default, {
        key: commit.id,
        item: commit,
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      });
    });
  }

}

exports.PrCommitsView = PrCommitsView;

_defineProperty(PrCommitsView, "propTypes", {
  relay: _propTypes.default.shape({
    hasMore: _propTypes.default.func.isRequired,
    loadMore: _propTypes.default.func.isRequired,
    isLoading: _propTypes.default.func.isRequired
  }).isRequired,
  pullRequest: _propTypes.default.shape({
    commits: (0, _propTypes2.RelayConnectionPropType)(_propTypes.default.shape({
      commit: _propTypes.default.shape({
        id: _propTypes.default.string.isRequired
      })
    }))
  }),
  onBranch: _propTypes.default.bool.isRequired,
  openCommit: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createPaginationContainer)(PrCommitsView, {
  pullRequest: function () {
    const node = require("./__generated__/prCommitsView_pullRequest.graphql");

    if (node.hash && node.hash !== "4945c525c20aac5e24befbe8b217c2c9") {
      console.error("The definition of 'prCommitsView_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prCommitsView_pullRequest.graphql");
  }
}, {
  direction: 'forward',

  getConnectionFromProps(props) {
    return props.pullRequest.commits;
  },

  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread({}, prevVars, {
      commitCount: totalCount
    });
  },

  getVariables(props, {
    count,
    cursor
  }, fragmentVariables) {
    return {
      commitCount: count,
      commitCursor: cursor,
      url: props.pullRequest.url
    };
  },

  query: function () {
    const node = require("./__generated__/prCommitsViewQuery.graphql");

    if (node.hash && node.hash !== "5fae6bf54831a4d4a70eda4117e56b7f") {
      console.error("The definition of 'prCommitsViewQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prCommitsViewQuery.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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