"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _modelObserver = _interopRequireDefault(require("../models/model-observer"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObserveModel extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'fetchData', 'didUpdate');
    this.state = {
      data: null
    };
    this.modelObserver = new _modelObserver.default({
      fetchData: this.fetchData,
      didUpdate: this.didUpdate
    });
  }

  componentWillMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentWillReceiveProps(nextProps) {
    this.modelObserver.setActiveModel(nextProps.model);
  }

  fetchData(model) {
    return this.props.fetchData(model);
  }

  didUpdate(model) {
    if (this.mounted) {
      const data = this.modelObserver.getActiveModelData();
      this.setState({
        data
      });
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }

}

exports.default = ObserveModel;

_defineProperty(ObserveModel, "propTypes", {
  model: _propTypes.default.shape({
    onDidUpdate: _propTypes.default.func.isRequired
  }),
  fetchData: _propTypes.default.func.isRequired,
  children: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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