"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectionRenderer = collectionRenderer;
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _commitsView = _interopRequireDefault(require("./timeline-items/commits-view.js"));

var _issueCommentView = _interopRequireDefault(require("./timeline-items/issue-comment-view.js"));

var _mergedEventView = _interopRequireDefault(require("./timeline-items/merged-event-view.js"));

var _headRefForcePushedEventView = _interopRequireDefault(require("./timeline-items/head-ref-force-pushed-event-view.js"));

var _crossReferencedEventsView = _interopRequireDefault(require("./timeline-items/cross-referenced-events-view.js"));

var _commitCommentThreadView = _interopRequireDefault(require("./timeline-items/commit-comment-thread-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function collectionRenderer(Component, styleAsTimelineItem = true) {
  var _class, _temp;

  return _temp = _class = class GroupedComponent extends _react.default.Component {
    static getFragment(fragName, ...args) {
      const frag = fragName === 'nodes' ? 'item' : fragName;
      return Component.getFragment(frag, ...args);
    }

    constructor(props) {
      super(props);
      (0, _helpers.autobind)(this, 'renderNode');
    }

    render() {
      return _react.default.createElement("div", {
        className: styleAsTimelineItem ? 'timeline-item' : ''
      }, this.props.nodes.map(this.renderNode));
    }

    renderNode(node, i) {
      return _react.default.createElement(Component, {
        key: i,
        item: node,
        issueish: this.props.issueish,
        switchToIssueish: this.props.switchToIssueish
      });
    }

  }, _defineProperty(_class, "displayName", `Grouped(${Component.render ? Component.render.displayName : Component.displayName})`), _defineProperty(_class, "propTypes", {
    nodes: _propTypes.default.array.isRequired,
    issueish: _propTypes.default.object.isRequired,
    switchToIssueish: _propTypes.default.func.isRequired
  }), _temp;
}

const timelineItems = {
  Commit: _commitsView.default,
  CommitCommentThread: collectionRenderer(_commitCommentThreadView.default, false),
  IssueComment: collectionRenderer(_issueCommentView.default, false),
  MergedEvent: collectionRenderer(_mergedEventView.default),
  HeadRefForcePushedEvent: collectionRenderer(_headRefForcePushedEventView.default),
  CrossReferencedEvent: _crossReferencedEventsView.default
};
const TimelineConnectionPropType = (0, _propTypes2.RelayConnectionPropType)(_propTypes.default.shape({
  __typename: _propTypes.default.string.isRequired
})).isRequired;

class IssueishTimelineView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(10, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timeline.edges);
    return _react.default.createElement("div", {
      className: "github-PrTimeline"
    }, groupedEdges.map(({
      type,
      edges
    }) => {
      const Component = timelineItems[type];
      const propsForCommits = {
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      };

      if (Component) {
        return _react.default.createElement(Component, _extends({
          key: `${type}-${edges[0].cursor}`,
          nodes: edges.map(e => e.node),
          issueish: issueish,
          switchToIssueish: this.props.switchToIssueish
        }, Component === _commitsView.default && propsForCommits));
      } else {
        // eslint-disable-next-line no-console
        console.warn(`unrecognized timeline event type: ${type}`);
        return null;
      }
    }), this.renderLoadMore());
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react.default.createElement("div", {
      className: "github-PrTimeline-loadMore"
    }, _react.default.createElement("button", {
      className: "github-PrTimeline-loadMoreButton btn",
      onClick: this.loadMore
    }, this.props.relay.isLoading() ? _react.default.createElement(_octicon.default, {
      icon: "ellipsis"
    }) : 'Load More'));
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach(({
      node,
      cursor
    }) => {
      const currentEdgeType = node.__typename;

      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({
          node,
          cursor
        });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{
            node,
            cursor
          }]
        };
        groupedEdges.push(currentGroup);
      }

      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }

}

exports.default = IssueishTimelineView;

_defineProperty(IssueishTimelineView, "propTypes", {
  switchToIssueish: _propTypes.default.func.isRequired,
  relay: _propTypes.default.shape({
    hasMore: _propTypes.default.func.isRequired,
    loadMore: _propTypes.default.func.isRequired,
    isLoading: _propTypes.default.func.isRequired
  }).isRequired,
  issue: _propTypes.default.shape({
    timeline: TimelineConnectionPropType
  }),
  pullRequest: _propTypes.default.shape({
    timeline: TimelineConnectionPropType
  }),
  onBranch: _propTypes.default.bool,
  openCommit: _propTypes.default.func
});

_defineProperty(IssueishTimelineView, "defaultProps", {
  onBranch: false,
  openCommit: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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