"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InitDialog extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'init', 'cancel', 'editorRef', 'setInitEnablement');
    this.state = {
      initDisabled: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.initPath || this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.projectPathElement) {
      setTimeout(() => this.projectPathElement.focus());
    }
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-Dialog github-Init modal"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-Init"
    }, _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.init
    })), _react.default.createElement("main", {
      className: "github-DialogInputs"
    }, _react.default.createElement("label", {
      className: "github-DialogLabel github-ProjectPath"
    }, "Initialize git repository in directory", _react.default.createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRef(),
      tabIndex: "2"
    }))), _react.default.createElement("div", {
      className: "github-DialogButtons"
    }, _react.default.createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react.default.createElement("button", {
      className: "btn btn-primary icon icon-repo-create",
      onClick: this.init,
      disabled: this.state.initDisabled,
      tabIndex: "4"
    }, "Init")));
  }

  init() {
    if (this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  editorRef() {
    return element => {
      if (!element) {
        return;
      }

      this.projectPathElement = element;
      const editor = element.getModel();

      if (this.projectPathEditor !== editor) {
        this.projectPathEditor = editor;

        if (this.projectPathSubs) {
          this.projectPathSubs.dispose();
          this.subs.remove(this.projectPathSubs);
        }

        this.projectPathSubs = editor.onDidChange(this.setInitEnablement);
        this.subs.add(this.projectPathSubs);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setInitEnablement() {
    this.setState({
      initDisabled: this.getProjectPath().length === 0
    });
  }

}

exports.default = InitDialog;

_defineProperty(InitDialog, "propTypes", {
  config: _propTypes.default.object.isRequired,
  commandRegistry: _propTypes.default.object.isRequired,
  didAccept: _propTypes.default.func,
  didCancel: _propTypes.default.func,
  initPath: _propTypes.default.string
});

_defineProperty(InitDialog, "defaultProps", {
  didAccept: () => {},
  didCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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