"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _keystroke = _interopRequireDefault(require("../atom/keystroke"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function theBuckStopsHere(event) {
  event.stopPropagation();
}

class HunkHeaderView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'didMouseDown', 'renderButtons');
    this.refDiscardButton = new _refHolder.default();
  }

  render() {
    const conditional = {
      'github-HunkHeaderView--isSelected': this.props.isSelected,
      'github-HunkHeaderView--isHunkMode': this.props.selectionMode === 'hunk'
    };
    return _react.default.createElement("div", {
      className: (0, _classnames.default)('github-HunkHeaderView', conditional),
      onMouseDown: this.didMouseDown
    }, _react.default.createElement("span", {
      className: "github-HunkHeaderView-title"
    }, this.props.hunk.getHeader().trim(), " ", this.props.hunk.getSectionHeading().trim()), this.renderButtons());
  }

  renderButtons() {
    if (this.props.itemType === _commitDetailItem.default || this.props.itemType === _issueishDetailItem.default) {
      return null;
    } else {
      return _react.default.createElement(_react.Fragment, null, _react.default.createElement("button", {
        className: "github-HunkHeaderView-stageButton",
        onClick: this.props.toggleSelection,
        onMouseDown: theBuckStopsHere
      }, _react.default.createElement(_keystroke.default, {
        keymaps: this.props.keymaps,
        command: "core:confirm",
        refTarget: this.props.refTarget
      }), this.props.toggleSelectionLabel), this.props.stagingStatus === 'unstaged' && _react.default.createElement(_react.Fragment, null, _react.default.createElement("button", {
        ref: this.refDiscardButton.setter,
        className: "icon-trashcan github-HunkHeaderView-discardButton",
        onClick: this.props.discardSelection,
        onMouseDown: theBuckStopsHere
      }), _react.default.createElement(_tooltip.default, {
        manager: this.props.tooltips,
        target: this.refDiscardButton,
        title: this.props.discardSelectionLabel
      })));
    }
  }

  didMouseDown(event) {
    return this.props.mouseDown(event, this.props.hunk);
  }

}

exports.default = HunkHeaderView;

_defineProperty(HunkHeaderView, "propTypes", {
  refTarget: _propTypes2.RefHolderPropType.isRequired,
  hunk: _propTypes.default.object.isRequired,
  isSelected: _propTypes.default.bool.isRequired,
  stagingStatus: _propTypes.default.oneOf(['unstaged', 'staged']),
  selectionMode: _propTypes.default.oneOf(['hunk', 'line']).isRequired,
  toggleSelectionLabel: _propTypes.default.string,
  discardSelectionLabel: _propTypes.default.string,
  tooltips: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  toggleSelection: _propTypes.default.func,
  discardSelection: _propTypes.default.func,
  mouseDown: _propTypes.default.func.isRequired,
  itemType: _propTypes2.ItemTypePropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh1bmstaGVhZGVyLXZpZXcuanMiXSwibmFtZXMiOlsidGhlQnVja1N0b3BzSGVyZSIsImV2ZW50Iiwic3RvcFByb3BhZ2F0aW9uIiwiSHVua0hlYWRlclZpZXciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJyZWZEaXNjYXJkQnV0dG9uIiwiUmVmSG9sZGVyIiwicmVuZGVyIiwiY29uZGl0aW9uYWwiLCJpc1NlbGVjdGVkIiwic2VsZWN0aW9uTW9kZSIsImRpZE1vdXNlRG93biIsImh1bmsiLCJnZXRIZWFkZXIiLCJ0cmltIiwiZ2V0U2VjdGlvbkhlYWRpbmciLCJyZW5kZXJCdXR0b25zIiwiaXRlbVR5cGUiLCJDb21taXREZXRhaWxJdGVtIiwiSXNzdWVpc2hEZXRhaWxJdGVtIiwidG9nZ2xlU2VsZWN0aW9uIiwia2V5bWFwcyIsInJlZlRhcmdldCIsInRvZ2dsZVNlbGVjdGlvbkxhYmVsIiwic3RhZ2luZ1N0YXR1cyIsInNldHRlciIsImRpc2NhcmRTZWxlY3Rpb24iLCJ0b29sdGlwcyIsImRpc2NhcmRTZWxlY3Rpb25MYWJlbCIsIm1vdXNlRG93biIsIlJlZkhvbGRlclByb3BUeXBlIiwiaXNSZXF1aXJlZCIsIlByb3BUeXBlcyIsIm9iamVjdCIsImJvb2wiLCJvbmVPZiIsInN0cmluZyIsImZ1bmMiLCJJdGVtVHlwZVByb3BUeXBlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBRUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7Ozs7O0FBRUEsU0FBU0EsZ0JBQVQsQ0FBMEJDLEtBQTFCLEVBQWlDO0FBQy9CQSxFQUFBQSxLQUFLLENBQUNDLGVBQU47QUFDRDs7QUFFYyxNQUFNQyxjQUFOLFNBQTZCQyxlQUFNQyxTQUFuQyxDQUE2QztBQW1CMURDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47QUFDQSwyQkFBUyxJQUFULEVBQWUsY0FBZixFQUErQixlQUEvQjtBQUVBLFNBQUtDLGdCQUFMLEdBQXdCLElBQUlDLGtCQUFKLEVBQXhCO0FBQ0Q7O0FBRURDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFVBQU1DLFdBQVcsR0FBRztBQUNsQiwyQ0FBcUMsS0FBS0osS0FBTCxDQUFXSyxVQUQ5QjtBQUVsQiwyQ0FBcUMsS0FBS0wsS0FBTCxDQUFXTSxhQUFYLEtBQTZCO0FBRmhELEtBQXBCO0FBS0EsV0FDRTtBQUFLLE1BQUEsU0FBUyxFQUFFLHlCQUFHLHVCQUFILEVBQTRCRixXQUE1QixDQUFoQjtBQUEwRCxNQUFBLFdBQVcsRUFBRSxLQUFLRztBQUE1RSxPQUNFO0FBQU0sTUFBQSxTQUFTLEVBQUM7QUFBaEIsT0FDRyxLQUFLUCxLQUFMLENBQVdRLElBQVgsQ0FBZ0JDLFNBQWhCLEdBQTRCQyxJQUE1QixFQURILE9BQ3dDLEtBQUtWLEtBQUwsQ0FBV1EsSUFBWCxDQUFnQkcsaUJBQWhCLEdBQW9DRCxJQUFwQyxFQUR4QyxDQURGLEVBSUcsS0FBS0UsYUFBTCxFQUpILENBREY7QUFRRDs7QUFFREEsRUFBQUEsYUFBYSxHQUFHO0FBQ2QsUUFBSSxLQUFLWixLQUFMLENBQVdhLFFBQVgsS0FBd0JDLHlCQUF4QixJQUE0QyxLQUFLZCxLQUFMLENBQVdhLFFBQVgsS0FBd0JFLDJCQUF4RSxFQUE0RjtBQUMxRixhQUFPLElBQVA7QUFDRCxLQUZELE1BRU87QUFDTCxhQUNFLDZCQUFDLGVBQUQsUUFDRTtBQUNFLFFBQUEsU0FBUyxFQUFDLG1DQURaO0FBRUUsUUFBQSxPQUFPLEVBQUUsS0FBS2YsS0FBTCxDQUFXZ0IsZUFGdEI7QUFHRSxRQUFBLFdBQVcsRUFBRXZCO0FBSGYsU0FJRSw2QkFBQyxrQkFBRDtBQUFXLFFBQUEsT0FBTyxFQUFFLEtBQUtPLEtBQUwsQ0FBV2lCLE9BQS9CO0FBQXdDLFFBQUEsT0FBTyxFQUFDLGNBQWhEO0FBQStELFFBQUEsU0FBUyxFQUFFLEtBQUtqQixLQUFMLENBQVdrQjtBQUFyRixRQUpGLEVBS0csS0FBS2xCLEtBQUwsQ0FBV21CLG9CQUxkLENBREYsRUFRRyxLQUFLbkIsS0FBTCxDQUFXb0IsYUFBWCxLQUE2QixVQUE3QixJQUNDLDZCQUFDLGVBQUQsUUFDRTtBQUNFLFFBQUEsR0FBRyxFQUFFLEtBQUtuQixnQkFBTCxDQUFzQm9CLE1BRDdCO0FBRUUsUUFBQSxTQUFTLEVBQUMsbURBRlo7QUFHRSxRQUFBLE9BQU8sRUFBRSxLQUFLckIsS0FBTCxDQUFXc0IsZ0JBSHRCO0FBSUUsUUFBQSxXQUFXLEVBQUU3QjtBQUpmLFFBREYsRUFPRSw2QkFBQyxnQkFBRDtBQUNFLFFBQUEsT0FBTyxFQUFFLEtBQUtPLEtBQUwsQ0FBV3VCLFFBRHRCO0FBRUUsUUFBQSxNQUFNLEVBQUUsS0FBS3RCLGdCQUZmO0FBR0UsUUFBQSxLQUFLLEVBQUUsS0FBS0QsS0FBTCxDQUFXd0I7QUFIcEIsUUFQRixDQVRKLENBREY7QUEwQkQ7QUFDRjs7QUFFRGpCLEVBQUFBLFlBQVksQ0FBQ2IsS0FBRCxFQUFRO0FBQ2xCLFdBQU8sS0FBS00sS0FBTCxDQUFXeUIsU0FBWCxDQUFxQi9CLEtBQXJCLEVBQTRCLEtBQUtNLEtBQUwsQ0FBV1EsSUFBdkMsQ0FBUDtBQUNEOztBQTdFeUQ7Ozs7Z0JBQXZDWixjLGVBQ0E7QUFDakJzQixFQUFBQSxTQUFTLEVBQUVRLDhCQUFrQkMsVUFEWjtBQUVqQm5CLEVBQUFBLElBQUksRUFBRW9CLG1CQUFVQyxNQUFWLENBQWlCRixVQUZOO0FBR2pCdEIsRUFBQUEsVUFBVSxFQUFFdUIsbUJBQVVFLElBQVYsQ0FBZUgsVUFIVjtBQUlqQlAsRUFBQUEsYUFBYSxFQUFFUSxtQkFBVUcsS0FBVixDQUFnQixDQUFDLFVBQUQsRUFBYSxRQUFiLENBQWhCLENBSkU7QUFLakJ6QixFQUFBQSxhQUFhLEVBQUVzQixtQkFBVUcsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxNQUFULENBQWhCLEVBQWtDSixVQUxoQztBQU1qQlIsRUFBQUEsb0JBQW9CLEVBQUVTLG1CQUFVSSxNQU5mO0FBT2pCUixFQUFBQSxxQkFBcUIsRUFBRUksbUJBQVVJLE1BUGhCO0FBU2pCVCxFQUFBQSxRQUFRLEVBQUVLLG1CQUFVQyxNQUFWLENBQWlCRixVQVRWO0FBVWpCVixFQUFBQSxPQUFPLEVBQUVXLG1CQUFVQyxNQUFWLENBQWlCRixVQVZUO0FBWWpCWCxFQUFBQSxlQUFlLEVBQUVZLG1CQUFVSyxJQVpWO0FBYWpCWCxFQUFBQSxnQkFBZ0IsRUFBRU0sbUJBQVVLLElBYlg7QUFjakJSLEVBQUFBLFNBQVMsRUFBRUcsbUJBQVVLLElBQVYsQ0FBZU4sVUFkVDtBQWVqQmQsRUFBQUEsUUFBUSxFQUFFcUIsNkJBQWlCUDtBQWZWLEMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNi4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCwge0ZyYWdtZW50fSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IGN4IGZyb20gJ2NsYXNzbmFtZXMnO1xuXG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCB7UmVmSG9sZGVyUHJvcFR5cGUsIEl0ZW1UeXBlUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IFJlZkhvbGRlciBmcm9tICcuLi9tb2RlbHMvcmVmLWhvbGRlcic7XG5pbXBvcnQgVG9vbHRpcCBmcm9tICcuLi9hdG9tL3Rvb2x0aXAnO1xuaW1wb3J0IEtleXN0cm9rZSBmcm9tICcuLi9hdG9tL2tleXN0cm9rZSc7XG5pbXBvcnQgQ29tbWl0RGV0YWlsSXRlbSBmcm9tICcuLi9pdGVtcy9jb21taXQtZGV0YWlsLWl0ZW0nO1xuaW1wb3J0IElzc3VlaXNoRGV0YWlsSXRlbSBmcm9tICcuLi9pdGVtcy9pc3N1ZWlzaC1kZXRhaWwtaXRlbSc7XG5cbmZ1bmN0aW9uIHRoZUJ1Y2tTdG9wc0hlcmUoZXZlbnQpIHtcbiAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKCk7XG59XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEh1bmtIZWFkZXJWaWV3IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICByZWZUYXJnZXQ6IFJlZkhvbGRlclByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgaHVuazogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGlzU2VsZWN0ZWQ6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG4gICAgc3RhZ2luZ1N0YXR1czogUHJvcFR5cGVzLm9uZU9mKFsndW5zdGFnZWQnLCAnc3RhZ2VkJ10pLFxuICAgIHNlbGVjdGlvbk1vZGU6IFByb3BUeXBlcy5vbmVPZihbJ2h1bmsnLCAnbGluZSddKS5pc1JlcXVpcmVkLFxuICAgIHRvZ2dsZVNlbGVjdGlvbkxhYmVsOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIGRpc2NhcmRTZWxlY3Rpb25MYWJlbDogUHJvcFR5cGVzLnN0cmluZyxcblxuICAgIHRvb2x0aXBzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAga2V5bWFwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuXG4gICAgdG9nZ2xlU2VsZWN0aW9uOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBkaXNjYXJkU2VsZWN0aW9uOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBtb3VzZURvd246IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgaXRlbVR5cGU6IEl0ZW1UeXBlUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgfTtcblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgICBhdXRvYmluZCh0aGlzLCAnZGlkTW91c2VEb3duJywgJ3JlbmRlckJ1dHRvbnMnKTtcblxuICAgIHRoaXMucmVmRGlzY2FyZEJ1dHRvbiA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCBjb25kaXRpb25hbCA9IHtcbiAgICAgICdnaXRodWItSHVua0hlYWRlclZpZXctLWlzU2VsZWN0ZWQnOiB0aGlzLnByb3BzLmlzU2VsZWN0ZWQsXG4gICAgICAnZ2l0aHViLUh1bmtIZWFkZXJWaWV3LS1pc0h1bmtNb2RlJzogdGhpcy5wcm9wcy5zZWxlY3Rpb25Nb2RlID09PSAnaHVuaycsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT17Y3goJ2dpdGh1Yi1IdW5rSGVhZGVyVmlldycsIGNvbmRpdGlvbmFsKX0gb25Nb3VzZURvd249e3RoaXMuZGlkTW91c2VEb3dufT5cbiAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLUh1bmtIZWFkZXJWaWV3LXRpdGxlXCI+XG4gICAgICAgICAge3RoaXMucHJvcHMuaHVuay5nZXRIZWFkZXIoKS50cmltKCl9IHt0aGlzLnByb3BzLmh1bmsuZ2V0U2VjdGlvbkhlYWRpbmcoKS50cmltKCl9XG4gICAgICAgIDwvc3Bhbj5cbiAgICAgICAge3RoaXMucmVuZGVyQnV0dG9ucygpfVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckJ1dHRvbnMoKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuaXRlbVR5cGUgPT09IENvbW1pdERldGFpbEl0ZW0gfHwgdGhpcy5wcm9wcy5pdGVtVHlwZSA9PT0gSXNzdWVpc2hEZXRhaWxJdGVtKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPEZyYWdtZW50PlxuICAgICAgICAgIDxidXR0b25cbiAgICAgICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1IdW5rSGVhZGVyVmlldy1zdGFnZUJ1dHRvblwiXG4gICAgICAgICAgICBvbkNsaWNrPXt0aGlzLnByb3BzLnRvZ2dsZVNlbGVjdGlvbn1cbiAgICAgICAgICAgIG9uTW91c2VEb3duPXt0aGVCdWNrU3RvcHNIZXJlfT5cbiAgICAgICAgICAgIDxLZXlzdHJva2Uga2V5bWFwcz17dGhpcy5wcm9wcy5rZXltYXBzfSBjb21tYW5kPVwiY29yZTpjb25maXJtXCIgcmVmVGFyZ2V0PXt0aGlzLnByb3BzLnJlZlRhcmdldH0gLz5cbiAgICAgICAgICAgIHt0aGlzLnByb3BzLnRvZ2dsZVNlbGVjdGlvbkxhYmVsfVxuICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICAgIHt0aGlzLnByb3BzLnN0YWdpbmdTdGF0dXMgPT09ICd1bnN0YWdlZCcgJiYgKFxuICAgICAgICAgICAgPEZyYWdtZW50PlxuICAgICAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICAgICAgcmVmPXt0aGlzLnJlZkRpc2NhcmRCdXR0b24uc2V0dGVyfVxuICAgICAgICAgICAgICAgIGNsYXNzTmFtZT1cImljb24tdHJhc2hjYW4gZ2l0aHViLUh1bmtIZWFkZXJWaWV3LWRpc2NhcmRCdXR0b25cIlxuICAgICAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMucHJvcHMuZGlzY2FyZFNlbGVjdGlvbn1cbiAgICAgICAgICAgICAgICBvbk1vdXNlRG93bj17dGhlQnVja1N0b3BzSGVyZX1cbiAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICAgPFRvb2x0aXBcbiAgICAgICAgICAgICAgICBtYW5hZ2VyPXt0aGlzLnByb3BzLnRvb2x0aXBzfVxuICAgICAgICAgICAgICAgIHRhcmdldD17dGhpcy5yZWZEaXNjYXJkQnV0dG9ufVxuICAgICAgICAgICAgICAgIHRpdGxlPXt0aGlzLnByb3BzLmRpc2NhcmRTZWxlY3Rpb25MYWJlbH1cbiAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgIDwvRnJhZ21lbnQ+XG4gICAgICAgICAgKX1cbiAgICAgICAgPC9GcmFnbWVudD5cbiAgICAgICk7XG4gICAgfVxuICB9XG5cbiAgZGlkTW91c2VEb3duKGV2ZW50KSB7XG4gICAgcmV0dXJuIHRoaXMucHJvcHMubW91c2VEb3duKGV2ZW50LCB0aGlzLnByb3BzLmh1bmspO1xuICB9XG59XG4iXX0=