"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareGithubDotcomMarkdown = void 0;

var _eventKit = require("event-kit");

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _issueishLink = require("./issueish-link");

var _userMentionTooltipItem = _interopRequireDefault(require("../items/user-mention-tooltip-item"));

var _issueishTooltipItem = _interopRequireDefault(require("../items/issueish-tooltip-item"));

var _relayEnvironment = _interopRequireDefault(require("./relay-environment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareGithubDotcomMarkdown extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick', 'openLinkInNewTab', 'openLinkInThisTab', 'openLinkInBrowser');
  }

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom.default.findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.setupTooltipHandlers();
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem.default(node.textContent, this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        class: 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem.default(node.getAttribute('href'), this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        class: 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-DotComMarkdownHtml",
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: {
        __html: this.props.html
      }
    });
  }

  handleClick(event) {
    if (event.target.dataset.url) {
      return this.props.handleClickEvent(event, event.target.dataset.url);
    } else {
      return null;
    }
  }

  openLinkInNewTab(event) {
    return this.props.openIssueishLinkInNewTab(event.target.dataset.url);
  }

  openLinkInThisTab(event) {
    const {
      repoOwner,
      repoName,
      issueishNumber
    } = (0, _issueishLink.getDataFromGithubUrl)(event.target.dataset.url);
    this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
  }

  openLinkInBrowser(event) {
    return this.props.openLinkInBrowser(event.target.getAttribute('href'));
  }

}

exports.BareGithubDotcomMarkdown = BareGithubDotcomMarkdown;

_defineProperty(BareGithubDotcomMarkdown, "propTypes", {
  relayEnvironment: _propTypes.default.object.isRequired,
  html: _propTypes.default.string.isRequired,
  switchToIssueish: _propTypes.default.func.isRequired,
  handleClickEvent: _propTypes.default.func,
  openIssueishLinkInNewTab: _propTypes.default.func,
  openLinkInBrowser: _propTypes.default.func
});

_defineProperty(BareGithubDotcomMarkdown, "defaultProps", {
  handleClickEvent: _issueishLink.handleClickEvent,
  openIssueishLinkInNewTab: _issueishLink.openIssueishLinkInNewTab,
  openLinkInBrowser: _issueishLink.openLinkInBrowser
});

class GithubDotcomMarkdown extends _react.default.Component {
  render() {
    return _react.default.createElement(_relayEnvironment.default.Consumer, null, relayEnvironment => _react.default.createElement(BareGithubDotcomMarkdown, _extends({
      relayEnvironment: relayEnvironment
    }, this.props)));
  }

}

exports.default = GithubDotcomMarkdown;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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