"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FilePatchListItemView extends _react.default.Component {
  constructor(props) {
    super(props);
    this.refItem = new _refHolder.default();
    this.subs = new _eventKit.CompositeDisposable(this.refItem.observe(item => this.props.registerItemElement(this.props.filePatch, item)));
  }

  render() {
    const _this$props = this.props,
          {
      filePatch,
      selected
    } = _this$props,
          others = _objectWithoutProperties(_this$props, ["filePatch", "selected"]);

    delete others.registerItemElement;
    const status = _helpers.classNameForStatus[filePatch.status];
    const className = selected ? 'is-selected' : '';
    return _react.default.createElement("div", _extends({
      ref: this.refItem.setter
    }, others, {
      className: `github-FilePatchListView-item is-${status} ${className}`
    }), _react.default.createElement("span", {
      className: `github-FilePatchListView-icon icon icon-diff-${status} status-${status}`
    }), _react.default.createElement("span", {
      className: "github-FilePatchListView-path"
    }, filePatch.filePath));
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

}

exports.default = FilePatchListItemView;

_defineProperty(FilePatchListItemView, "propTypes", {
  filePatch: _propTypes2.FilePatchItemPropType.isRequired,
  selected: _propTypes.default.bool.isRequired,
  registerItemElement: _propTypes.default.func
});

_defineProperty(FilePatchListItemView, "defaultProps", {
  registerItemElement: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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