"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain a single project once bootstrapping
 * has completed. Presents in the UI like the Loading state.
 */
class LoadingGuess extends _state.default {
  isLoadingGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return true;
  }

  showGitTabInit() {
    return false;
  }

  hasDirectory() {
    return false;
  }

}

exports.default = LoadingGuess;

_state.default.register(LoadingGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvYWRpbmctZ3Vlc3MuanMiXSwibmFtZXMiOlsiTG9hZGluZ0d1ZXNzIiwiU3RhdGUiLCJpc0xvYWRpbmdHdWVzcyIsImlzVW5kZXRlcm1pbmVkIiwic2hvd0dpdFRhYkxvYWRpbmciLCJzaG93R2l0VGFiSW5pdCIsImhhc0RpcmVjdG9yeSIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7QUFFQTs7OztBQUllLE1BQU1BLFlBQU4sU0FBMkJDLGNBQTNCLENBQWlDO0FBQzlDQyxFQUFBQSxjQUFjLEdBQUc7QUFDZixXQUFPLElBQVA7QUFDRDs7QUFFREMsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxjQUFjLEdBQUc7QUFDZixXQUFPLEtBQVA7QUFDRDs7QUFFREMsRUFBQUEsWUFBWSxHQUFHO0FBQ2IsV0FBTyxLQUFQO0FBQ0Q7O0FBbkI2Qzs7OztBQXNCaERMLGVBQU1NLFFBQU4sQ0FBZVAsWUFBZiIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM2LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIEluaXRpYWwgc3RhdGUgdG8gYmUgdXNlZCB3aGVuIHdlIGFudGljaXBhdGUgdGhhdCB0aGUgd29ya3NwYWNlIHdpbGwgY29udGFpbiBhIHNpbmdsZSBwcm9qZWN0IG9uY2UgYm9vdHN0cmFwcGluZ1xuICogaGFzIGNvbXBsZXRlZC4gUHJlc2VudHMgaW4gdGhlIFVJIGxpa2UgdGhlIExvYWRpbmcgc3RhdGUuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIExvYWRpbmdHdWVzcyBleHRlbmRzIFN0YXRlIHtcbiAgaXNMb2FkaW5nR3Vlc3MoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBpc1VuZGV0ZXJtaW5lZCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIHNob3dHaXRUYWJMb2FkaW5nKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgc2hvd0dpdFRhYkluaXQoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgaGFzRGlyZWN0b3J5KCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxufVxuXG5TdGF0ZS5yZWdpc3RlcihMb2FkaW5nR3Vlc3MpO1xuIl19