"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Git is asynchronously initializing a new repository in this working directory.
 */
class Initializing extends _state.default {
  async start() {
    await this.doInit(this.workdir());
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directInit(workdir) {
    return this.git().init(workdir);
  }

}

exports.default = Initializing;

_state.default.register(Initializing);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXRpYWxpemluZy5qcyJdLCJuYW1lcyI6WyJJbml0aWFsaXppbmciLCJTdGF0ZSIsInN0YXJ0IiwiZG9Jbml0Iiwid29ya2RpciIsInRyYW5zaXRpb25UbyIsInNob3dHaXRUYWJMb2FkaW5nIiwiZGlyZWN0SW5pdCIsImdpdCIsImluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBRUE7OztBQUdlLE1BQU1BLFlBQU4sU0FBMkJDLGNBQTNCLENBQWlDO0FBQzlDLFFBQU1DLEtBQU4sR0FBYztBQUNaLFVBQU0sS0FBS0MsTUFBTCxDQUFZLEtBQUtDLE9BQUwsRUFBWixDQUFOO0FBRUEsVUFBTSxLQUFLQyxZQUFMLENBQWtCLFNBQWxCLENBQU47QUFDRDs7QUFFREMsRUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLFVBQVUsQ0FBQ0gsT0FBRCxFQUFVO0FBQ2xCLFdBQU8sS0FBS0ksR0FBTCxHQUFXQyxJQUFYLENBQWdCTCxPQUFoQixDQUFQO0FBQ0Q7O0FBYjZDOzs7O0FBZ0JoREgsZUFBTVMsUUFBTixDQUFlVixZQUFmIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogR2l0IGlzIGFzeW5jaHJvbm91c2x5IGluaXRpYWxpemluZyBhIG5ldyByZXBvc2l0b3J5IGluIHRoaXMgd29ya2luZyBkaXJlY3RvcnkuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEluaXRpYWxpemluZyBleHRlbmRzIFN0YXRlIHtcbiAgYXN5bmMgc3RhcnQoKSB7XG4gICAgYXdhaXQgdGhpcy5kb0luaXQodGhpcy53b3JrZGlyKCkpO1xuXG4gICAgYXdhaXQgdGhpcy50cmFuc2l0aW9uVG8oJ0xvYWRpbmcnKTtcbiAgfVxuXG4gIHNob3dHaXRUYWJMb2FkaW5nKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgZGlyZWN0SW5pdCh3b3JrZGlyKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2l0KCkuaW5pdCh3b3JrZGlyKTtcbiAgfVxufVxuXG5TdGF0ZS5yZWdpc3RlcihJbml0aWFsaXppbmcpO1xuIl19