"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _eventKit = require("event-kit");

class ResolutionProgress {
  constructor() {
    this.emitter = new _eventKit.Emitter();
    this.markerCountByPath = new Map();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  reportMarkerCount(path, count) {
    const previous = this.markerCountByPath.get(path);
    this.markerCountByPath.set(path, count);

    if (count !== previous) {
      this.didUpdate();
    }
  }

  getRemaining(path) {
    return this.markerCountByPath.get(path);
  }

  isEmpty() {
    return this.markerCountByPath.size === 0;
  }

}

exports.default = ResolutionProgress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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