"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BOTTOM = exports.MIDDLE = exports.TOP = void 0;

class Position {
  constructor(name, cssClass) {
    this.name = name.toLowerCase();
    this.cssClass = cssClass;
  }

  getName() {
    return this.name;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side position: ${this.name}`);
    });

    return chosen();
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toString() {
    return `<Position: ${this.name.toUpperCase()}>`;
  }

}

const TOP = new Position('TOP', 'github-ConflictTop');
exports.TOP = TOP;
const MIDDLE = new Position('MIDDLE', 'github-ConflictMiddle');
exports.MIDDLE = MIDDLE;
const BOTTOM = new Position('BOTTOM', 'github-ConflictBottom');
exports.BOTTOM = BOTTOM;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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