"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _commitDetailContainer = _interopRequireDefault(require("../containers/commit-detail-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailItem extends _react.default.Component {
  static buildURI(workingDirectory, sha) {
    return `atom-github://commit-detail?workdir=${encodeURIComponent(workingDirectory)}&sha=${encodeURIComponent(sha)}`;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.shouldFocus = true;
    this.refInitialFocus = new _refHolder.default();
    this.refEditor = new _refHolder.default();
    this.refEditor.observe(editor => {
      this.emitter.emit('did-change-embedded-text-editor', editor);
    });
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react.default.createElement(_commitDetailContainer.default, _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refEditor: this.refEditor,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return `Commit: ${this.props.sha}`;
  }

  getIconName() {
    return 'git-commit';
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  getSha() {
    return this.props.sha;
  }

  serialize() {
    return {
      deserializer: 'CommitDetailStub',
      uri: CommitDetailItem.buildURI(this.props.workingDirectory, this.props.sha)
    };
  }

  preventFocus() {
    this.shouldFocus = false;
  }

  focus() {
    this.refInitialFocus.getPromise().then(focusable => {
      if (!this.shouldFocus) {
        return;
      }

      focusable.focus();
    });
  }

}

exports.default = CommitDetailItem;

_defineProperty(CommitDetailItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  sha: _propTypes.default.string.isRequired
});

_defineProperty(CommitDetailItem, "uriPattern", 'atom-github://commit-detail?workdir={workingDirectory}&sha={sha}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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