"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareIssueishDetailController = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _gitShellOutStrategy = require("../git-shell-out-strategy");

var _enableableOperation = _interopRequireDefault(require("../models/enableable-operation"));

var _prDetailView = _interopRequireWildcard(require("../views/pr-detail-view"));

var _issueDetailView = _interopRequireDefault(require("../views/issue-detail-view"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueishDetailController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openCommit", async ({
      sha
    }) => {
      /* istanbul ignore if */
      if (!this.props.workdirPath) {
        return;
      }

      const uri = _commitDetailItem.default.buildURI(this.props.workdirPath, sha);

      await this.props.workspace.open(uri, {
        pending: true
      });
      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        package: 'github',
        from: this.constructor.name
      });
    });

    this.state = {
      checkoutInProgress: false,
      typename: null
    };
    this.checkoutOp = new _enableableOperation.default(() => this.checkout().catch(e => {
      if (!(e instanceof _gitShellOutStrategy.GitError)) {
        throw e;
      }
    }));
    this.checkoutOp.toggleState(this, 'checkoutInProgress');
  } //  storing `typename` in state to avoid having to do ugly long chained lookups in several places.
  // note that whether we're rendering an Issue or a PullRequest,
  // relay returns both issue and pull request data.
  // So a pullRequest can have a __typename of `Issue` or `PullRequest`, which is // then set in state here.


  static getDerivedStateFromProps(nextProps, prevState) {
    const {
      repository
    } = nextProps;
    const typename = repository && repository.pullRequest && repository.pullRequest.__typename ? repository.pullRequest.__typename : null;

    if (typename && prevState.typename !== typename) {
      return {
        typename
      };
    } else {
      return null;
    }
  }

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const {
      repository
    } = this.props;

    if (repository && (repository.issue || repository.pullRequest)) {
      let prefix, issueish;

      if (this.state.typename === 'PullRequest') {
        prefix = 'PR:';
        issueish = repository.pullRequest;
      } else {
        prefix = 'Issue:';
        issueish = repository.issue;
      }

      const title = `${prefix} ${repository.owner.login}/${repository.name}#${issueish.number} — ${issueish.title}`;
      this.props.onTitleChange(title);
    }
  }

  render() {
    const {
      repository
    } = this.props;

    if (!repository || !repository.issue || !repository.pullRequest) {
      return _react.default.createElement("div", null, "Issue/PR #", this.props.issueishNumber, " not found"); // TODO: no PRs
    }

    this.checkoutOp = this.nextCheckoutOp();

    if (this.state.typename === 'PullRequest') {
      return _react.default.createElement(_prDetailView.default, {
        localRepository: this.props.localRepository,
        repository: repository,
        pullRequest: repository.pullRequest,
        checkoutOp: this.checkoutOp,
        switchToIssueish: this.props.switchToIssueish,
        endpoint: this.props.endpoint,
        token: this.props.token,
        workspace: this.props.workspace,
        commands: this.props.commands,
        keymaps: this.props.keymaps,
        tooltips: this.props.tooltips,
        config: this.props.config,
        openCommit: this.openCommit,
        itemType: this.props.itemType,
        destroy: this.props.destroy,
        refEditor: this.props.refEditor
      });
    } else {
      return _react.default.createElement(_issueDetailView.default, {
        repository: repository,
        issue: repository.issue,
        switchToIssueish: this.props.switchToIssueish
      });
    }
  }

  nextCheckoutOp() {
    const {
      repository
    } = this.props;
    const {
      pullRequest
    } = repository;

    if (this.state.typename !== 'PullRequest') {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.HIDDEN, 'Cannot check out an issue');
    }

    if (this.props.isAbsent) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.HIDDEN, 'No repository found');
    }

    if (this.props.isLoading) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Loading');
    }

    if (!this.props.isPresent) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'No repository found');
    }

    if (this.props.isMerging) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Merge in progress');
    }

    if (this.props.isRebasing) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Rebase in progress');
    }

    if (this.state.checkoutInProgress) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Checking out...');
    } // determine if pullRequest.headRepository is null
    // this can happen if a repository has been deleted.


    if (!pullRequest.headRepository) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Pull request head repository does not exist');
    } // Determine if we already have this PR checked out.


    const headPush = this.props.branches.getHeadBranch().getPush();
    const headRemote = this.props.remotes.withName(headPush.getRemoteName()); // (detect checkout from pull/### refspec)

    const fromPullRefspec = headRemote.getOwner() === repository.owner.login && headRemote.getRepo() === repository.name && headPush.getShortRemoteRef() === `pull/${pullRequest.number}/head`; // (detect checkout from head repository)

    const fromHeadRepo = headRemote.getOwner() === pullRequest.headRepository.owner.login && headRemote.getRepo() === pullRequest.headRepository.name && headPush.getShortRemoteRef() === pullRequest.headRefName;

    if (fromPullRefspec || fromHeadRepo) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.CURRENT, 'Current');
    }

    return this.checkoutOp.enable();
  }

  async checkout() {
    const {
      repository
    } = this.props;
    const {
      pullRequest
    } = repository;
    const {
      headRepository
    } = pullRequest;
    const fullHeadRef = `refs/heads/${pullRequest.headRefName}`;
    let sourceRemoteName, localRefName; // Discover or create a remote pointing to the repo containing the pull request's head ref.
    // If the local repository already has the head repository specified as a remote, that remote will be used, so
    // that any related configuration is picked up for the fetch. Otherwise, the head repository fetch URL is used
    // directly.

    const headRemotes = this.props.remotes.matchingGitHubRepository(headRepository.owner.login, headRepository.name);

    if (headRemotes.length > 0) {
      sourceRemoteName = headRemotes[0].getName();
    } else {
      const url = {
        https: headRepository.url + '.git',
        ssh: headRepository.sshUrl
      }[this.props.remotes.mostUsedProtocol(['https', 'ssh'])]; // This will throw if a remote with this name already exists (and points somewhere else, or we would have found
      // it above). ¯\_(ツ)_/¯

      const remote = await this.props.addRemote(headRepository.owner.login, url);
      sourceRemoteName = remote.getName();
    } // Identify an existing local ref that already corresponds to the pull request, if one exists. Otherwise, generate
    // a new local ref name.


    const pullTargets = this.props.branches.getPullTargets(sourceRemoteName, fullHeadRef);

    if (pullTargets.length > 0) {
      localRefName = pullTargets[0].getName(); // Check out the existing local ref.

      await this.props.checkout(localRefName);

      try {
        await this.props.pull(fullHeadRef, {
          remoteName: sourceRemoteName,
          ffOnly: true
        });
      } finally {
        (0, _reporterProxy.incrementCounter)('checkout-pr');
      }

      return;
    }

    await this.props.fetch(fullHeadRef, {
      remoteName: sourceRemoteName
    }); // Check out the local ref and set it up to track the head ref.

    await this.props.checkout(`pr-${pullRequest.number}/${headRepository.owner.login}/${pullRequest.headRefName}`, {
      createNew: true,
      track: true,
      startPoint: `refs/remotes/${sourceRemoteName}/${pullRequest.headRefName}`
    });
    (0, _reporterProxy.incrementCounter)('checkout-pr');
  }

}

exports.BareIssueishDetailController = BareIssueishDetailController;

_defineProperty(BareIssueishDetailController, "propTypes", {
  // Relay response
  repository: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    owner: _propTypes.default.shape({
      login: _propTypes.default.string.isRequired
    }).isRequired,
    pullRequest: _propTypes.default.any,
    issue: _propTypes.default.any
  }),
  issueishNumber: _propTypes.default.number.isRequired,
  // Local Repository model properties
  localRepository: _propTypes.default.object.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  isMerging: _propTypes.default.bool.isRequired,
  isRebasing: _propTypes.default.bool.isRequired,
  isAbsent: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  isPresent: _propTypes.default.bool.isRequired,
  workdirPath: _propTypes.default.string,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  // Action methods
  fetch: _propTypes.default.func.isRequired,
  checkout: _propTypes.default.func.isRequired,
  pull: _propTypes.default.func.isRequired,
  addRemote: _propTypes.default.func.isRequired,
  onTitleChange: _propTypes.default.func.isRequired,
  switchToIssueish: _propTypes.default.func.isRequired,
  destroy: _propTypes.default.func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishDetailController, {
  repository: function () {
    const node = require("./__generated__/issueishDetailController_repository.graphql");

    if (node.hash && node.hash !== "c06dfbb4f1cc1c45187449da61fd7328") {
      console.error("The definition of 'issueishDetailController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishDetailController_repository.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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