"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _whatTheDiff = require("what-the-diff");

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _multiFilePatchController = _interopRequireDefault(require("../controllers/multi-file-patch-controller"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _patch = require("../models/patch");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestChangedFilesContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    this.mfpSubs = new _eventKit.CompositeDisposable();
    this.state = {
      isLoading: true,
      error: null
    };
    this.fetchDiff();
  }

  componentDidUpdate(prevProps) {
    if (this.props.shouldRefetch && !prevProps.shouldRefetch) {
      this.setState({
        isLoading: true,
        error: null
      });
      this.fetchDiff();
    }
  }

  componentWillUnmount() {
    this.mfpSubs.dispose();
  } // Generate a v3 GitHub API REST URL for the pull request resource.
  // Example: https://api.github.com/repos/atom/github/pulls/1829


  getDiffURL() {
    return this.props.endpoint.getRestURI('repos', this.props.owner, this.props.repo, 'pulls', this.props.number);
  }

  buildPatch(rawDiff) {
    const diffs = (0, _whatTheDiff.parse)(rawDiff).map(diff => {
      // diff coming from API will have the defaul git diff prefixes a/ and b/ and use *nix-style / path separators.
      // e.g. a/dir/file1.js and b/dir/file2.js
      // see https://git-scm.com/docs/git-diff#_generating_patches_with_p
      return _objectSpread({}, diff, {
        newPath: diff.newPath ? (0, _helpers.toNativePathSep)(diff.newPath.replace(/^[a|b]\//, '')) : diff.newPath,
        oldPath: diff.oldPath ? (0, _helpers.toNativePathSep)(diff.oldPath.replace(/^[a|b]\//, '')) : diff.oldPath
      });
    });
    return (0, _patch.buildMultiFilePatch)(diffs);
  }

  async fetchDiff() {
    const diffError = (message, err = null) => new Promise(resolve => {
      if (err) {
        // eslint-disable-next-line no-console
        console.error(err);
      }

      this.setState({
        isLoading: false,
        error: message
      }, resolve);
    });

    const url = this.getDiffURL();
    const response = await fetch(url, {
      headers: {
        Accept: 'application/vnd.github.v3.diff',
        Authorization: `bearer ${this.props.token}`
      }
    }).catch(err => {
      diffError(`Network error encountered at fetching ${url}`, err);
    });

    if (this.state.error) {
      return;
    }

    try {
      if (response && response.ok) {
        const rawDiff = await response.text();
        const multiFilePatch = this.buildPatch(rawDiff);
        this.mfpSubs.dispose();
        this.mfpSubs = new _eventKit.CompositeDisposable();

        for (const fp of multiFilePatch.getFilePatches()) {
          this.mfpSubs.add(fp.onDidChangeRenderStatus(() => this.forceUpdate()));
        }

        await new Promise(resolve => this.setState({
          isLoading: false,
          multiFilePatch
        }, resolve));
      } else {
        diffError(`Unable to fetch diff for this pull request${response ? ': ' + response.statusText : ''}.`);
      }
    } catch (err) {
      diffError('Unable to parse diff for this pull request.', err);
    }
  }

  render() {
    if (this.state.isLoading) {
      return _react.default.createElement(_loadingView.default, null);
    }

    if (this.state.error) {
      return _react.default.createElement(_errorView.default, {
        descriptions: [this.state.error]
      });
    }

    return _react.default.createElement(_multiFilePatchController.default, _extends({
      multiFilePatch: this.state.multiFilePatch,
      repository: this.props.localRepository
    }, this.props));
  }

}

exports.default = PullRequestChangedFilesContainer;

_defineProperty(PullRequestChangedFilesContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  number: _propTypes.default.number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  // action methods
  destroy: _propTypes.default.func.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  // local repo as opposed to pull request repo
  localRepository: _propTypes.default.object.isRequired,
  // refetch diff on refresh
  shouldRefetch: _propTypes.default.bool.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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