"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _operationStateObserver = _interopRequireWildcard(require("../models/operation-state-observer"));

var _githubTabController = _interopRequireDefault(require("../controllers/github-tab-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _remoteSet = _interopRequireDefault(require("../models/remote-set"));

var _branchSet = _interopRequireDefault(require("../models/branch-set"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchRepositoryData', 'renderRepositoryData');
    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.repository !== state.lastRepository) {
      return {
        lastRepository: props.repository,
        remoteOperationObserver: new _operationStateObserver.default(props.repository, _operationStateObserver.PUSH, _operationStateObserver.PULL, _operationStateObserver.FETCH)
      };
    }

    return null;
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri.default)({
      workingDirectory: repository.getWorkingDirectoryPath(),
      allRemotes: repository.getRemotes(),
      branches: repository.getBranches(),
      selectedRemoteName: repository.getConfig('atomGithub.currentRemote'),
      aheadCount: async query => {
        const branches = await query.branches;
        const currentBranch = branches.getHeadBranch();
        return repository.getAheadCount(currentBranch.getName());
      },
      pushInProgress: repository.getOperationStates().isPushInProgress()
    });
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, this.renderRepositoryData);
  }

  renderRepositoryData(data) {
    if (!data || this.props.repository.isLoading()) {
      return _react.default.createElement(_githubTabController.default, _extends({}, this.props, {
        remoteOperationObserver: this.state.remoteOperationObserver,
        workingDirectory: "",
        allRemotes: new _remoteSet.default(),
        branches: new _branchSet.default(),
        aheadCount: 0,
        pushInProgress: false,
        isLoading: true
      }));
    }

    if (!this.props.repository.isPresent()) {
      // TODO include a better message here.
      return null;
    }

    return _react.default.createElement(_githubTabController.default, _extends({}, data, this.props, {
      remoteOperationObserver: this.state.remoteOperationObserver,
      isLoading: false
    }));
  }

}

exports.default = GitHubTabContainer;

_defineProperty(GitHubTabContainer, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  repository: _propTypes.default.object,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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