(function() {
  var convertMethodToSuggestion, convertPropertyToSuggestion, fs, getDocLink, isVisible, request, requestOptions, textComparator;

  fs = require('fs');

  request = require('request');

  requestOptions = {
    url: 'https://api.github.com/repos/atom/atom/releases/latest',
    json: true,
    headers: {
      'User-Agent': 'agent'
    }
  };

  request(requestOptions, function(error, response, release) {
    var apiAsset, apiRequestOptions;
    if (error != null) {
      console.error(error.message);
      return process.exit(1);
    }
    apiAsset = release.assets.filter(function(arg1) {
      var name;
      name = arg1.name;
      return name === 'atom-api.json';
    })[0];
    if (!(apiAsset != null ? apiAsset.browser_download_url : void 0)) {
      console.error('No atom-api.json asset found in latest release');
      return process.exit(1);
    }
    apiRequestOptions = {
      json: true,
      url: apiAsset.browser_download_url
    };
    return request(apiRequestOptions, function(error, response, atomApi) {
      var classes, instanceMethods, instanceProperties, methods, name, pluckMethodAttributes, pluckPropertyAttributes, properties, publicClasses, ref;
      if (error != null) {
        console.error(error.message);
        return process.exit(1);
      }
      classes = atomApi.classes;
      publicClasses = {};
      for (name in classes) {
        ref = classes[name], instanceProperties = ref.instanceProperties, instanceMethods = ref.instanceMethods;
        pluckPropertyAttributes = convertPropertyToSuggestion.bind(this, name);
        pluckMethodAttributes = convertMethodToSuggestion.bind(this, name);
        properties = instanceProperties.filter(isVisible).map(pluckPropertyAttributes).sort(textComparator);
        methods = instanceMethods.filter(isVisible).map(pluckMethodAttributes).sort(textComparator);
        if ((properties != null ? properties.length : void 0) > 0 || methods.length > 0) {
          publicClasses[name] = properties.concat(methods);
        }
      }
      return fs.writeFileSync('completions.json', JSON.stringify(publicClasses, null, '  '));
    });
  });

  isVisible = function(arg1) {
    var visibility;
    visibility = arg1.visibility;
    return visibility === 'Essential' || visibility === 'Extended' || visibility === 'Public';
  };

  convertMethodToSuggestion = function(className, method) {
    var arg, args, description, descriptionMoreURL, i, j, len, name, ref, returnValue, returnValues, snippet, snippets, summary, text;
    name = method.name, summary = method.summary, returnValues = method.returnValues;
    args = method['arguments'];
    snippets = [];
    if (args != null ? args.length : void 0) {
      for (i = j = 0, len = args.length; j < len; i = ++j) {
        arg = args[i];
        snippets.push("${" + (i + 1) + ":" + arg.name + "}");
      }
    }
    text = null;
    snippet = null;
    if (snippets.length) {
      snippet = name + "(" + (snippets.join(', ')) + ")";
    } else {
      text = name + "()";
    }
    returnValue = returnValues != null ? (ref = returnValues[0]) != null ? ref.type : void 0 : void 0;
    description = summary;
    descriptionMoreURL = getDocLink(className, name);
    return {
      name: name,
      text: text,
      snippet: snippet,
      description: description,
      descriptionMoreURL: descriptionMoreURL,
      leftLabel: returnValue,
      type: 'method'
    };
  };

  convertPropertyToSuggestion = function(className, arg1) {
    var description, descriptionMoreURL, name, ref, returnValue, summary, text;
    name = arg1.name, summary = arg1.summary;
    text = name;
    returnValue = summary != null ? (ref = summary.match(/\{(\w+)\}/)) != null ? ref[1] : void 0 : void 0;
    description = summary;
    descriptionMoreURL = getDocLink(className, name);
    return {
      name: name,
      text: text,
      description: description,
      descriptionMoreURL: descriptionMoreURL,
      leftLabel: returnValue,
      type: 'property'
    };
  };

  getDocLink = function(className, instanceName) {
    return "https://atom.io/docs/api/latest/" + className + "#instance-" + instanceName;
  };

  textComparator = function(a, b) {
    if (a.name > b.name) {
      return 1;
    }
    if (a.name < b.name) {
      return -1;
    }
    return 0;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
