/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;

public abstract class MemoryProfMethodInstrumentor
extends ClassManager {
    protected ArrayList instrClasses = new ArrayList();
    protected String[] instantiatableClasses;
    protected int injType;
    protected int instrClassId;
    protected int nInstantiatableClasses;
    protected int nInstrClasses;
    protected int nInstrMethods;

    public MemoryProfMethodInstrumentor(ProfilingSessionStatus profilingSessionStatus, int n) {
        super(profilingSessionStatus);
        this.status = profilingSessionStatus;
        this.instantiatableClasses = new String[100];
        this.injType = n;
    }

    public Object[] getInitialMethodsToInstrument(RootClassLoadedCommand rootClassLoadedCommand) {
        ArrayList<DynamicClassInfo> arrayList = new ArrayList<DynamicClassInfo>();
        MemoryProfMethodInstrumentor.resetLoadedClassData();
        this.initInstrumentationPackData();
        this.instrClassId = 0;
        MemoryProfMethodInstrumentor.storeClassFileBytesForCustomLoaderClasses(rootClassLoadedCommand);
        String[] stringArray = rootClassLoadedCommand.getAllLoadedClassNames();
        int[] nArray = rootClassLoadedCommand.getAllLoadedClassLoaderIds();
        for (int i = 0; i < stringArray.length; ++i) {
            DynamicClassInfo dynamicClassInfo = MemoryProfMethodInstrumentor.javaClassForName(stringArray[i], nArray[i]);
            if (this.classNeedsInstrumentation(dynamicClassInfo)) {
                dynamicClassInfo.preloadBytecode();
            }
            arrayList.add(dynamicClassInfo);
        }
        for (DynamicClassInfo dynamicClassInfo : arrayList) {
            this.findAndMarkMethodsToInstrumentInClass(dynamicClassInfo);
        }
        return this.createInstrumentedMethodPack();
    }

    public String[] getInstantiatableClasses() {
        return this.instantiatableClasses;
    }

    public Object[] getMethodsToInstrumentUponClassLoad(String string, int n) {
        this.initInstrumentationPackData();
        this.findAndMarkMethodsToInstrumentInClass(string, n);
        return this.createInstrumentedMethodPack();
    }

    public int getNInstantiatableClasses() {
        return this.nInstantiatableClasses;
    }

    protected void findAndMarkMethodsToInstrumentInClass(String string, int n) {
        this.findAndMarkMethodsToInstrumentInClass(MemoryProfMethodInstrumentor.javaClassForName(string, n));
    }

    protected void findAndMarkMethodsToInstrumentInClass(DynamicClassInfo dynamicClassInfo) {
        if (dynamicClassInfo == null) {
            return;
        }
        if (!dynamicClassInfo.isLoaded()) {
            dynamicClassInfo.setLoaded(true);
            if (dynamicClassInfo.getInstrClassId() == -1 && !dynamicClassInfo.isInterface()) {
                dynamicClassInfo.setInstrClassId(this.getNextClassId(dynamicClassInfo.getName()));
            }
            if (this.classNeedsInstrumentation(dynamicClassInfo)) {
                String[] stringArray = dynamicClassInfo.getMethodNames();
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (dynamicClassInfo.isMethodNative(i) || dynamicClassInfo.isMethodAbstract(i)) {
                        dynamicClassInfo.setMethodUnscannable(i);
                        continue;
                    }
                    if (!this.methodNeedsInstrumentation(dynamicClassInfo, i)) continue;
                    ++this.nInstrMethods;
                    dynamicClassInfo.setMethodInstrumented(i);
                    bl = true;
                }
                if (bl) {
                    ++this.nInstrClasses;
                    this.instrClasses.add(dynamicClassInfo);
                }
            }
        }
    }

    protected void initInstrumentationPackData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        this.nInstantiatableClasses = 0;
    }

    protected abstract boolean classNeedsInstrumentation(ClassInfo var1);

    protected abstract boolean methodNeedsInstrumentation(ClassInfo var1, int var2);

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected boolean hasNewOpcodes(ClassInfo classInfo, int n, boolean bl, boolean bl2, InstrumentationFilter instrumentationFilter) {
        MethodScanerForNewOpcodes methodScanerForNewOpcodes = new MethodScanerForNewOpcodes(classInfo, n, instrumentationFilter);
        return methodScanerForNewOpcodes.hasNewOpcodes(this, bl, bl2);
    }

    protected abstract byte[] instrumentMethod(DynamicClassInfo var1, int var2);

    protected boolean methodNeedsRewriting(DynamicClassInfo dynamicClassInfo, int n) {
        return dynamicClassInfo.isMethodInstrumented(n);
    }

    int getNextClassId(String string) {
        if (this.nInstantiatableClasses == this.instantiatableClasses.length) {
            String[] stringArray = this.instantiatableClasses;
            this.instantiatableClasses = new String[stringArray.length + 100];
            System.arraycopy(stringArray, 0, this.instantiatableClasses, 0, stringArray.length);
        }
        this.instantiatableClasses[this.nInstantiatableClasses++] = string;
        this.status.updateAllocatedInstancesCountInfoInClient(string);
        return this.instrClassId++;
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] stringArray = new String[this.nInstrClasses];
        int[] nArray = new int[this.nInstrClasses];
        byte[][] byArrayArray = new byte[this.nInstrClasses][];
        for (int i = 0; i < this.nInstrClasses; ++i) {
            DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)this.instrClasses.get(i);
            stringArray[i] = dynamicClassInfo.getName().replace('/', '.');
            nArray[i] = dynamicClassInfo.getLoaderId();
            String[] stringArray2 = dynamicClassInfo.getMethodNames();
            int n = stringArray2.length;
            byte[][] byArrayArray2 = new byte[n][];
            DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, this.injType);
            for (int j = 0; j < n; ++j) {
                byArrayArray2[j] = this.methodNeedsRewriting(dynamicClassInfo, j) ? this.instrumentMethod(dynamicClassInfo, j) : dynamicClassInfo.getMethodInfo(j);
            }
            DynamicConstantPoolExtension dynamicConstantPoolExtension = DynamicConstantPoolExtension.getAllAddedCPFragments(dynamicClassInfo);
            int n2 = dynamicConstantPoolExtension.getNEntries();
            byte[] byArray = dynamicConstantPoolExtension.getContents();
            byArrayArray[i] = ClassRewriter.rewriteClassFile(dynamicClassInfo, byArrayArray2, n2, byArray);
        }
        return new Object[]{stringArray, nArray, byArrayArray};
    }

    static class MethodScanerForNewOpcodes
    extends SingleMethodScaner {
        private final InstrumentationFilter instrFilter;

        MethodScanerForNewOpcodes(ClassInfo classInfo, int n, InstrumentationFilter instrumentationFilter) {
            super(classInfo, n);
            this.instrFilter = instrumentationFilter;
        }

        boolean hasNewOpcodes(MemoryProfMethodInstrumentor memoryProfMethodInstrumentor, boolean bl, boolean bl2) {
            if (!bl && !bl2) {
                return false;
            }
            int n = this.clazz.getLoaderId();
            boolean bl3 = false;
            for (int i = 0; i < this.bytecodesLength; i += this.opcodeLength(i)) {
                Object object;
                Object object2;
                int n2;
                int n3 = this.bytecodes[i] & 0xFF;
                if (n3 == 187 && bl) {
                    n2 = this.getU2(i + 1);
                    object2 = this.clazz.getRefClassName(n2);
                    if (!this.instrFilter.passes((String)object2)) continue;
                    bl3 = true;
                    object = ClassManager.javaClassOrPlaceholderForName((String)object2, n);
                    if (((BaseClassInfo)object).getInstrClassId() != -1) continue;
                    ((BaseClassInfo)object).setInstrClassId(memoryProfMethodInstrumentor.getNextClassId(((BaseClassInfo)object).getName()));
                    continue;
                }
                if ((n3 == 189 || n3 == 197) && bl2) {
                    n2 = this.getU2(i + 1);
                    object2 = this.clazz.getRefClassName(n2);
                    object = null;
                    if (n3 == 189) {
                        if (this.instrFilter.passes(((String)object2).concat("[]"))) {
                            object = ClassManager.javaClassForObjectArrayType((String)object2);
                        }
                    } else if (this.instrFilter.passes(MethodScanerForNewOpcodes.getMultiArrayClassName((String)object2))) {
                        object = ClassRepository.lookupSpecialClass((String)object2);
                    }
                    if (object == null) continue;
                    bl3 = true;
                    if (((BaseClassInfo)object).getInstrClassId() != -1) continue;
                    ((BaseClassInfo)object).setInstrClassId(memoryProfMethodInstrumentor.getNextClassId(((BaseClassInfo)object).getName()));
                    continue;
                }
                if (n3 != 188 || !bl2 || !this.instrFilter.passes((String)(object = StringUtils.userFormClassName(((BaseClassInfo)(object2 = ClassManager.javaClassForPrimitiveArrayType(n2 = this.getByte(i + 1)))).getName())))) continue;
                bl3 = true;
                if (((BaseClassInfo)object2).getInstrClassId() != -1) continue;
                ((BaseClassInfo)object2).setInstrClassId(memoryProfMethodInstrumentor.getNextClassId(((BaseClassInfo)object2).getName()));
            }
            return bl3;
        }

        private static String getMultiArrayClassName(String string) {
            int n = string.lastIndexOf(91);
            String string2 = string.substring(n + 1);
            if (VMUtils.isVMPrimitiveType(string2)) {
                return StringUtils.userFormClassName(string);
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() + n + 1);
            stringBuilder.append(string.substring(n + 1));
            for (int i = 0; i <= n; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }
    }
}

