/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sl;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Cuba = new String[] {
               "Kubanski standardni \u010das",
               "CST",
               "Kubanski poletni \u010das",
               "CDT",
               "Kubanski \u010das",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Zahodnoafri\u0161ki standardni \u010das",
               "WAST",
               "Zahodnoafri\u0161ki poletni \u010das",
               "WAST",
               "Zahodnoafri\u0161ki \u010das",
               "WAT",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdski standardni \u010das",
               "CVST",
               "Kapverdski poletni \u010das",
               "CVST",
               "Kapverdski \u010das",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Greenwi\u0161ki srednji \u010das",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Moscow = new String[] {
               "Moskovski standardni \u010das",
               "MST",
               "Moskovski poletni \u010das",
               "MST",
               "Moskovski \u010das",
               "MT",
            };
        final String[] Omsk = new String[] {
               "Om\u0161ki standardni \u010das",
               "OST",
               "Om\u0161ki poletni \u010das",
               "OST",
               "Om\u0161ki \u010das",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajski aleutski standardni \u010das",
               "HAST",
               "Havajski aleutski poletni \u010das",
               "HADT",
               "Havajski aleutski \u010das",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinski standardni \u010das",
               "SST",
               "Sahalinski poletni \u010das",
               "SST",
               "Sahalinski \u010das",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardni \u010das",
               "YST",
               "Jakutski poletni \u010das",
               "YST",
               "Jakutski \u010das",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Vzhodni kazahstanski \u010das",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Japan = new String[] {
               "Japonski standardni \u010das",
               "JST",
               "Japonski poletni \u010das",
               "JDT",
               "Japonski \u010das",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivosto\u0161ki standardni \u010das",
               "VST",
               "Vladivosto\u0161ki poletni \u010das",
               "VST",
               "Vladivosto\u0161ki \u010das",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Zahodnoevropski standardni \u010das",
               "WEST",
               "Zahodnoevropski poletni \u010das",
               "WEST",
               "Zahodnoevropski \u010das",
               "WET",
            };
        final String[] Brasilia = new String[] {
               "Brasilski standardni \u010das",
               "BST",
               "Brasilski poletni \u010das",
               "BST",
               "Brasilski \u010das",
               "BT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijski standardni \u010das",
               "CST",
               "Kolumbijski poletni \u010das",
               "CST",
               "Kolumbijski \u010das",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovdski standardni \u010das",
               "HST",
               "Hovdski poletni \u010das",
               "HST",
               "Hovdski \u010das",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonezijski zahodni \u010das",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "Amazonski standardni \u010das",
               "AST",
               "Amazonski poletni \u010das",
               "AST",
               "Amazonski \u010das",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatorski standardni \u010das",
               "UBST",
               "Ulanbatorski poletni \u010das",
               "UBST",
               "Ulanbatorski \u010das",
               "UBT",
            };
        final String[] Africa_Central = new String[] {
               "Centralnoafri\u0161ki \u010das",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonezijski osrednji \u010das",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "Pacifi\u0161ki standardni \u010das",
               "PST",
               "Pacifi\u0161ki poletni \u010das",
               "PDT",
               "Pacifi\u0161ki \u010das",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Argentinski zahodni standardni \u010das",
               "WAST",
               "Argentinski zahodni poletni \u010das",
               "WAST",
               "Argentinski zahodni \u010das",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "Novofundlandski standardni \u010das",
               "NST",
               "Novofundlandski poletni \u010das",
               "NDT",
               "Novofundlandski \u010das",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "Volgograjski standardni \u010das",
               "VST",
               "Volgograjski poletni \u010das",
               "VST",
               "Volgograjski \u010das",
               "VT",
            };
        final String[] America_Central = new String[] {
               "Centralni standardni \u010das",
               "CST",
               "Centralni poletni \u010das",
               "CDT",
               "Centralni \u010das",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Vzhodnoafri\u0161ki \u010das",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Korea = new String[] {
               "Korejski standardni \u010das",
               "KST",
               "Korejski poletni \u010das",
               "KDT",
               "Korejski \u010das",
               "KT",
            };
        final String[] Argentina = new String[] {
               "Argentinski standardni \u010das",
               "AST",
               "Argentinski poletni \u010das",
               "AST",
               "Argentinski \u010das",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbur\u0161ki standardni \u010das",
               "YST",
               "Jekaterinbur\u0161ki poletni \u010das",
               "YST",
               "Jekaterinbur\u0161ki \u010das",
               "YT",
            };
        final String[] China = new String[] {
               "Kitajski standardni \u010das",
               "CST",
               "Kitajski poletni \u010das",
               "CDT",
               "Kitajski \u010das",
               "CT",
            };
        final String[] Lord_Howe = new String[] {
               "Standardni \u010das otoka Lord Howe",
               "LHST",
               "Poletni \u010das otoka Lord Howe",
               "LHDT",
               "\u010cas otoka Lord Howe",
               "LHT",
            };
        final String[] Arabian = new String[] {
               "Arabski standardni \u010das",
               "AST",
               "Arabski poletni \u010das",
               "ADT",
               "Arabski \u010das",
               "AT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017enoafri\u0161ki \u010das",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarieski \u010das",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Avstralski vzhodni standardni \u010das",
               "AEST",
               "Avstralski vzhodni poletni \u010das",
               "AEDT",
               "Avstralski vzhodni \u010das",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkut\u0161ki standardni \u010das",
               "IST",
               "Irkut\u0161ki poletni \u010das",
               "IST",
               "Irkut\u0161ki \u010das",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsanski standardni \u010das",
               "CST",
               "\u010cojbalsanski poletni \u010das",
               "CST",
               "\u010cojbalsanski \u010das",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u010cilski standardni \u010das",
               "CST",
               "\u010cilski poletni \u010das",
               "CST",
               "\u010cilski \u010das",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zahodni kazahstanski \u010das",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] America_Eastern = new String[] {
               "Vzhodni standardni \u010das",
               "EST",
               "Vzhodni poletni \u010das",
               "EDT",
               "Vzhodni \u010das",
               "ET",
            };
        final String[] Israel = new String[] {
               "Izraelski standardni \u010das",
               "IST",
               "Izraelski poletni \u010das",
               "IDT",
               "Izraelski \u010das",
               "IT",
            };
        final String[] Australia_Western = new String[] {
               "Avstralski zahodni standardni \u010das",
               "AWST",
               "Avstralski zahodni poletni \u010das",
               "AWDT",
               "Avstralski zahodni \u010das",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Avstralski centralni zahodni standardni \u010das",
               "ACWST",
               "Avstralski centralni zahodni poletni \u010das",
               "ACWDT",
               "Avstralski centralni zahodni \u010das",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojar\u0161ki standardni \u010das",
               "KST",
               "Krasnojar\u0161ki poletni \u010das",
               "KST",
               "Krasnojar\u0161ki \u010das",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonezijski vzhodni \u010das",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noron\u0161ki standardni \u010das",
               "FNST",
               "Fernando de Noron\u0161ki poletni \u010das",
               "FNST",
               "Fernando de Noron\u0161ki \u010das",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibir\u0161ki standardni \u010das",
               "NST",
               "Novosibir\u0161ki poletni \u010das",
               "NST",
               "Novosibir\u0161ki \u010das",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Gorski standardni \u010das",
               "MST",
               "Gorski poletni \u010das",
               "MDT",
               "Gorski \u010das",
               "MT",
            };
        final String[] Europe_Central = new String[] {
               "Srednjeevropski standardni \u010das",
               "CEST",
               "Srednjeevropski poletni \u010das",
               "CEST",
               "Srednjeevropski \u010das",
               "CET",
            };
        final String[] India = new String[] {
               "Indijski standardni \u010das",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161ki standardni \u010das",
               "AKST",
               "Alja\u0161ki poletni \u010das",
               "AKDT",
               "Alja\u0161ki \u010das",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "Avstralski centralni standardni \u010das",
               "ACST",
               "Avstralski centralni poletni \u010das",
               "ACDT",
               "Avstralski centralni \u010das",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Azorski standardni \u010das",
               "AST",
               "Azorski poletni \u010das",
               "AST",
               "Azorski \u010das",
               "AT",
            };
        final String[] Europe_Eastern = new String[] {
               "Vzhodnoevropski standardni \u010das",
               "EEST",
               "Vzhodnoevropski poletni \u010das",
               "EEST",
               "Vzhodnoevropski \u010das",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlantski standardni \u010das",
               "AST",
               "Atlantski poletni \u010das",
               "ADT",
               "Atlantski \u010das",
               "AT",
            };
        final String[] Magadan = new String[] {
               "Magadanski standardni \u010das",
               "MST",
               "Magadanski poletni \u010das",
               "MST",
               "Magadanski \u010das",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Samara", Moscow },
            { "Africa/Douala", Africa_Western },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "Europe/Vienna", Europe_Central },
            { "America/St_Vincent", Atlantic },
            { "America/Dawson", America_Pacific },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "America/Danmarkshavn", GMT },
            { "Europe/Dublin", GMT },
            { "America/Regina", America_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Istanbul", Europe_Eastern },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "America/Cayman", America_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Asia/Omsk", Omsk },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Argentina/Tucuman", Argentina },
            { "Europe/Budapest", Europe_Central },
            { "America/Curacao", Atlantic },
            { "Asia/Choibalsan", Choibalsan },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Maseru", Africa_Southern },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Europe/Jersey", GMT },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Toronto", America_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "America/Moncton", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "Africa/Dakar", GMT },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "America/Cuiaba", Amazon },
            { "Asia/Bahrain", Arabian },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Asia/Urumqi", China },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Asia/Irkutsk", Irkutsk },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Juba", Africa_Eastern },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "Asia/Baghdad", Arabian },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "America/Jamaica", America_Eastern },
            { "Africa/Abidjan", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "Africa/Banjul", GMT },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Asia/Seoul", Korea },
            { "America/Jujuy", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Havana", Cuba },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Africa/Conakry", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Africa/Libreville", Africa_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Minsk", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Europe/Bratislava", Europe_Central },
            { "Africa/Bangui", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Europe/Zagreb", Europe_Central },
            { "America/Eirunepe", Amazon },
            { "Antarctica/Palmer", Chile },
            { "Africa/Lubumbashi", Africa_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
