#ifndef _EFL_UI_ITEM_EO_H_
#define _EFL_UI_ITEM_EO_H_

#ifndef _EFL_UI_ITEM_EO_CLASS_TYPE
#define _EFL_UI_ITEM_EO_CLASS_TYPE

typedef Eo Efl_Ui_Item;

#endif

#ifndef _EFL_UI_ITEM_EO_TYPES
#define _EFL_UI_ITEM_EO_TYPES


#endif
/** Item abstract class for pack widget. All item have to be inherited from
 * this class.
 *
 * @ingroup Efl_Ui_Item
 */
#define EFL_UI_ITEM_CLASS efl_ui_item_class_get()

EWAPI const Efl_Class *efl_ui_item_class_get(void);

/** index number of item from their parent object.
 *
 * @ingroup Efl_Ui_Item
 */
EOAPI int efl_ui_item_index_get(const Eo *obj);

/**
 * @brief Select property for item object. Item can be selected by user
 * mouse/key input also
 *
 * @param[in] obj The object.
 * @param[in] select
 *
 * @ingroup Efl_Ui_Item
 */
EOAPI void efl_ui_item_selected_set(Eo *obj, Eina_Bool select);

/** Select property for item object. Item can be selected by user mouse/key
 * input also
 *
 * @ingroup Efl_Ui_Item
 */
EOAPI Eina_Bool efl_ui_item_selected_get(const Eo *obj);

#endif
