#ifndef _EFL_CONTAINER_EO_H_
#define _EFL_CONTAINER_EO_H_

#ifndef _EFL_CONTAINER_EO_CLASS_TYPE
#define _EFL_CONTAINER_EO_CLASS_TYPE

typedef Eo Efl_Container;

#endif

#ifndef _EFL_CONTAINER_EO_TYPES
#define _EFL_CONTAINER_EO_TYPES


#endif
/**
 * @brief Common interface for objects that have multiple contents (sub
 * objects).
 *
 * APIs in this interface deal with containers of multiple sub objects, not
 * with individual parts.
 *
 * @ingroup Efl_Container
 */
#define EFL_CONTAINER_INTERFACE efl_container_interface_get()

EWAPI const Efl_Class *efl_container_interface_get(void);

/**
 * @brief Unswallow an object from this container.
 *
 * @param[in] obj The object.
 * @param[in] content To be removed content
 *
 * @return @c false if @c content was not a child or can not be removed.
 *
 * @ingroup Efl_Container
 */
EOAPI Eina_Bool efl_content_remove(Eo *obj, Efl_Gfx_Entity *content);

/**
 * @brief Begin iterating over this object's contents.
 *
 * @param[in] obj The object.
 *
 * @return Iterator to object content
 *
 * @ingroup Efl_Container
 */
EOAPI Eina_Iterator *efl_content_iterate(Eo *obj) EINA_WARN_UNUSED_RESULT;

/**
 * @brief Returns the number of UI elements packed in this container.
 *
 * @param[in] obj The object.
 *
 * @return Number of packed UI elements
 *
 * @ingroup Efl_Container
 */
EOAPI int efl_content_count(Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_CONTAINER_EVENT_CONTENT_ADDED;

/** Sent after a new item was added.
 * @return Efl_Gfx_Entity *
 *
 * @ingroup Efl_Container
 */
#define EFL_CONTAINER_EVENT_CONTENT_ADDED (&(_EFL_CONTAINER_EVENT_CONTENT_ADDED))

EWAPI extern const Efl_Event_Description _EFL_CONTAINER_EVENT_CONTENT_REMOVED;

/** Sent after an item was removed, before unref.
 * @return Efl_Gfx_Entity *
 *
 * @ingroup Efl_Container
 */
#define EFL_CONTAINER_EVENT_CONTENT_REMOVED (&(_EFL_CONTAINER_EVENT_CONTENT_REMOVED))

#endif
