"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var axios_1 = require("axios");
var open_graph_1 = require("open-graph");
var url_1 = require("url");
var getLogger_1 = require("../logging/getLogger");
var config_1 = require("../settings/config");
var logger = getLogger_1.getLogger('openGraph');
axios_1.default.defaults.adapter = require('axios/lib/adapters/http');
var arrayify = function (value) {
    if (value === void 0) { value = []; }
    return (Array.isArray(value) ? value : [value]);
};
var bufferToBase64 = function (buffer, mimeType) {
    var bufferBase64encoded = Buffer.from(buffer).toString('base64');
    return "data:" + mimeType + ";base64," + bufferBase64encoded;
};
var fetchImageAsBase64 = function (url) { return __awaiter(_this, void 0, void 0, function () {
    var IMAGE_SIZE_LIMIT, axiosConfig, response, contentType, isImageContentType;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                IMAGE_SIZE_LIMIT = 5e6;
                axiosConfig = {
                    headers: {
                        'User-Agent': config_1.USER_AGENT,
                    },
                    maxContentLength: IMAGE_SIZE_LIMIT,
                    method: 'get',
                    responseType: 'arraybuffer',
                    url: url,
                };
                return [4, axios_1.default.request(axiosConfig)];
            case 1:
                response = _a.sent();
                if (response.status !== 200) {
                    throw new Error("Request failed with status code \"" + response.status + "\".");
                }
                contentType = response.headers['content-type'] || '';
                isImageContentType = contentType.match(/.*image\/.*/);
                if (!isImageContentType) {
                    throw new Error("Unhandled format for open graph image ('" + contentType + "')");
                }
                return [2, bufferToBase64(response.data, contentType)];
        }
    });
}); };
var axiosWithContentLimit = function (config, contentLimit) {
    var CancelToken = axios_1.default.CancelToken;
    var cancelSource = CancelToken.source();
    config.responseType = 'stream';
    config.cancelToken = cancelSource.token;
    return new Promise(function (resolve, reject) {
        var partialBody = '';
        return axios_1.default
            .request(config)
            .then(function (response) {
            if (response.status !== 200) {
                return reject("Request failed with status code \"" + response.status + "\".");
            }
            var contentType = response.headers['content-type'] || '';
            var isHtmlContentType = contentType.match(/.*text\/html/);
            if (!isHtmlContentType) {
                reject("Unhandled format for open graph generation ('" + contentType + "')");
            }
            response.data.on('data', function (buffer) {
                var chunk = buffer.toString();
                partialBody += chunk;
                if (chunk.match('</head>') || partialBody.length > contentLimit) {
                    cancelSource.cancel();
                    resolve(partialBody);
                }
            });
            response.data.on('error', reject);
            response.data.on('end', function () { return resolve(partialBody); });
        })
            .catch(function (error) { return (axios_1.default.isCancel(error) ? Promise.resolve('') : Promise.reject(error)); });
    });
};
var fetchOpenGraphData = function (url) { return __awaiter(_this, void 0, void 0, function () {
    var CONTENT_SIZE_LIMIT, parsedUrl, normalizedUrl, axiosConfig, body, _a, head;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                CONTENT_SIZE_LIMIT = 1e6;
                parsedUrl = url_1.parse(url);
                normalizedUrl = parsedUrl.protocol ? parsedUrl : url_1.parse("http://" + url);
                axiosConfig = {
                    headers: {
                        'User-Agent': config_1.USER_AGENT,
                    },
                    method: 'get',
                    url: normalizedUrl.href,
                };
                return [4, axiosWithContentLimit(axiosConfig, CONTENT_SIZE_LIMIT)];
            case 1:
                body = _b.sent();
                _a = __read(body.match(/<head>[\s\S]*?<\/head>/) || [''], 1), head = _a[0];
                if (!head) {
                    throw new Error('No head end tag found in website.');
                }
                return [2, open_graph_1.parse(head)];
        }
    });
}); };
var updateMetaDataWithImage = function (meta, imageData) {
    if (!meta.image) {
        meta.image = {};
    }
    if (imageData && typeof meta.image === 'object' && !Array.isArray(meta.image)) {
        meta.image.data = imageData;
    }
    else {
        delete meta.image;
    }
    return meta;
};
var getOpenGraphData = function (url, callback) {
    return fetchOpenGraphData(url)
        .then(function (meta) {
        if (typeof meta.image === 'object' && !Array.isArray(meta.image) && meta.image.url) {
            var _a = __read(arrayify(meta.image.url), 1), imageUrl = _a[0];
            return fetchImageAsBase64(imageUrl).then(function (uri) { return updateMetaDataWithImage(meta, uri); });
        }
        else {
            return Promise.reject(new Error('OpenGraph metadata contains no image.'));
        }
    })
        .then(function (meta) {
        if (callback) {
            callback(null, meta);
        }
        return meta;
    })
        .catch(function (error) {
        if (callback) {
            callback(error);
        }
        else {
            logger.info(error);
        }
    });
};
exports.getOpenGraphData = getOpenGraphData;
var getOpenGraphDataAsync = function (url) { return __awaiter(_this, void 0, void 0, function () {
    var meta, _a, imageUrl, uri;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0: return [4, fetchOpenGraphData(url)];
            case 1:
                meta = _b.sent();
                if (!(typeof meta.image === 'object' && !Array.isArray(meta.image) && meta.image.url)) return [3, 3];
                _a = __read(arrayify(meta.image.url), 1), imageUrl = _a[0];
                return [4, fetchImageAsBase64(imageUrl)];
            case 2:
                uri = _b.sent();
                return [2, updateMetaDataWithImage(meta, uri)];
            case 3: throw new Error('OpenGraph metadata contains no image.');
        }
    });
}); };
exports.getOpenGraphDataAsync = getOpenGraphDataAsync;
//# sourceMappingURL=openGraph.js.map