# -*- coding: utf-8 -*-

"""
VirtualBox COM/XPCOM constants.

This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
"""

__copyright__ = \
"""
Copyright (C) 2009-2016 Oracle Corporation

This file is part of VirtualBox Open Source Edition (OSE), as
available from http://www.virtualbox.org. This file is free software;
you can redistribute it and/or modify it under the terms of the GNU
General Public License (GPL) as published by the Free Software
Foundation, in version 2 as it comes in the "COPYING" file of the
VirtualBox OSE distribution. VirtualBox OSE is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.

The contents of this file may alternatively be used under the terms
of the Common Development and Distribution License Version 1.0
(CDDL) only, as it comes in the "COPYING.CDDL" file of the
VirtualBox OSE distribution, in which case the provisions of the
CDDL are applicable instead of those of the GPL.

You may elect to license modified versions of this file under the
terms and conditions of either the GPL or the CDDL or both.
"""

__version__ = "$Revision: 106555 $";



class VirtualBoxReflectionInfo:
    """
    Enum constants for the various python styles.
    """

    def __init__(self, fIsSym):
        self.__fIsSym = fIsSym

    __dValues = {
        'SettingsVersion': {
            'Null': 0,
            'v1_0': 1,
            'v1_1': 2,
            'v1_2': 3,
            'v1_3pre': 4,
            'v1_3': 5,
            'v1_4': 6,
            'v1_5': 7,
            'v1_6': 8,
            'v1_7': 9,
            'v1_8': 10,
            'v1_9': 11,
            'v1_10': 12,
            'v1_11': 13,
            'v1_12': 14,
            'v1_13': 15,
            'v1_14': 16,
            'v1_15': 17,
            'v1_16': 18,
            'v1_17': 19,
            'Future': 99999,
        },
        'AccessMode': {
            'ReadOnly': 1,
            'ReadWrite': 2,
        },
        'MachineState': {
            'Null': 0,
            'PoweredOff': 1,
            'Saved': 2,
            'Teleported': 3,
            'Aborted': 4,
            'Running': 5,
            'Paused': 6,
            'Stuck': 7,
            'Teleporting': 8,
            'LiveSnapshotting': 9,
            'Starting': 10,
            'Stopping': 11,
            'Saving': 12,
            'Restoring': 13,
            'TeleportingPausedVM': 14,
            'TeleportingIn': 15,
            'FaultTolerantSyncing': 16,
            'DeletingSnapshotOnline': 17,
            'DeletingSnapshotPaused': 18,
            'OnlineSnapshotting': 19,
            'RestoringSnapshot': 20,
            'DeletingSnapshot': 21,
            'SettingUp': 22,
            'Snapshotting': 23,
            'FirstOnline': 5,
            'LastOnline': 19,
            'FirstTransient': 8,
            'LastTransient': 23,
        },
        'SessionState': {
            'Null': 0,
            'Unlocked': 1,
            'Locked': 2,
            'Spawning': 3,
            'Unlocking': 4,
        },
        'CPUPropertyType': {
            'Null': 0,
            'PAE': 1,
            'LongMode': 2,
            'TripleFaultReset': 3,
            'APIC': 4,
            'X2APIC': 5,
            'IBPBOnVMExit': 6,
            'IBPBOnVMEntry': 7,
            'HWVirt': 8,
            'SpecCtrl': 9,
            'SpecCtrlByHost': 10,
            'L1DFlushOnEMTScheduling': 11,
            'L1DFlushOnVMEntry': 12,
        },
        'HWVirtExPropertyType': {
            'Null': 0,
            'Enabled': 1,
            'VPID': 2,
            'NestedPaging': 3,
            'UnrestrictedExecution': 4,
            'LargePages': 5,
            'Force': 6,
            'UseNativeApi': 7,
        },
        'ParavirtProvider': {
            'None': 0,
            'Default': 1,
            'Legacy': 2,
            'Minimal': 3,
            'HyperV': 4,
            'KVM': 5,
        },
        'FaultToleranceState': {
            'Inactive': 1,
            'Master': 2,
            'Standby': 3,
        },
        'LockType': {
            'Null': 0,
            'Shared': 1,
            'Write': 2,
            'VM': 3,
        },
        'SessionType': {
            'Null': 0,
            'WriteLock': 1,
            'Remote': 2,
            'Shared': 3,
        },
        'DeviceType': {
            'Null': 0,
            'Floppy': 1,
            'DVD': 2,
            'HardDisk': 3,
            'Network': 4,
            'USB': 5,
            'SharedFolder': 6,
            'Graphics3D': 7,
        },
        'DeviceActivity': {
            'Null': 0,
            'Idle': 1,
            'Reading': 2,
            'Writing': 3,
        },
        'ClipboardMode': {
            'Disabled': 0,
            'HostToGuest': 1,
            'GuestToHost': 2,
            'Bidirectional': 3,
        },
        'DnDMode': {
            'Disabled': 0,
            'HostToGuest': 1,
            'GuestToHost': 2,
            'Bidirectional': 3,
        },
        'Scope': {
            'Global': 0,
            'Machine': 1,
            'Session': 2,
        },
        'BIOSBootMenuMode': {
            'Disabled': 0,
            'MenuOnly': 1,
            'MessageAndMenu': 2,
        },
        'APICMode': {
            'Disabled': 0,
            'APIC': 1,
            'X2APIC': 2,
        },
        'ProcessorFeature': {
            'HWVirtEx': 0,
            'PAE': 1,
            'LongMode': 2,
            'NestedPaging': 3,
            'UnrestrictedGuest': 4,
            'NestedHWVirt': 5,
        },
        'FirmwareType': {
            'BIOS': 1,
            'EFI': 2,
            'EFI32': 3,
            'EFI64': 4,
            'EFIDUAL': 5,
        },
        'PointingHIDType': {
            'None': 1,
            'PS2Mouse': 2,
            'USBMouse': 3,
            'USBTablet': 4,
            'ComboMouse': 5,
            'USBMultiTouch': 6,
        },
        'KeyboardHIDType': {
            'None': 1,
            'PS2Keyboard': 2,
            'USBKeyboard': 3,
            'ComboKeyboard': 4,
        },
        'BitmapFormat': {
            'Opaque': 0,
            'BGR': 0x20524742,
            'BGR0': 0x30524742,
            'BGRA': 0x41524742,
            'RGBA': 0x41424752,
            'PNG': 0x20474E50,
            'JPEG': 0x4745504A,
        },
        'DhcpOpt': {
            'SubnetMask': 1,
            'TimeOffset': 2,
            'Router': 3,
            'TimeServer': 4,
            'NameServer': 5,
            'DomainNameServer': 6,
            'LogServer': 7,
            'Cookie': 8,
            'LPRServer': 9,
            'ImpressServer': 10,
            'ResourseLocationServer': 11,
            'HostName': 12,
            'BootFileSize': 13,
            'MeritDumpFile': 14,
            'DomainName': 15,
            'SwapServer': 16,
            'RootPath': 17,
            'ExtensionPath': 18,
            'IPForwardingEnableDisable': 19,
            'NonLocalSourceRoutingEnableDisable': 20,
            'PolicyFilter': 21,
            'MaximumDatagramReassemblySize': 22,
            'DefaultIPTime2Live': 23,
            'PathMTUAgingTimeout': 24,
            'IPLayerParametersPerInterface': 25,
            'InterfaceMTU': 26,
            'AllSubnetsAreLocal': 27,
            'BroadcastAddress': 28,
            'PerformMaskDiscovery': 29,
            'MaskSupplier': 30,
            'PerformRouteDiscovery': 31,
            'RouterSolicitationAddress': 32,
            'StaticRoute': 33,
            'TrailerEncapsulation': 34,
            'ARPCacheTimeout': 35,
            'EthernetEncapsulation': 36,
            'TCPDefaultTTL': 37,
            'TCPKeepAliveInterval': 38,
            'TCPKeepAliveGarbage': 39,
            'NetworkInformationServiceDomain': 40,
            'NetworkInformationServiceServers': 41,
            'NetworkTimeProtocolServers': 42,
            'VendorSpecificInformation': 43,
            'Option_44': 44,
            'Option_45': 45,
            'Option_46': 46,
            'Option_47': 47,
            'Option_48': 48,
            'Option_49': 49,
            'IPAddressLeaseTime': 51,
            'Option_64': 64,
            'Option_65': 65,
            'TFTPServerName': 66,
            'BootfileName': 67,
            'Option_68': 68,
            'Option_69': 69,
            'Option_70': 70,
            'Option_71': 71,
            'Option_72': 72,
            'Option_73': 73,
            'Option_74': 74,
            'Option_75': 75,
            'Option_119': 119,
        },
        'DhcpOptEncoding': {
            'Legacy': 0,
            'Hex': 1,
        },
        'VFSType': {
            'File': 1,
            'Cloud': 2,
            'S3': 3,
            'WebDav': 4,
            'OCI': 5,
        },
        'ImportOptions': {
            'KeepAllMACs': 1,
            'KeepNATMACs': 2,
            'ImportToVDI': 3,
        },
        'ExportOptions': {
            'CreateManifest': 1,
            'ExportDVDImages': 2,
            'StripAllMACs': 3,
            'StripAllNonNATMACs': 4,
        },
        'CertificateVersion': {
            'V1': 1,
            'V2': 2,
            'V3': 3,
            'Unknown': 99,
        },
        'VirtualSystemDescriptionType': {
            'Ignore': 1,
            'OS': 2,
            'Name': 3,
            'Product': 4,
            'Vendor': 5,
            'Version': 6,
            'ProductUrl': 7,
            'VendorUrl': 8,
            'Description': 9,
            'License': 10,
            'Miscellaneous': 11,
            'CPU': 12,
            'Memory': 13,
            'HardDiskControllerIDE': 14,
            'HardDiskControllerSATA': 15,
            'HardDiskControllerSCSI': 16,
            'HardDiskControllerSAS': 17,
            'HardDiskImage': 18,
            'Floppy': 19,
            'CDROM': 20,
            'NetworkAdapter': 21,
            'USBController': 22,
            'SoundCard': 23,
            'SettingsFile': 24,
            'BaseFolder': 25,
            'PrimaryGroup': 26,
            'CloudInstanceShape': 27,
            'CloudDomain': 28,
            'CloudBootDiskSize': 29,
            'CloudBucket': 30,
            'CloudOCIVCN': 31,
            'CloudPublicIP': 32,
            'CloudProfileName': 33,
            'CloudOCISubnet': 34,
            'CloudKeepObject': 35,
            'CloudLaunchInstance': 36,
        },
        'VirtualSystemDescriptionValueType': {
            'Reference': 1,
            'Original': 2,
            'Auto': 3,
            'ExtraConfig': 4,
        },
        'RecordingDestination': {
            'None': 0,
            'File': 1,
        },
        'RecordingFeature': {
            'None': 0,
            'Video': 1,
            'Audio': 2,
        },
        'RecordingAudioCodec': {
            'None': 0,
            'WavPCM': 1,
            'Opus': 2,
        },
        'RecordingVideoCodec': {
            'None': 0,
            'VP8': 1,
            'VP9': 2,
            'AV1': 3,
        },
        'RecordingVideoScalingMethod': {
            'None': 0,
            'NearestNeighbor': 1,
            'Bilinear': 2,
            'Bicubic': 3,
        },
        'RecordingVideoRateControlMode': {
            'CBR': 0,
            'VBR': 1,
        },
        'GraphicsControllerType': {
            'Null': 0,
            'VBoxVGA': 1,
            'VMSVGA': 2,
            'VBoxSVGA': 3,
        },
        'CleanupMode': {
            'UnregisterOnly': 1,
            'DetachAllReturnNone': 2,
            'DetachAllReturnHardDisksOnly': 3,
            'Full': 4,
        },
        'CloneMode': {
            'MachineState': 1,
            'MachineAndChildStates': 2,
            'AllStates': 3,
        },
        'CloneOptions': {
            'Link': 1,
            'KeepAllMACs': 2,
            'KeepNATMACs': 3,
            'KeepDiskNames': 4,
            'KeepHwUUIDs': 5,
        },
        'AutostopType': {
            'Disabled': 1,
            'SaveState': 2,
            'PowerOff': 3,
            'AcpiShutdown': 4,
        },
        'HostNetworkInterfaceMediumType': {
            'Unknown': 0,
            'Ethernet': 1,
            'PPP': 2,
            'SLIP': 3,
        },
        'HostNetworkInterfaceStatus': {
            'Unknown': 0,
            'Up': 1,
            'Down': 2,
        },
        'HostNetworkInterfaceType': {
            'Bridged': 1,
            'HostOnly': 2,
        },
        'ProxyMode': {
            'System': 0,
            'NoProxy': 1,
            'Manual': 2,
        },
        'AdditionsFacilityType': {
            'None': 0,
            'VBoxGuestDriver': 20,
            'AutoLogon': 90,
            'VBoxService': 100,
            'VBoxTrayClient': 101,
            'Seamless': 1000,
            'Graphics': 1100,
            'MonitorAttach': 1101,
            'All': 2147483646,
        },
        'AdditionsFacilityClass': {
            'None': 0,
            'Driver': 10,
            'Service': 30,
            'Program': 50,
            'Feature': 100,
            'ThirdParty': 999,
            'All': 2147483646,
        },
        'AdditionsFacilityStatus': {
            'Inactive': 0,
            'Paused': 1,
            'PreInit': 20,
            'Init': 30,
            'Active': 50,
            'Terminating': 100,
            'Terminated': 101,
            'Failed': 800,
            'Unknown': 999,
        },
        'AdditionsRunLevelType': {
            'None': 0,
            'System': 1,
            'Userland': 2,
            'Desktop': 3,
        },
        'AdditionsUpdateFlag': {
            'None': 0,
            'WaitForUpdateStartOnly': 1,
        },
        'GuestSessionStatus': {
            'Undefined': 0,
            'Starting': 10,
            'Started': 100,
            'Terminating': 480,
            'Terminated': 500,
            'TimedOutKilled': 512,
            'TimedOutAbnormally': 513,
            'Down': 600,
            'Error': 800,
        },
        'GuestSessionWaitForFlag': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'Status': 4,
        },
        'GuestSessionWaitResult': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'Status': 3,
            'Error': 4,
            'Timeout': 5,
            'WaitFlagNotSupported': 6,
        },
        'GuestUserState': {
            'Unknown': 0,
            'LoggedIn': 1,
            'LoggedOut': 2,
            'Locked': 3,
            'Unlocked': 4,
            'Disabled': 5,
            'Idle': 6,
            'InUse': 7,
            'Created': 8,
            'Deleted': 9,
            'SessionChanged': 10,
            'CredentialsChanged': 11,
            'RoleChanged': 12,
            'GroupAdded': 13,
            'GroupRemoved': 14,
            'Elevated': 15,
        },
        'FileSeekOrigin': {
            'Begin': 0,
            'Current': 1,
            'End': 2,
        },
        'ProcessInputFlag': {
            'None': 0,
            'EndOfFile': 1,
        },
        'ProcessOutputFlag': {
            'None': 0,
            'StdErr': 1,
        },
        'ProcessWaitForFlag': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'StdIn': 4,
            'StdOut': 8,
            'StdErr': 16,
        },
        'ProcessWaitResult': {
            'None': 0,
            'Start': 1,
            'Terminate': 2,
            'Status': 3,
            'Error': 4,
            'Timeout': 5,
            'StdIn': 6,
            'StdOut': 7,
            'StdErr': 8,
            'WaitFlagNotSupported': 9,
        },
        'FileCopyFlag': {
            'None': 0,
            'NoReplace': 1,
            'FollowLinks': 2,
            'Update': 4,
        },
        'FsObjMoveFlag': {
            'None': 0,
            'Replace': 1,
            'FollowLinks': 2,
            'AllowDirectoryMoves': 4,
        },
        'DirectoryCreateFlag': {
            'None': 0,
            'Parents': 1,
        },
        'DirectoryCopyFlag': {
            'None': 0,
            'CopyIntoExisting': 1,
        },
        'DirectoryRemoveRecFlag': {
            'None': 0,
            'ContentAndDir': 1,
            'ContentOnly': 2,
        },
        'FsObjRenameFlag': {
            'NoReplace': 0,
            'Replace': 1,
        },
        'ProcessCreateFlag': {
            'None': 0,
            'WaitForProcessStartOnly': 1,
            'IgnoreOrphanedProcesses': 2,
            'Hidden': 4,
            'Profile': 8,
            'WaitForStdOut': 16,
            'WaitForStdErr': 32,
            'ExpandArguments': 64,
            'UnquotedArguments': 128,
        },
        'ProcessPriority': {
            'Invalid': 0,
            'Default': 1,
        },
        'SymlinkType': {
            'Unknown': 0,
            'Directory': 1,
            'File': 2,
        },
        'SymlinkReadFlag': {
            'None': 0,
            'NoSymlinks': 1,
        },
        'ProcessStatus': {
            'Undefined': 0,
            'Starting': 10,
            'Started': 100,
            'Paused': 110,
            'Terminating': 480,
            'TerminatedNormally': 500,
            'TerminatedSignal': 510,
            'TerminatedAbnormally': 511,
            'TimedOutKilled': 512,
            'TimedOutAbnormally': 513,
            'Down': 600,
            'Error': 800,
        },
        'ProcessInputStatus': {
            'Undefined': 0,
            'Broken': 1,
            'Available': 10,
            'Written': 50,
            'Overflow': 100,
        },
        'PathStyle': {
            'DOS': 1,
            'UNIX': 2,
            'Unknown': 8,
        },
        'FileAccessMode': {
            'ReadOnly': 1,
            'WriteOnly': 2,
            'ReadWrite': 3,
            'AppendOnly': 4,
            'AppendRead': 5,
        },
        'FileOpenAction': {
            'OpenExisting': 1,
            'OpenOrCreate': 2,
            'CreateNew': 3,
            'CreateOrReplace': 4,
            'OpenExistingTruncated': 5,
            'AppendOrCreate': 99,
        },
        'FileSharingMode': {
            'Read': 1,
            'Write': 2,
            'ReadWrite': 3,
            'Delete': 4,
            'ReadDelete': 5,
            'WriteDelete': 6,
            'All': 7,
        },
        'FileOpenExFlag': {
            'None': 0,
        },
        'FileStatus': {
            'Undefined': 0,
            'Opening': 10,
            'Open': 100,
            'Closing': 150,
            'Closed': 200,
            'Down': 600,
            'Error': 800,
        },
        'FsObjType': {
            'Unknown': 1,
            'Fifo': 2,
            'DevChar': 3,
            'Directory': 4,
            'DevBlock': 5,
            'File': 6,
            'Symlink': 7,
            'Socket': 8,
            'WhiteOut': 9,
        },
        'DnDAction': {
            'Ignore': 0,
            'Copy': 1,
            'Move': 2,
            'Link': 3,
        },
        'DirectoryOpenFlag': {
            'None': 0,
            'NoSymlinks': 1,
        },
        'MediumState': {
            'NotCreated': 0,
            'Created': 1,
            'LockedRead': 2,
            'LockedWrite': 3,
            'Inaccessible': 4,
            'Creating': 5,
            'Deleting': 6,
        },
        'MediumType': {
            'Normal': 0,
            'Immutable': 1,
            'Writethrough': 2,
            'Shareable': 3,
            'Readonly': 4,
            'MultiAttach': 5,
        },
        'MediumVariant': {
            'Standard': 0,
            'VmdkSplit2G': 0x01,
            'VmdkRawDisk': 0x02,
            'VmdkStreamOptimized': 0x04,
            'VmdkESX': 0x08,
            'VdiZeroExpand': 0x100,
            'Fixed': 0x10000,
            'Diff': 0x20000,
            'Formatted': 0x20000000,
            'NoCreateDir': 0x40000000,
        },
        'DataType': {
            'Int32': 0,
            'Int8': 1,
            'String': 2,
        },
        'DataFlags': {
            'None': 0x00,
            'Mandatory': 0x01,
            'Expert': 0x02,
            'Array': 0x04,
            'FlagMask': 0x07,
        },
        'MediumFormatCapabilities': {
            'Uuid': 0x01,
            'CreateFixed': 0x02,
            'CreateDynamic': 0x04,
            'CreateSplit2G': 0x08,
            'Differencing': 0x10,
            'Asynchronous': 0x20,
            'File': 0x40,
            'Properties': 0x80,
            'TcpNetworking': 0x100,
            'VFS': 0x200,
            'Discard': 0x400,
            'Preferred': 0x800,
            'CapabilityMask': 0xFFF,
        },
        'PartitionTableType': {
            'MBR': 1,
            'GPT': 2,
        },
        'KeyboardLED': {
            'NumLock': 0x01,
            'CapsLock': 0x02,
            'ScrollLock': 0x04,
        },
        'MouseButtonState': {
            'LeftButton': 0x01,
            'RightButton': 0x02,
            'MiddleButton': 0x04,
            'WheelUp': 0x08,
            'WheelDown': 0x10,
            'XButton1': 0x20,
            'XButton2': 0x40,
            'MouseStateMask': 0x7F,
        },
        'TouchContactState': {
            'None': 0x00,
            'InContact': 0x01,
            'InRange': 0x02,
            'ContactStateMask': 0x03,
        },
        'FramebufferCapabilities': {
            'UpdateImage': 0x01,
            'VHWA': 0x02,
            'VisibleRegion': 0x04,
            'RenderCursor': 0x08,
            'MoveCursor': 0x10,
        },
        'GuestMonitorStatus': {
            'Disabled': 0,
            'Enabled': 1,
            'Blank': 2,
        },
        'ScreenLayoutMode': {
            'Apply': 0,
            'Reset': 1,
            'Attach': 2,
        },
        'NetworkAttachmentType': {
            'Null': 0,
            'NAT': 1,
            'Bridged': 2,
            'Internal': 3,
            'HostOnly': 4,
            'Generic': 5,
            'NATNetwork': 6,
        },
        'NetworkAdapterType': {
            'Null': 0,
            'Am79C970A': 1,
            'Am79C973': 2,
            'I82540EM': 3,
            'I82543GC': 4,
            'I82545EM': 5,
            'Virtio': 6,
        },
        'NetworkAdapterPromiscModePolicy': {
            'Deny': 1,
            'AllowNetwork': 2,
            'AllowAll': 3,
        },
        'PortMode': {
            'Disconnected': 0,
            'HostPipe': 1,
            'HostDevice': 2,
            'RawFile': 3,
            'TCP': 4,
        },
        'UartType': {
            'U16450': 0,
            'U16550A': 1,
            'U16750': 2,
        },
        'VMExecutionEngine': {
            'NotSet': 0,
            'RawMode': 1,
            'HwVirt': 2,
            'NativeApi': 3,
        },
        'USBControllerType': {
            'Null': 0,
            'OHCI': 1,
            'EHCI': 2,
            'XHCI': 3,
            'Last': 4,
        },
        'USBConnectionSpeed': {
            'Null': 0,
            'Low': 1,
            'Full': 2,
            'High': 3,
            'Super': 4,
            'SuperPlus': 5,
        },
        'USBDeviceState': {
            'NotSupported': 0,
            'Unavailable': 1,
            'Busy': 2,
            'Available': 3,
            'Held': 4,
            'Captured': 5,
        },
        'USBDeviceFilterAction': {
            'Null': 0,
            'Ignore': 1,
            'Hold': 2,
        },
        'AudioDriverType': {
            'Null': 0,
            'WinMM': 1,
            'OSS': 2,
            'ALSA': 3,
            'DirectSound': 4,
            'CoreAudio': 5,
            'MMPM': 6,
            'Pulse': 7,
            'SolAudio': 8,
        },
        'AudioControllerType': {
            'AC97': 0,
            'SB16': 1,
            'HDA': 2,
        },
        'AudioCodecType': {
            'Null': 0,
            'SB16': 1,
            'STAC9700': 2,
            'AD1980': 3,
            'STAC9221': 4,
        },
        'AuthType': {
            'Null': 0,
            'External': 1,
            'Guest': 2,
        },
        'Reason': {
            'Unspecified': 0,
            'HostSuspend': 1,
            'HostResume': 2,
            'HostBatteryLow': 3,
            'Snapshot': 4,
        },
        'StorageBus': {
            'Null': 0,
            'IDE': 1,
            'SATA': 2,
            'SCSI': 3,
            'Floppy': 4,
            'SAS': 5,
            'USB': 6,
            'PCIe': 7,
        },
        'StorageControllerType': {
            'Null': 0,
            'LsiLogic': 1,
            'BusLogic': 2,
            'IntelAhci': 3,
            'PIIX3': 4,
            'PIIX4': 5,
            'ICH6': 6,
            'I82078': 7,
            'LsiLogicSas': 8,
            'USB': 9,
            'NVMe': 10,
        },
        'ChipsetType': {
            'Null': 0,
            'PIIX3': 1,
            'ICH9': 2,
        },
        'NATAliasMode': {
            'AliasLog': 0x1,
            'AliasProxyOnly': 0x02,
            'AliasUseSamePorts': 0x04,
        },
        'NATProtocol': {
            'UDP': 0,
            'TCP': 1,
        },
        'BandwidthGroupType': {
            'Null': 0,
            'Disk': 1,
            'Network': 2,
        },
        'VBoxEventType': {
            'Invalid': 0,
            'Any': 1,
            'Vetoable': 2,
            'MachineEvent': 3,
            'SnapshotEvent': 4,
            'InputEvent': 5,
            'LastWildcard': 31,
            'OnMachineStateChanged': 32,
            'OnMachineDataChanged': 33,
            'OnExtraDataChanged': 34,
            'OnExtraDataCanChange': 35,
            'OnMediumRegistered': 36,
            'OnMachineRegistered': 37,
            'OnSessionStateChanged': 38,
            'OnSnapshotTaken': 39,
            'OnSnapshotDeleted': 40,
            'OnSnapshotChanged': 41,
            'OnGuestPropertyChanged': 42,
            'OnMousePointerShapeChanged': 43,
            'OnMouseCapabilityChanged': 44,
            'OnKeyboardLedsChanged': 45,
            'OnStateChanged': 46,
            'OnAdditionsStateChanged': 47,
            'OnNetworkAdapterChanged': 48,
            'OnSerialPortChanged': 49,
            'OnParallelPortChanged': 50,
            'OnStorageControllerChanged': 51,
            'OnMediumChanged': 52,
            'OnVRDEServerChanged': 53,
            'OnUSBControllerChanged': 54,
            'OnUSBDeviceStateChanged': 55,
            'OnSharedFolderChanged': 56,
            'OnRuntimeError': 57,
            'OnCanShowWindow': 58,
            'OnShowWindow': 59,
            'OnCPUChanged': 60,
            'OnVRDEServerInfoChanged': 61,
            'OnEventSourceChanged': 62,
            'OnCPUExecutionCapChanged': 63,
            'OnGuestKeyboard': 64,
            'OnGuestMouse': 65,
            'OnNATRedirect': 66,
            'OnHostPCIDevicePlug': 67,
            'OnVBoxSVCAvailabilityChanged': 68,
            'OnBandwidthGroupChanged': 69,
            'OnGuestMonitorChanged': 70,
            'OnStorageDeviceChanged': 71,
            'OnClipboardModeChanged': 72,
            'OnDnDModeChanged': 73,
            'OnNATNetworkChanged': 74,
            'OnNATNetworkStartStop': 75,
            'OnNATNetworkAlter': 76,
            'OnNATNetworkCreationDeletion': 77,
            'OnNATNetworkSetting': 78,
            'OnNATNetworkPortForward': 79,
            'OnGuestSessionStateChanged': 80,
            'OnGuestSessionRegistered': 81,
            'OnGuestProcessRegistered': 82,
            'OnGuestProcessStateChanged': 83,
            'OnGuestProcessInputNotify': 84,
            'OnGuestProcessOutput': 85,
            'OnGuestFileRegistered': 86,
            'OnGuestFileStateChanged': 87,
            'OnGuestFileOffsetChanged': 88,
            'OnGuestFileRead': 89,
            'OnGuestFileWrite': 90,
            'OnRecordingChanged': 91,
            'OnGuestUserStateChanged': 92,
            'OnGuestMultiTouch': 93,
            'OnHostNameResolutionConfigurationChange': 94,
            'OnSnapshotRestored': 95,
            'OnMediumConfigChanged': 96,
            'OnAudioAdapterChanged': 97,
            'OnProgressPercentageChanged': 98,
            'OnProgressTaskCompleted': 99,
            'OnCursorPositionChanged': 100,
            'Last': 101,
        },
        'GuestMouseEventMode': {
            'Relative': 0,
            'Absolute': 1,
        },
        'GuestMonitorChangedEventType': {
            'Enabled': 0,
            'Disabled': 1,
            'NewOrigin': 2,
        },
    }

    __dValuesSym = {
        'SettingsVersion': {
            'Null': 'Null',
            'v1_0': 'v1_0',
            'v1_1': 'v1_1',
            'v1_2': 'v1_2',
            'v1_3pre': 'v1_3pre',
            'v1_3': 'v1_3',
            'v1_4': 'v1_4',
            'v1_5': 'v1_5',
            'v1_6': 'v1_6',
            'v1_7': 'v1_7',
            'v1_8': 'v1_8',
            'v1_9': 'v1_9',
            'v1_10': 'v1_10',
            'v1_11': 'v1_11',
            'v1_12': 'v1_12',
            'v1_13': 'v1_13',
            'v1_14': 'v1_14',
            'v1_15': 'v1_15',
            'v1_16': 'v1_16',
            'v1_17': 'v1_17',
            'Future': 'Future',
        },
        'AccessMode': {
            'ReadOnly': 'ReadOnly',
            'ReadWrite': 'ReadWrite',
        },
        'MachineState': {
            'Null': 'Null',
            'PoweredOff': 'PoweredOff',
            'Saved': 'Saved',
            'Teleported': 'Teleported',
            'Aborted': 'Aborted',
            'Running': 'Running',
            'Paused': 'Paused',
            'Stuck': 'Stuck',
            'Teleporting': 'Teleporting',
            'LiveSnapshotting': 'LiveSnapshotting',
            'Starting': 'Starting',
            'Stopping': 'Stopping',
            'Saving': 'Saving',
            'Restoring': 'Restoring',
            'TeleportingPausedVM': 'TeleportingPausedVM',
            'TeleportingIn': 'TeleportingIn',
            'FaultTolerantSyncing': 'FaultTolerantSyncing',
            'DeletingSnapshotOnline': 'DeletingSnapshotOnline',
            'DeletingSnapshotPaused': 'DeletingSnapshotPaused',
            'OnlineSnapshotting': 'OnlineSnapshotting',
            'RestoringSnapshot': 'RestoringSnapshot',
            'DeletingSnapshot': 'DeletingSnapshot',
            'SettingUp': 'SettingUp',
            'Snapshotting': 'Snapshotting',
            'FirstOnline': 'FirstOnline',
            'LastOnline': 'LastOnline',
            'FirstTransient': 'FirstTransient',
            'LastTransient': 'LastTransient',
        },
        'SessionState': {
            'Null': 'Null',
            'Unlocked': 'Unlocked',
            'Locked': 'Locked',
            'Spawning': 'Spawning',
            'Unlocking': 'Unlocking',
        },
        'CPUPropertyType': {
            'Null': 'Null',
            'PAE': 'PAE',
            'LongMode': 'LongMode',
            'TripleFaultReset': 'TripleFaultReset',
            'APIC': 'APIC',
            'X2APIC': 'X2APIC',
            'IBPBOnVMExit': 'IBPBOnVMExit',
            'IBPBOnVMEntry': 'IBPBOnVMEntry',
            'HWVirt': 'HWVirt',
            'SpecCtrl': 'SpecCtrl',
            'SpecCtrlByHost': 'SpecCtrlByHost',
            'L1DFlushOnEMTScheduling': 'L1DFlushOnEMTScheduling',
            'L1DFlushOnVMEntry': 'L1DFlushOnVMEntry',
        },
        'HWVirtExPropertyType': {
            'Null': 'Null',
            'Enabled': 'Enabled',
            'VPID': 'VPID',
            'NestedPaging': 'NestedPaging',
            'UnrestrictedExecution': 'UnrestrictedExecution',
            'LargePages': 'LargePages',
            'Force': 'Force',
            'UseNativeApi': 'UseNativeApi',
        },
        'ParavirtProvider': {
            'None': 'None',
            'Default': 'Default',
            'Legacy': 'Legacy',
            'Minimal': 'Minimal',
            'HyperV': 'HyperV',
            'KVM': 'KVM',
        },
        'FaultToleranceState': {
            'Inactive': 'Inactive',
            'Master': 'Master',
            'Standby': 'Standby',
        },
        'LockType': {
            'Null': 'Null',
            'Shared': 'Shared',
            'Write': 'Write',
            'VM': 'VM',
        },
        'SessionType': {
            'Null': 'Null',
            'WriteLock': 'WriteLock',
            'Remote': 'Remote',
            'Shared': 'Shared',
        },
        'DeviceType': {
            'Null': 'Null',
            'Floppy': 'Floppy',
            'DVD': 'DVD',
            'HardDisk': 'HardDisk',
            'Network': 'Network',
            'USB': 'USB',
            'SharedFolder': 'SharedFolder',
            'Graphics3D': 'Graphics3D',
        },
        'DeviceActivity': {
            'Null': 'Null',
            'Idle': 'Idle',
            'Reading': 'Reading',
            'Writing': 'Writing',
        },
        'ClipboardMode': {
            'Disabled': 'Disabled',
            'HostToGuest': 'HostToGuest',
            'GuestToHost': 'GuestToHost',
            'Bidirectional': 'Bidirectional',
        },
        'DnDMode': {
            'Disabled': 'Disabled',
            'HostToGuest': 'HostToGuest',
            'GuestToHost': 'GuestToHost',
            'Bidirectional': 'Bidirectional',
        },
        'Scope': {
            'Global': 'Global',
            'Machine': 'Machine',
            'Session': 'Session',
        },
        'BIOSBootMenuMode': {
            'Disabled': 'Disabled',
            'MenuOnly': 'MenuOnly',
            'MessageAndMenu': 'MessageAndMenu',
        },
        'APICMode': {
            'Disabled': 'Disabled',
            'APIC': 'APIC',
            'X2APIC': 'X2APIC',
        },
        'ProcessorFeature': {
            'HWVirtEx': 'HWVirtEx',
            'PAE': 'PAE',
            'LongMode': 'LongMode',
            'NestedPaging': 'NestedPaging',
            'UnrestrictedGuest': 'UnrestrictedGuest',
            'NestedHWVirt': 'NestedHWVirt',
        },
        'FirmwareType': {
            'BIOS': 'BIOS',
            'EFI': 'EFI',
            'EFI32': 'EFI32',
            'EFI64': 'EFI64',
            'EFIDUAL': 'EFIDUAL',
        },
        'PointingHIDType': {
            'None': 'None',
            'PS2Mouse': 'PS2Mouse',
            'USBMouse': 'USBMouse',
            'USBTablet': 'USBTablet',
            'ComboMouse': 'ComboMouse',
            'USBMultiTouch': 'USBMultiTouch',
        },
        'KeyboardHIDType': {
            'None': 'None',
            'PS2Keyboard': 'PS2Keyboard',
            'USBKeyboard': 'USBKeyboard',
            'ComboKeyboard': 'ComboKeyboard',
        },
        'BitmapFormat': {
            'Opaque': 'Opaque',
            'BGR': 'BGR',
            'BGR0': 'BGR0',
            'BGRA': 'BGRA',
            'RGBA': 'RGBA',
            'PNG': 'PNG',
            'JPEG': 'JPEG',
        },
        'DhcpOpt': {
            'SubnetMask': 'SubnetMask',
            'TimeOffset': 'TimeOffset',
            'Router': 'Router',
            'TimeServer': 'TimeServer',
            'NameServer': 'NameServer',
            'DomainNameServer': 'DomainNameServer',
            'LogServer': 'LogServer',
            'Cookie': 'Cookie',
            'LPRServer': 'LPRServer',
            'ImpressServer': 'ImpressServer',
            'ResourseLocationServer': 'ResourseLocationServer',
            'HostName': 'HostName',
            'BootFileSize': 'BootFileSize',
            'MeritDumpFile': 'MeritDumpFile',
            'DomainName': 'DomainName',
            'SwapServer': 'SwapServer',
            'RootPath': 'RootPath',
            'ExtensionPath': 'ExtensionPath',
            'IPForwardingEnableDisable': 'IPForwardingEnableDisable',
            'NonLocalSourceRoutingEnableDisable': 'NonLocalSourceRoutingEnableDisable',
            'PolicyFilter': 'PolicyFilter',
            'MaximumDatagramReassemblySize': 'MaximumDatagramReassemblySize',
            'DefaultIPTime2Live': 'DefaultIPTime2Live',
            'PathMTUAgingTimeout': 'PathMTUAgingTimeout',
            'IPLayerParametersPerInterface': 'IPLayerParametersPerInterface',
            'InterfaceMTU': 'InterfaceMTU',
            'AllSubnetsAreLocal': 'AllSubnetsAreLocal',
            'BroadcastAddress': 'BroadcastAddress',
            'PerformMaskDiscovery': 'PerformMaskDiscovery',
            'MaskSupplier': 'MaskSupplier',
            'PerformRouteDiscovery': 'PerformRouteDiscovery',
            'RouterSolicitationAddress': 'RouterSolicitationAddress',
            'StaticRoute': 'StaticRoute',
            'TrailerEncapsulation': 'TrailerEncapsulation',
            'ARPCacheTimeout': 'ARPCacheTimeout',
            'EthernetEncapsulation': 'EthernetEncapsulation',
            'TCPDefaultTTL': 'TCPDefaultTTL',
            'TCPKeepAliveInterval': 'TCPKeepAliveInterval',
            'TCPKeepAliveGarbage': 'TCPKeepAliveGarbage',
            'NetworkInformationServiceDomain': 'NetworkInformationServiceDomain',
            'NetworkInformationServiceServers': 'NetworkInformationServiceServers',
            'NetworkTimeProtocolServers': 'NetworkTimeProtocolServers',
            'VendorSpecificInformation': 'VendorSpecificInformation',
            'Option_44': 'Option_44',
            'Option_45': 'Option_45',
            'Option_46': 'Option_46',
            'Option_47': 'Option_47',
            'Option_48': 'Option_48',
            'Option_49': 'Option_49',
            'IPAddressLeaseTime': 'IPAddressLeaseTime',
            'Option_64': 'Option_64',
            'Option_65': 'Option_65',
            'TFTPServerName': 'TFTPServerName',
            'BootfileName': 'BootfileName',
            'Option_68': 'Option_68',
            'Option_69': 'Option_69',
            'Option_70': 'Option_70',
            'Option_71': 'Option_71',
            'Option_72': 'Option_72',
            'Option_73': 'Option_73',
            'Option_74': 'Option_74',
            'Option_75': 'Option_75',
            'Option_119': 'Option_119',
        },
        'DhcpOptEncoding': {
            'Legacy': 'Legacy',
            'Hex': 'Hex',
        },
        'VFSType': {
            'File': 'File',
            'Cloud': 'Cloud',
            'S3': 'S3',
            'WebDav': 'WebDav',
            'OCI': 'OCI',
        },
        'ImportOptions': {
            'KeepAllMACs': 'KeepAllMACs',
            'KeepNATMACs': 'KeepNATMACs',
            'ImportToVDI': 'ImportToVDI',
        },
        'ExportOptions': {
            'CreateManifest': 'CreateManifest',
            'ExportDVDImages': 'ExportDVDImages',
            'StripAllMACs': 'StripAllMACs',
            'StripAllNonNATMACs': 'StripAllNonNATMACs',
        },
        'CertificateVersion': {
            'V1': 'V1',
            'V2': 'V2',
            'V3': 'V3',
            'Unknown': 'Unknown',
        },
        'VirtualSystemDescriptionType': {
            'Ignore': 'Ignore',
            'OS': 'OS',
            'Name': 'Name',
            'Product': 'Product',
            'Vendor': 'Vendor',
            'Version': 'Version',
            'ProductUrl': 'ProductUrl',
            'VendorUrl': 'VendorUrl',
            'Description': 'Description',
            'License': 'License',
            'Miscellaneous': 'Miscellaneous',
            'CPU': 'CPU',
            'Memory': 'Memory',
            'HardDiskControllerIDE': 'HardDiskControllerIDE',
            'HardDiskControllerSATA': 'HardDiskControllerSATA',
            'HardDiskControllerSCSI': 'HardDiskControllerSCSI',
            'HardDiskControllerSAS': 'HardDiskControllerSAS',
            'HardDiskImage': 'HardDiskImage',
            'Floppy': 'Floppy',
            'CDROM': 'CDROM',
            'NetworkAdapter': 'NetworkAdapter',
            'USBController': 'USBController',
            'SoundCard': 'SoundCard',
            'SettingsFile': 'SettingsFile',
            'BaseFolder': 'BaseFolder',
            'PrimaryGroup': 'PrimaryGroup',
            'CloudInstanceShape': 'CloudInstanceShape',
            'CloudDomain': 'CloudDomain',
            'CloudBootDiskSize': 'CloudBootDiskSize',
            'CloudBucket': 'CloudBucket',
            'CloudOCIVCN': 'CloudOCIVCN',
            'CloudPublicIP': 'CloudPublicIP',
            'CloudProfileName': 'CloudProfileName',
            'CloudOCISubnet': 'CloudOCISubnet',
            'CloudKeepObject': 'CloudKeepObject',
            'CloudLaunchInstance': 'CloudLaunchInstance',
        },
        'VirtualSystemDescriptionValueType': {
            'Reference': 'Reference',
            'Original': 'Original',
            'Auto': 'Auto',
            'ExtraConfig': 'ExtraConfig',
        },
        'RecordingDestination': {
            'None': 'None',
            'File': 'File',
        },
        'RecordingFeature': {
            'None': 'None',
            'Video': 'Video',
            'Audio': 'Audio',
        },
        'RecordingAudioCodec': {
            'None': 'None',
            'WavPCM': 'WavPCM',
            'Opus': 'Opus',
        },
        'RecordingVideoCodec': {
            'None': 'None',
            'VP8': 'VP8',
            'VP9': 'VP9',
            'AV1': 'AV1',
        },
        'RecordingVideoScalingMethod': {
            'None': 'None',
            'NearestNeighbor': 'NearestNeighbor',
            'Bilinear': 'Bilinear',
            'Bicubic': 'Bicubic',
        },
        'RecordingVideoRateControlMode': {
            'CBR': 'CBR',
            'VBR': 'VBR',
        },
        'GraphicsControllerType': {
            'Null': 'Null',
            'VBoxVGA': 'VBoxVGA',
            'VMSVGA': 'VMSVGA',
            'VBoxSVGA': 'VBoxSVGA',
        },
        'CleanupMode': {
            'UnregisterOnly': 'UnregisterOnly',
            'DetachAllReturnNone': 'DetachAllReturnNone',
            'DetachAllReturnHardDisksOnly': 'DetachAllReturnHardDisksOnly',
            'Full': 'Full',
        },
        'CloneMode': {
            'MachineState': 'MachineState',
            'MachineAndChildStates': 'MachineAndChildStates',
            'AllStates': 'AllStates',
        },
        'CloneOptions': {
            'Link': 'Link',
            'KeepAllMACs': 'KeepAllMACs',
            'KeepNATMACs': 'KeepNATMACs',
            'KeepDiskNames': 'KeepDiskNames',
            'KeepHwUUIDs': 'KeepHwUUIDs',
        },
        'AutostopType': {
            'Disabled': 'Disabled',
            'SaveState': 'SaveState',
            'PowerOff': 'PowerOff',
            'AcpiShutdown': 'AcpiShutdown',
        },
        'HostNetworkInterfaceMediumType': {
            'Unknown': 'Unknown',
            'Ethernet': 'Ethernet',
            'PPP': 'PPP',
            'SLIP': 'SLIP',
        },
        'HostNetworkInterfaceStatus': {
            'Unknown': 'Unknown',
            'Up': 'Up',
            'Down': 'Down',
        },
        'HostNetworkInterfaceType': {
            'Bridged': 'Bridged',
            'HostOnly': 'HostOnly',
        },
        'ProxyMode': {
            'System': 'System',
            'NoProxy': 'NoProxy',
            'Manual': 'Manual',
        },
        'AdditionsFacilityType': {
            'None': 'None',
            'VBoxGuestDriver': 'VBoxGuestDriver',
            'AutoLogon': 'AutoLogon',
            'VBoxService': 'VBoxService',
            'VBoxTrayClient': 'VBoxTrayClient',
            'Seamless': 'Seamless',
            'Graphics': 'Graphics',
            'MonitorAttach': 'MonitorAttach',
            'All': 'All',
        },
        'AdditionsFacilityClass': {
            'None': 'None',
            'Driver': 'Driver',
            'Service': 'Service',
            'Program': 'Program',
            'Feature': 'Feature',
            'ThirdParty': 'ThirdParty',
            'All': 'All',
        },
        'AdditionsFacilityStatus': {
            'Inactive': 'Inactive',
            'Paused': 'Paused',
            'PreInit': 'PreInit',
            'Init': 'Init',
            'Active': 'Active',
            'Terminating': 'Terminating',
            'Terminated': 'Terminated',
            'Failed': 'Failed',
            'Unknown': 'Unknown',
        },
        'AdditionsRunLevelType': {
            'None': 'None',
            'System': 'System',
            'Userland': 'Userland',
            'Desktop': 'Desktop',
        },
        'AdditionsUpdateFlag': {
            'None': 'None',
            'WaitForUpdateStartOnly': 'WaitForUpdateStartOnly',
        },
        'GuestSessionStatus': {
            'Undefined': 'Undefined',
            'Starting': 'Starting',
            'Started': 'Started',
            'Terminating': 'Terminating',
            'Terminated': 'Terminated',
            'TimedOutKilled': 'TimedOutKilled',
            'TimedOutAbnormally': 'TimedOutAbnormally',
            'Down': 'Down',
            'Error': 'Error',
        },
        'GuestSessionWaitForFlag': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'Status': 'Status',
        },
        'GuestSessionWaitResult': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'Status': 'Status',
            'Error': 'Error',
            'Timeout': 'Timeout',
            'WaitFlagNotSupported': 'WaitFlagNotSupported',
        },
        'GuestUserState': {
            'Unknown': 'Unknown',
            'LoggedIn': 'LoggedIn',
            'LoggedOut': 'LoggedOut',
            'Locked': 'Locked',
            'Unlocked': 'Unlocked',
            'Disabled': 'Disabled',
            'Idle': 'Idle',
            'InUse': 'InUse',
            'Created': 'Created',
            'Deleted': 'Deleted',
            'SessionChanged': 'SessionChanged',
            'CredentialsChanged': 'CredentialsChanged',
            'RoleChanged': 'RoleChanged',
            'GroupAdded': 'GroupAdded',
            'GroupRemoved': 'GroupRemoved',
            'Elevated': 'Elevated',
        },
        'FileSeekOrigin': {
            'Begin': 'Begin',
            'Current': 'Current',
            'End': 'End',
        },
        'ProcessInputFlag': {
            'None': 'None',
            'EndOfFile': 'EndOfFile',
        },
        'ProcessOutputFlag': {
            'None': 'None',
            'StdErr': 'StdErr',
        },
        'ProcessWaitForFlag': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'StdIn': 'StdIn',
            'StdOut': 'StdOut',
            'StdErr': 'StdErr',
        },
        'ProcessWaitResult': {
            'None': 'None',
            'Start': 'Start',
            'Terminate': 'Terminate',
            'Status': 'Status',
            'Error': 'Error',
            'Timeout': 'Timeout',
            'StdIn': 'StdIn',
            'StdOut': 'StdOut',
            'StdErr': 'StdErr',
            'WaitFlagNotSupported': 'WaitFlagNotSupported',
        },
        'FileCopyFlag': {
            'None': 'None',
            'NoReplace': 'NoReplace',
            'FollowLinks': 'FollowLinks',
            'Update': 'Update',
        },
        'FsObjMoveFlag': {
            'None': 'None',
            'Replace': 'Replace',
            'FollowLinks': 'FollowLinks',
            'AllowDirectoryMoves': 'AllowDirectoryMoves',
        },
        'DirectoryCreateFlag': {
            'None': 'None',
            'Parents': 'Parents',
        },
        'DirectoryCopyFlag': {
            'None': 'None',
            'CopyIntoExisting': 'CopyIntoExisting',
        },
        'DirectoryRemoveRecFlag': {
            'None': 'None',
            'ContentAndDir': 'ContentAndDir',
            'ContentOnly': 'ContentOnly',
        },
        'FsObjRenameFlag': {
            'NoReplace': 'NoReplace',
            'Replace': 'Replace',
        },
        'ProcessCreateFlag': {
            'None': 'None',
            'WaitForProcessStartOnly': 'WaitForProcessStartOnly',
            'IgnoreOrphanedProcesses': 'IgnoreOrphanedProcesses',
            'Hidden': 'Hidden',
            'Profile': 'Profile',
            'WaitForStdOut': 'WaitForStdOut',
            'WaitForStdErr': 'WaitForStdErr',
            'ExpandArguments': 'ExpandArguments',
            'UnquotedArguments': 'UnquotedArguments',
        },
        'ProcessPriority': {
            'Invalid': 'Invalid',
            'Default': 'Default',
        },
        'SymlinkType': {
            'Unknown': 'Unknown',
            'Directory': 'Directory',
            'File': 'File',
        },
        'SymlinkReadFlag': {
            'None': 'None',
            'NoSymlinks': 'NoSymlinks',
        },
        'ProcessStatus': {
            'Undefined': 'Undefined',
            'Starting': 'Starting',
            'Started': 'Started',
            'Paused': 'Paused',
            'Terminating': 'Terminating',
            'TerminatedNormally': 'TerminatedNormally',
            'TerminatedSignal': 'TerminatedSignal',
            'TerminatedAbnormally': 'TerminatedAbnormally',
            'TimedOutKilled': 'TimedOutKilled',
            'TimedOutAbnormally': 'TimedOutAbnormally',
            'Down': 'Down',
            'Error': 'Error',
        },
        'ProcessInputStatus': {
            'Undefined': 'Undefined',
            'Broken': 'Broken',
            'Available': 'Available',
            'Written': 'Written',
            'Overflow': 'Overflow',
        },
        'PathStyle': {
            'DOS': 'DOS',
            'UNIX': 'UNIX',
            'Unknown': 'Unknown',
        },
        'FileAccessMode': {
            'ReadOnly': 'ReadOnly',
            'WriteOnly': 'WriteOnly',
            'ReadWrite': 'ReadWrite',
            'AppendOnly': 'AppendOnly',
            'AppendRead': 'AppendRead',
        },
        'FileOpenAction': {
            'OpenExisting': 'OpenExisting',
            'OpenOrCreate': 'OpenOrCreate',
            'CreateNew': 'CreateNew',
            'CreateOrReplace': 'CreateOrReplace',
            'OpenExistingTruncated': 'OpenExistingTruncated',
            'AppendOrCreate': 'AppendOrCreate',
        },
        'FileSharingMode': {
            'Read': 'Read',
            'Write': 'Write',
            'ReadWrite': 'ReadWrite',
            'Delete': 'Delete',
            'ReadDelete': 'ReadDelete',
            'WriteDelete': 'WriteDelete',
            'All': 'All',
        },
        'FileOpenExFlag': {
            'None': 'None',
        },
        'FileStatus': {
            'Undefined': 'Undefined',
            'Opening': 'Opening',
            'Open': 'Open',
            'Closing': 'Closing',
            'Closed': 'Closed',
            'Down': 'Down',
            'Error': 'Error',
        },
        'FsObjType': {
            'Unknown': 'Unknown',
            'Fifo': 'Fifo',
            'DevChar': 'DevChar',
            'Directory': 'Directory',
            'DevBlock': 'DevBlock',
            'File': 'File',
            'Symlink': 'Symlink',
            'Socket': 'Socket',
            'WhiteOut': 'WhiteOut',
        },
        'DnDAction': {
            'Ignore': 'Ignore',
            'Copy': 'Copy',
            'Move': 'Move',
            'Link': 'Link',
        },
        'DirectoryOpenFlag': {
            'None': 'None',
            'NoSymlinks': 'NoSymlinks',
        },
        'MediumState': {
            'NotCreated': 'NotCreated',
            'Created': 'Created',
            'LockedRead': 'LockedRead',
            'LockedWrite': 'LockedWrite',
            'Inaccessible': 'Inaccessible',
            'Creating': 'Creating',
            'Deleting': 'Deleting',
        },
        'MediumType': {
            'Normal': 'Normal',
            'Immutable': 'Immutable',
            'Writethrough': 'Writethrough',
            'Shareable': 'Shareable',
            'Readonly': 'Readonly',
            'MultiAttach': 'MultiAttach',
        },
        'MediumVariant': {
            'Standard': 'Standard',
            'VmdkSplit2G': 'VmdkSplit2G',
            'VmdkRawDisk': 'VmdkRawDisk',
            'VmdkStreamOptimized': 'VmdkStreamOptimized',
            'VmdkESX': 'VmdkESX',
            'VdiZeroExpand': 'VdiZeroExpand',
            'Fixed': 'Fixed',
            'Diff': 'Diff',
            'Formatted': 'Formatted',
            'NoCreateDir': 'NoCreateDir',
        },
        'DataType': {
            'Int32': 'Int32',
            'Int8': 'Int8',
            'String': 'String',
        },
        'DataFlags': {
            'None': 'None',
            'Mandatory': 'Mandatory',
            'Expert': 'Expert',
            'Array': 'Array',
            'FlagMask': 'FlagMask',
        },
        'MediumFormatCapabilities': {
            'Uuid': 'Uuid',
            'CreateFixed': 'CreateFixed',
            'CreateDynamic': 'CreateDynamic',
            'CreateSplit2G': 'CreateSplit2G',
            'Differencing': 'Differencing',
            'Asynchronous': 'Asynchronous',
            'File': 'File',
            'Properties': 'Properties',
            'TcpNetworking': 'TcpNetworking',
            'VFS': 'VFS',
            'Discard': 'Discard',
            'Preferred': 'Preferred',
            'CapabilityMask': 'CapabilityMask',
        },
        'PartitionTableType': {
            'MBR': 'MBR',
            'GPT': 'GPT',
        },
        'KeyboardLED': {
            'NumLock': 'NumLock',
            'CapsLock': 'CapsLock',
            'ScrollLock': 'ScrollLock',
        },
        'MouseButtonState': {
            'LeftButton': 'LeftButton',
            'RightButton': 'RightButton',
            'MiddleButton': 'MiddleButton',
            'WheelUp': 'WheelUp',
            'WheelDown': 'WheelDown',
            'XButton1': 'XButton1',
            'XButton2': 'XButton2',
            'MouseStateMask': 'MouseStateMask',
        },
        'TouchContactState': {
            'None': 'None',
            'InContact': 'InContact',
            'InRange': 'InRange',
            'ContactStateMask': 'ContactStateMask',
        },
        'FramebufferCapabilities': {
            'UpdateImage': 'UpdateImage',
            'VHWA': 'VHWA',
            'VisibleRegion': 'VisibleRegion',
            'RenderCursor': 'RenderCursor',
            'MoveCursor': 'MoveCursor',
        },
        'GuestMonitorStatus': {
            'Disabled': 'Disabled',
            'Enabled': 'Enabled',
            'Blank': 'Blank',
        },
        'ScreenLayoutMode': {
            'Apply': 'Apply',
            'Reset': 'Reset',
            'Attach': 'Attach',
        },
        'NetworkAttachmentType': {
            'Null': 'Null',
            'NAT': 'NAT',
            'Bridged': 'Bridged',
            'Internal': 'Internal',
            'HostOnly': 'HostOnly',
            'Generic': 'Generic',
            'NATNetwork': 'NATNetwork',
        },
        'NetworkAdapterType': {
            'Null': 'Null',
            'Am79C970A': 'Am79C970A',
            'Am79C973': 'Am79C973',
            'I82540EM': 'I82540EM',
            'I82543GC': 'I82543GC',
            'I82545EM': 'I82545EM',
            'Virtio': 'Virtio',
        },
        'NetworkAdapterPromiscModePolicy': {
            'Deny': 'Deny',
            'AllowNetwork': 'AllowNetwork',
            'AllowAll': 'AllowAll',
        },
        'PortMode': {
            'Disconnected': 'Disconnected',
            'HostPipe': 'HostPipe',
            'HostDevice': 'HostDevice',
            'RawFile': 'RawFile',
            'TCP': 'TCP',
        },
        'UartType': {
            'U16450': 'U16450',
            'U16550A': 'U16550A',
            'U16750': 'U16750',
        },
        'VMExecutionEngine': {
            'NotSet': 'NotSet',
            'RawMode': 'RawMode',
            'HwVirt': 'HwVirt',
            'NativeApi': 'NativeApi',
        },
        'USBControllerType': {
            'Null': 'Null',
            'OHCI': 'OHCI',
            'EHCI': 'EHCI',
            'XHCI': 'XHCI',
            'Last': 'Last',
        },
        'USBConnectionSpeed': {
            'Null': 'Null',
            'Low': 'Low',
            'Full': 'Full',
            'High': 'High',
            'Super': 'Super',
            'SuperPlus': 'SuperPlus',
        },
        'USBDeviceState': {
            'NotSupported': 'NotSupported',
            'Unavailable': 'Unavailable',
            'Busy': 'Busy',
            'Available': 'Available',
            'Held': 'Held',
            'Captured': 'Captured',
        },
        'USBDeviceFilterAction': {
            'Null': 'Null',
            'Ignore': 'Ignore',
            'Hold': 'Hold',
        },
        'AudioDriverType': {
            'Null': 'Null',
            'WinMM': 'WinMM',
            'OSS': 'OSS',
            'ALSA': 'ALSA',
            'DirectSound': 'DirectSound',
            'CoreAudio': 'CoreAudio',
            'MMPM': 'MMPM',
            'Pulse': 'Pulse',
            'SolAudio': 'SolAudio',
        },
        'AudioControllerType': {
            'AC97': 'AC97',
            'SB16': 'SB16',
            'HDA': 'HDA',
        },
        'AudioCodecType': {
            'Null': 'Null',
            'SB16': 'SB16',
            'STAC9700': 'STAC9700',
            'AD1980': 'AD1980',
            'STAC9221': 'STAC9221',
        },
        'AuthType': {
            'Null': 'Null',
            'External': 'External',
            'Guest': 'Guest',
        },
        'Reason': {
            'Unspecified': 'Unspecified',
            'HostSuspend': 'HostSuspend',
            'HostResume': 'HostResume',
            'HostBatteryLow': 'HostBatteryLow',
            'Snapshot': 'Snapshot',
        },
        'StorageBus': {
            'Null': 'Null',
            'IDE': 'IDE',
            'SATA': 'SATA',
            'SCSI': 'SCSI',
            'Floppy': 'Floppy',
            'SAS': 'SAS',
            'USB': 'USB',
            'PCIe': 'PCIe',
        },
        'StorageControllerType': {
            'Null': 'Null',
            'LsiLogic': 'LsiLogic',
            'BusLogic': 'BusLogic',
            'IntelAhci': 'IntelAhci',
            'PIIX3': 'PIIX3',
            'PIIX4': 'PIIX4',
            'ICH6': 'ICH6',
            'I82078': 'I82078',
            'LsiLogicSas': 'LsiLogicSas',
            'USB': 'USB',
            'NVMe': 'NVMe',
        },
        'ChipsetType': {
            'Null': 'Null',
            'PIIX3': 'PIIX3',
            'ICH9': 'ICH9',
        },
        'NATAliasMode': {
            'AliasLog': 'AliasLog',
            'AliasProxyOnly': 'AliasProxyOnly',
            'AliasUseSamePorts': 'AliasUseSamePorts',
        },
        'NATProtocol': {
            'UDP': 'UDP',
            'TCP': 'TCP',
        },
        'BandwidthGroupType': {
            'Null': 'Null',
            'Disk': 'Disk',
            'Network': 'Network',
        },
        'VBoxEventType': {
            'Invalid': 'Invalid',
            'Any': 'Any',
            'Vetoable': 'Vetoable',
            'MachineEvent': 'MachineEvent',
            'SnapshotEvent': 'SnapshotEvent',
            'InputEvent': 'InputEvent',
            'LastWildcard': 'LastWildcard',
            'OnMachineStateChanged': 'OnMachineStateChanged',
            'OnMachineDataChanged': 'OnMachineDataChanged',
            'OnExtraDataChanged': 'OnExtraDataChanged',
            'OnExtraDataCanChange': 'OnExtraDataCanChange',
            'OnMediumRegistered': 'OnMediumRegistered',
            'OnMachineRegistered': 'OnMachineRegistered',
            'OnSessionStateChanged': 'OnSessionStateChanged',
            'OnSnapshotTaken': 'OnSnapshotTaken',
            'OnSnapshotDeleted': 'OnSnapshotDeleted',
            'OnSnapshotChanged': 'OnSnapshotChanged',
            'OnGuestPropertyChanged': 'OnGuestPropertyChanged',
            'OnMousePointerShapeChanged': 'OnMousePointerShapeChanged',
            'OnMouseCapabilityChanged': 'OnMouseCapabilityChanged',
            'OnKeyboardLedsChanged': 'OnKeyboardLedsChanged',
            'OnStateChanged': 'OnStateChanged',
            'OnAdditionsStateChanged': 'OnAdditionsStateChanged',
            'OnNetworkAdapterChanged': 'OnNetworkAdapterChanged',
            'OnSerialPortChanged': 'OnSerialPortChanged',
            'OnParallelPortChanged': 'OnParallelPortChanged',
            'OnStorageControllerChanged': 'OnStorageControllerChanged',
            'OnMediumChanged': 'OnMediumChanged',
            'OnVRDEServerChanged': 'OnVRDEServerChanged',
            'OnUSBControllerChanged': 'OnUSBControllerChanged',
            'OnUSBDeviceStateChanged': 'OnUSBDeviceStateChanged',
            'OnSharedFolderChanged': 'OnSharedFolderChanged',
            'OnRuntimeError': 'OnRuntimeError',
            'OnCanShowWindow': 'OnCanShowWindow',
            'OnShowWindow': 'OnShowWindow',
            'OnCPUChanged': 'OnCPUChanged',
            'OnVRDEServerInfoChanged': 'OnVRDEServerInfoChanged',
            'OnEventSourceChanged': 'OnEventSourceChanged',
            'OnCPUExecutionCapChanged': 'OnCPUExecutionCapChanged',
            'OnGuestKeyboard': 'OnGuestKeyboard',
            'OnGuestMouse': 'OnGuestMouse',
            'OnNATRedirect': 'OnNATRedirect',
            'OnHostPCIDevicePlug': 'OnHostPCIDevicePlug',
            'OnVBoxSVCAvailabilityChanged': 'OnVBoxSVCAvailabilityChanged',
            'OnBandwidthGroupChanged': 'OnBandwidthGroupChanged',
            'OnGuestMonitorChanged': 'OnGuestMonitorChanged',
            'OnStorageDeviceChanged': 'OnStorageDeviceChanged',
            'OnClipboardModeChanged': 'OnClipboardModeChanged',
            'OnDnDModeChanged': 'OnDnDModeChanged',
            'OnNATNetworkChanged': 'OnNATNetworkChanged',
            'OnNATNetworkStartStop': 'OnNATNetworkStartStop',
            'OnNATNetworkAlter': 'OnNATNetworkAlter',
            'OnNATNetworkCreationDeletion': 'OnNATNetworkCreationDeletion',
            'OnNATNetworkSetting': 'OnNATNetworkSetting',
            'OnNATNetworkPortForward': 'OnNATNetworkPortForward',
            'OnGuestSessionStateChanged': 'OnGuestSessionStateChanged',
            'OnGuestSessionRegistered': 'OnGuestSessionRegistered',
            'OnGuestProcessRegistered': 'OnGuestProcessRegistered',
            'OnGuestProcessStateChanged': 'OnGuestProcessStateChanged',
            'OnGuestProcessInputNotify': 'OnGuestProcessInputNotify',
            'OnGuestProcessOutput': 'OnGuestProcessOutput',
            'OnGuestFileRegistered': 'OnGuestFileRegistered',
            'OnGuestFileStateChanged': 'OnGuestFileStateChanged',
            'OnGuestFileOffsetChanged': 'OnGuestFileOffsetChanged',
            'OnGuestFileRead': 'OnGuestFileRead',
            'OnGuestFileWrite': 'OnGuestFileWrite',
            'OnRecordingChanged': 'OnRecordingChanged',
            'OnGuestUserStateChanged': 'OnGuestUserStateChanged',
            'OnGuestMultiTouch': 'OnGuestMultiTouch',
            'OnHostNameResolutionConfigurationChange': 'OnHostNameResolutionConfigurationChange',
            'OnSnapshotRestored': 'OnSnapshotRestored',
            'OnMediumConfigChanged': 'OnMediumConfigChanged',
            'OnAudioAdapterChanged': 'OnAudioAdapterChanged',
            'OnProgressPercentageChanged': 'OnProgressPercentageChanged',
            'OnProgressTaskCompleted': 'OnProgressTaskCompleted',
            'OnCursorPositionChanged': 'OnCursorPositionChanged',
            'Last': 'Last',
        },
        'GuestMouseEventMode': {
            'Relative': 'Relative',
            'Absolute': 'Absolute',
        },
        'GuestMonitorChangedEventType': {
            'Enabled': 'Enabled',
            'Disabled': 'Disabled',
            'NewOrigin': 'NewOrigin',
        },
    }

    __dValuesFlat = {
        'SettingsVersion_Null': 0,
        'SettingsVersion_v1_0': 1,
        'SettingsVersion_v1_1': 2,
        'SettingsVersion_v1_2': 3,
        'SettingsVersion_v1_3pre': 4,
        'SettingsVersion_v1_3': 5,
        'SettingsVersion_v1_4': 6,
        'SettingsVersion_v1_5': 7,
        'SettingsVersion_v1_6': 8,
        'SettingsVersion_v1_7': 9,
        'SettingsVersion_v1_8': 10,
        'SettingsVersion_v1_9': 11,
        'SettingsVersion_v1_10': 12,
        'SettingsVersion_v1_11': 13,
        'SettingsVersion_v1_12': 14,
        'SettingsVersion_v1_13': 15,
        'SettingsVersion_v1_14': 16,
        'SettingsVersion_v1_15': 17,
        'SettingsVersion_v1_16': 18,
        'SettingsVersion_v1_17': 19,
        'SettingsVersion_Future': 99999,
        'AccessMode_ReadOnly': 1,
        'AccessMode_ReadWrite': 2,
        'MachineState_Null': 0,
        'MachineState_PoweredOff': 1,
        'MachineState_Saved': 2,
        'MachineState_Teleported': 3,
        'MachineState_Aborted': 4,
        'MachineState_Running': 5,
        'MachineState_Paused': 6,
        'MachineState_Stuck': 7,
        'MachineState_Teleporting': 8,
        'MachineState_LiveSnapshotting': 9,
        'MachineState_Starting': 10,
        'MachineState_Stopping': 11,
        'MachineState_Saving': 12,
        'MachineState_Restoring': 13,
        'MachineState_TeleportingPausedVM': 14,
        'MachineState_TeleportingIn': 15,
        'MachineState_FaultTolerantSyncing': 16,
        'MachineState_DeletingSnapshotOnline': 17,
        'MachineState_DeletingSnapshotPaused': 18,
        'MachineState_OnlineSnapshotting': 19,
        'MachineState_RestoringSnapshot': 20,
        'MachineState_DeletingSnapshot': 21,
        'MachineState_SettingUp': 22,
        'MachineState_Snapshotting': 23,
        'MachineState_FirstOnline': 5,
        'MachineState_LastOnline': 19,
        'MachineState_FirstTransient': 8,
        'MachineState_LastTransient': 23,
        'SessionState_Null': 0,
        'SessionState_Unlocked': 1,
        'SessionState_Locked': 2,
        'SessionState_Spawning': 3,
        'SessionState_Unlocking': 4,
        'CPUPropertyType_Null': 0,
        'CPUPropertyType_PAE': 1,
        'CPUPropertyType_LongMode': 2,
        'CPUPropertyType_TripleFaultReset': 3,
        'CPUPropertyType_APIC': 4,
        'CPUPropertyType_X2APIC': 5,
        'CPUPropertyType_IBPBOnVMExit': 6,
        'CPUPropertyType_IBPBOnVMEntry': 7,
        'CPUPropertyType_HWVirt': 8,
        'CPUPropertyType_SpecCtrl': 9,
        'CPUPropertyType_SpecCtrlByHost': 10,
        'CPUPropertyType_L1DFlushOnEMTScheduling': 11,
        'CPUPropertyType_L1DFlushOnVMEntry': 12,
        'HWVirtExPropertyType_Null': 0,
        'HWVirtExPropertyType_Enabled': 1,
        'HWVirtExPropertyType_VPID': 2,
        'HWVirtExPropertyType_NestedPaging': 3,
        'HWVirtExPropertyType_UnrestrictedExecution': 4,
        'HWVirtExPropertyType_LargePages': 5,
        'HWVirtExPropertyType_Force': 6,
        'HWVirtExPropertyType_UseNativeApi': 7,
        'ParavirtProvider_None': 0,
        'ParavirtProvider_Default': 1,
        'ParavirtProvider_Legacy': 2,
        'ParavirtProvider_Minimal': 3,
        'ParavirtProvider_HyperV': 4,
        'ParavirtProvider_KVM': 5,
        'FaultToleranceState_Inactive': 1,
        'FaultToleranceState_Master': 2,
        'FaultToleranceState_Standby': 3,
        'LockType_Null': 0,
        'LockType_Shared': 1,
        'LockType_Write': 2,
        'LockType_VM': 3,
        'SessionType_Null': 0,
        'SessionType_WriteLock': 1,
        'SessionType_Remote': 2,
        'SessionType_Shared': 3,
        'DeviceType_Null': 0,
        'DeviceType_Floppy': 1,
        'DeviceType_DVD': 2,
        'DeviceType_HardDisk': 3,
        'DeviceType_Network': 4,
        'DeviceType_USB': 5,
        'DeviceType_SharedFolder': 6,
        'DeviceType_Graphics3D': 7,
        'DeviceActivity_Null': 0,
        'DeviceActivity_Idle': 1,
        'DeviceActivity_Reading': 2,
        'DeviceActivity_Writing': 3,
        'ClipboardMode_Disabled': 0,
        'ClipboardMode_HostToGuest': 1,
        'ClipboardMode_GuestToHost': 2,
        'ClipboardMode_Bidirectional': 3,
        'DnDMode_Disabled': 0,
        'DnDMode_HostToGuest': 1,
        'DnDMode_GuestToHost': 2,
        'DnDMode_Bidirectional': 3,
        'Scope_Global': 0,
        'Scope_Machine': 1,
        'Scope_Session': 2,
        'BIOSBootMenuMode_Disabled': 0,
        'BIOSBootMenuMode_MenuOnly': 1,
        'BIOSBootMenuMode_MessageAndMenu': 2,
        'APICMode_Disabled': 0,
        'APICMode_APIC': 1,
        'APICMode_X2APIC': 2,
        'ProcessorFeature_HWVirtEx': 0,
        'ProcessorFeature_PAE': 1,
        'ProcessorFeature_LongMode': 2,
        'ProcessorFeature_NestedPaging': 3,
        'ProcessorFeature_UnrestrictedGuest': 4,
        'ProcessorFeature_NestedHWVirt': 5,
        'FirmwareType_BIOS': 1,
        'FirmwareType_EFI': 2,
        'FirmwareType_EFI32': 3,
        'FirmwareType_EFI64': 4,
        'FirmwareType_EFIDUAL': 5,
        'PointingHIDType_None': 1,
        'PointingHIDType_PS2Mouse': 2,
        'PointingHIDType_USBMouse': 3,
        'PointingHIDType_USBTablet': 4,
        'PointingHIDType_ComboMouse': 5,
        'PointingHIDType_USBMultiTouch': 6,
        'KeyboardHIDType_None': 1,
        'KeyboardHIDType_PS2Keyboard': 2,
        'KeyboardHIDType_USBKeyboard': 3,
        'KeyboardHIDType_ComboKeyboard': 4,
        'BitmapFormat_Opaque': 0,
        'BitmapFormat_BGR': 0x20524742,
        'BitmapFormat_BGR0': 0x30524742,
        'BitmapFormat_BGRA': 0x41524742,
        'BitmapFormat_RGBA': 0x41424752,
        'BitmapFormat_PNG': 0x20474E50,
        'BitmapFormat_JPEG': 0x4745504A,
        'DhcpOpt_SubnetMask': 1,
        'DhcpOpt_TimeOffset': 2,
        'DhcpOpt_Router': 3,
        'DhcpOpt_TimeServer': 4,
        'DhcpOpt_NameServer': 5,
        'DhcpOpt_DomainNameServer': 6,
        'DhcpOpt_LogServer': 7,
        'DhcpOpt_Cookie': 8,
        'DhcpOpt_LPRServer': 9,
        'DhcpOpt_ImpressServer': 10,
        'DhcpOpt_ResourseLocationServer': 11,
        'DhcpOpt_HostName': 12,
        'DhcpOpt_BootFileSize': 13,
        'DhcpOpt_MeritDumpFile': 14,
        'DhcpOpt_DomainName': 15,
        'DhcpOpt_SwapServer': 16,
        'DhcpOpt_RootPath': 17,
        'DhcpOpt_ExtensionPath': 18,
        'DhcpOpt_IPForwardingEnableDisable': 19,
        'DhcpOpt_NonLocalSourceRoutingEnableDisable': 20,
        'DhcpOpt_PolicyFilter': 21,
        'DhcpOpt_MaximumDatagramReassemblySize': 22,
        'DhcpOpt_DefaultIPTime2Live': 23,
        'DhcpOpt_PathMTUAgingTimeout': 24,
        'DhcpOpt_IPLayerParametersPerInterface': 25,
        'DhcpOpt_InterfaceMTU': 26,
        'DhcpOpt_AllSubnetsAreLocal': 27,
        'DhcpOpt_BroadcastAddress': 28,
        'DhcpOpt_PerformMaskDiscovery': 29,
        'DhcpOpt_MaskSupplier': 30,
        'DhcpOpt_PerformRouteDiscovery': 31,
        'DhcpOpt_RouterSolicitationAddress': 32,
        'DhcpOpt_StaticRoute': 33,
        'DhcpOpt_TrailerEncapsulation': 34,
        'DhcpOpt_ARPCacheTimeout': 35,
        'DhcpOpt_EthernetEncapsulation': 36,
        'DhcpOpt_TCPDefaultTTL': 37,
        'DhcpOpt_TCPKeepAliveInterval': 38,
        'DhcpOpt_TCPKeepAliveGarbage': 39,
        'DhcpOpt_NetworkInformationServiceDomain': 40,
        'DhcpOpt_NetworkInformationServiceServers': 41,
        'DhcpOpt_NetworkTimeProtocolServers': 42,
        'DhcpOpt_VendorSpecificInformation': 43,
        'DhcpOpt_Option_44': 44,
        'DhcpOpt_Option_45': 45,
        'DhcpOpt_Option_46': 46,
        'DhcpOpt_Option_47': 47,
        'DhcpOpt_Option_48': 48,
        'DhcpOpt_Option_49': 49,
        'DhcpOpt_IPAddressLeaseTime': 51,
        'DhcpOpt_Option_64': 64,
        'DhcpOpt_Option_65': 65,
        'DhcpOpt_TFTPServerName': 66,
        'DhcpOpt_BootfileName': 67,
        'DhcpOpt_Option_68': 68,
        'DhcpOpt_Option_69': 69,
        'DhcpOpt_Option_70': 70,
        'DhcpOpt_Option_71': 71,
        'DhcpOpt_Option_72': 72,
        'DhcpOpt_Option_73': 73,
        'DhcpOpt_Option_74': 74,
        'DhcpOpt_Option_75': 75,
        'DhcpOpt_Option_119': 119,
        'DhcpOptEncoding_Legacy': 0,
        'DhcpOptEncoding_Hex': 1,
        'VFSType_File': 1,
        'VFSType_Cloud': 2,
        'VFSType_S3': 3,
        'VFSType_WebDav': 4,
        'VFSType_OCI': 5,
        'ImportOptions_KeepAllMACs': 1,
        'ImportOptions_KeepNATMACs': 2,
        'ImportOptions_ImportToVDI': 3,
        'ExportOptions_CreateManifest': 1,
        'ExportOptions_ExportDVDImages': 2,
        'ExportOptions_StripAllMACs': 3,
        'ExportOptions_StripAllNonNATMACs': 4,
        'CertificateVersion_V1': 1,
        'CertificateVersion_V2': 2,
        'CertificateVersion_V3': 3,
        'CertificateVersion_Unknown': 99,
        'VirtualSystemDescriptionType_Ignore': 1,
        'VirtualSystemDescriptionType_OS': 2,
        'VirtualSystemDescriptionType_Name': 3,
        'VirtualSystemDescriptionType_Product': 4,
        'VirtualSystemDescriptionType_Vendor': 5,
        'VirtualSystemDescriptionType_Version': 6,
        'VirtualSystemDescriptionType_ProductUrl': 7,
        'VirtualSystemDescriptionType_VendorUrl': 8,
        'VirtualSystemDescriptionType_Description': 9,
        'VirtualSystemDescriptionType_License': 10,
        'VirtualSystemDescriptionType_Miscellaneous': 11,
        'VirtualSystemDescriptionType_CPU': 12,
        'VirtualSystemDescriptionType_Memory': 13,
        'VirtualSystemDescriptionType_HardDiskControllerIDE': 14,
        'VirtualSystemDescriptionType_HardDiskControllerSATA': 15,
        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 16,
        'VirtualSystemDescriptionType_HardDiskControllerSAS': 17,
        'VirtualSystemDescriptionType_HardDiskImage': 18,
        'VirtualSystemDescriptionType_Floppy': 19,
        'VirtualSystemDescriptionType_CDROM': 20,
        'VirtualSystemDescriptionType_NetworkAdapter': 21,
        'VirtualSystemDescriptionType_USBController': 22,
        'VirtualSystemDescriptionType_SoundCard': 23,
        'VirtualSystemDescriptionType_SettingsFile': 24,
        'VirtualSystemDescriptionType_BaseFolder': 25,
        'VirtualSystemDescriptionType_PrimaryGroup': 26,
        'VirtualSystemDescriptionType_CloudInstanceShape': 27,
        'VirtualSystemDescriptionType_CloudDomain': 28,
        'VirtualSystemDescriptionType_CloudBootDiskSize': 29,
        'VirtualSystemDescriptionType_CloudBucket': 30,
        'VirtualSystemDescriptionType_CloudOCIVCN': 31,
        'VirtualSystemDescriptionType_CloudPublicIP': 32,
        'VirtualSystemDescriptionType_CloudProfileName': 33,
        'VirtualSystemDescriptionType_CloudOCISubnet': 34,
        'VirtualSystemDescriptionType_CloudKeepObject': 35,
        'VirtualSystemDescriptionType_CloudLaunchInstance': 36,
        'VirtualSystemDescriptionValueType_Reference': 1,
        'VirtualSystemDescriptionValueType_Original': 2,
        'VirtualSystemDescriptionValueType_Auto': 3,
        'VirtualSystemDescriptionValueType_ExtraConfig': 4,
        'RecordingDestination_None': 0,
        'RecordingDestination_File': 1,
        'RecordingFeature_None': 0,
        'RecordingFeature_Video': 1,
        'RecordingFeature_Audio': 2,
        'RecordingAudioCodec_None': 0,
        'RecordingAudioCodec_WavPCM': 1,
        'RecordingAudioCodec_Opus': 2,
        'RecordingVideoCodec_None': 0,
        'RecordingVideoCodec_VP8': 1,
        'RecordingVideoCodec_VP9': 2,
        'RecordingVideoCodec_AV1': 3,
        'RecordingVideoScalingMethod_None': 0,
        'RecordingVideoScalingMethod_NearestNeighbor': 1,
        'RecordingVideoScalingMethod_Bilinear': 2,
        'RecordingVideoScalingMethod_Bicubic': 3,
        'RecordingVideoRateControlMode_CBR': 0,
        'RecordingVideoRateControlMode_VBR': 1,
        'GraphicsControllerType_Null': 0,
        'GraphicsControllerType_VBoxVGA': 1,
        'GraphicsControllerType_VMSVGA': 2,
        'GraphicsControllerType_VBoxSVGA': 3,
        'CleanupMode_UnregisterOnly': 1,
        'CleanupMode_DetachAllReturnNone': 2,
        'CleanupMode_DetachAllReturnHardDisksOnly': 3,
        'CleanupMode_Full': 4,
        'CloneMode_MachineState': 1,
        'CloneMode_MachineAndChildStates': 2,
        'CloneMode_AllStates': 3,
        'CloneOptions_Link': 1,
        'CloneOptions_KeepAllMACs': 2,
        'CloneOptions_KeepNATMACs': 3,
        'CloneOptions_KeepDiskNames': 4,
        'CloneOptions_KeepHwUUIDs': 5,
        'AutostopType_Disabled': 1,
        'AutostopType_SaveState': 2,
        'AutostopType_PowerOff': 3,
        'AutostopType_AcpiShutdown': 4,
        'HostNetworkInterfaceMediumType_Unknown': 0,
        'HostNetworkInterfaceMediumType_Ethernet': 1,
        'HostNetworkInterfaceMediumType_PPP': 2,
        'HostNetworkInterfaceMediumType_SLIP': 3,
        'HostNetworkInterfaceStatus_Unknown': 0,
        'HostNetworkInterfaceStatus_Up': 1,
        'HostNetworkInterfaceStatus_Down': 2,
        'HostNetworkInterfaceType_Bridged': 1,
        'HostNetworkInterfaceType_HostOnly': 2,
        'ProxyMode_System': 0,
        'ProxyMode_NoProxy': 1,
        'ProxyMode_Manual': 2,
        'AdditionsFacilityType_None': 0,
        'AdditionsFacilityType_VBoxGuestDriver': 20,
        'AdditionsFacilityType_AutoLogon': 90,
        'AdditionsFacilityType_VBoxService': 100,
        'AdditionsFacilityType_VBoxTrayClient': 101,
        'AdditionsFacilityType_Seamless': 1000,
        'AdditionsFacilityType_Graphics': 1100,
        'AdditionsFacilityType_MonitorAttach': 1101,
        'AdditionsFacilityType_All': 2147483646,
        'AdditionsFacilityClass_None': 0,
        'AdditionsFacilityClass_Driver': 10,
        'AdditionsFacilityClass_Service': 30,
        'AdditionsFacilityClass_Program': 50,
        'AdditionsFacilityClass_Feature': 100,
        'AdditionsFacilityClass_ThirdParty': 999,
        'AdditionsFacilityClass_All': 2147483646,
        'AdditionsFacilityStatus_Inactive': 0,
        'AdditionsFacilityStatus_Paused': 1,
        'AdditionsFacilityStatus_PreInit': 20,
        'AdditionsFacilityStatus_Init': 30,
        'AdditionsFacilityStatus_Active': 50,
        'AdditionsFacilityStatus_Terminating': 100,
        'AdditionsFacilityStatus_Terminated': 101,
        'AdditionsFacilityStatus_Failed': 800,
        'AdditionsFacilityStatus_Unknown': 999,
        'AdditionsRunLevelType_None': 0,
        'AdditionsRunLevelType_System': 1,
        'AdditionsRunLevelType_Userland': 2,
        'AdditionsRunLevelType_Desktop': 3,
        'AdditionsUpdateFlag_None': 0,
        'AdditionsUpdateFlag_WaitForUpdateStartOnly': 1,
        'GuestSessionStatus_Undefined': 0,
        'GuestSessionStatus_Starting': 10,
        'GuestSessionStatus_Started': 100,
        'GuestSessionStatus_Terminating': 480,
        'GuestSessionStatus_Terminated': 500,
        'GuestSessionStatus_TimedOutKilled': 512,
        'GuestSessionStatus_TimedOutAbnormally': 513,
        'GuestSessionStatus_Down': 600,
        'GuestSessionStatus_Error': 800,
        'GuestSessionWaitForFlag_None': 0,
        'GuestSessionWaitForFlag_Start': 1,
        'GuestSessionWaitForFlag_Terminate': 2,
        'GuestSessionWaitForFlag_Status': 4,
        'GuestSessionWaitResult_None': 0,
        'GuestSessionWaitResult_Start': 1,
        'GuestSessionWaitResult_Terminate': 2,
        'GuestSessionWaitResult_Status': 3,
        'GuestSessionWaitResult_Error': 4,
        'GuestSessionWaitResult_Timeout': 5,
        'GuestSessionWaitResult_WaitFlagNotSupported': 6,
        'GuestUserState_Unknown': 0,
        'GuestUserState_LoggedIn': 1,
        'GuestUserState_LoggedOut': 2,
        'GuestUserState_Locked': 3,
        'GuestUserState_Unlocked': 4,
        'GuestUserState_Disabled': 5,
        'GuestUserState_Idle': 6,
        'GuestUserState_InUse': 7,
        'GuestUserState_Created': 8,
        'GuestUserState_Deleted': 9,
        'GuestUserState_SessionChanged': 10,
        'GuestUserState_CredentialsChanged': 11,
        'GuestUserState_RoleChanged': 12,
        'GuestUserState_GroupAdded': 13,
        'GuestUserState_GroupRemoved': 14,
        'GuestUserState_Elevated': 15,
        'FileSeekOrigin_Begin': 0,
        'FileSeekOrigin_Current': 1,
        'FileSeekOrigin_End': 2,
        'ProcessInputFlag_None': 0,
        'ProcessInputFlag_EndOfFile': 1,
        'ProcessOutputFlag_None': 0,
        'ProcessOutputFlag_StdErr': 1,
        'ProcessWaitForFlag_None': 0,
        'ProcessWaitForFlag_Start': 1,
        'ProcessWaitForFlag_Terminate': 2,
        'ProcessWaitForFlag_StdIn': 4,
        'ProcessWaitForFlag_StdOut': 8,
        'ProcessWaitForFlag_StdErr': 16,
        'ProcessWaitResult_None': 0,
        'ProcessWaitResult_Start': 1,
        'ProcessWaitResult_Terminate': 2,
        'ProcessWaitResult_Status': 3,
        'ProcessWaitResult_Error': 4,
        'ProcessWaitResult_Timeout': 5,
        'ProcessWaitResult_StdIn': 6,
        'ProcessWaitResult_StdOut': 7,
        'ProcessWaitResult_StdErr': 8,
        'ProcessWaitResult_WaitFlagNotSupported': 9,
        'FileCopyFlag_None': 0,
        'FileCopyFlag_NoReplace': 1,
        'FileCopyFlag_FollowLinks': 2,
        'FileCopyFlag_Update': 4,
        'FsObjMoveFlag_None': 0,
        'FsObjMoveFlag_Replace': 1,
        'FsObjMoveFlag_FollowLinks': 2,
        'FsObjMoveFlag_AllowDirectoryMoves': 4,
        'DirectoryCreateFlag_None': 0,
        'DirectoryCreateFlag_Parents': 1,
        'DirectoryCopyFlag_None': 0,
        'DirectoryCopyFlag_CopyIntoExisting': 1,
        'DirectoryRemoveRecFlag_None': 0,
        'DirectoryRemoveRecFlag_ContentAndDir': 1,
        'DirectoryRemoveRecFlag_ContentOnly': 2,
        'FsObjRenameFlag_NoReplace': 0,
        'FsObjRenameFlag_Replace': 1,
        'ProcessCreateFlag_None': 0,
        'ProcessCreateFlag_WaitForProcessStartOnly': 1,
        'ProcessCreateFlag_IgnoreOrphanedProcesses': 2,
        'ProcessCreateFlag_Hidden': 4,
        'ProcessCreateFlag_Profile': 8,
        'ProcessCreateFlag_WaitForStdOut': 16,
        'ProcessCreateFlag_WaitForStdErr': 32,
        'ProcessCreateFlag_ExpandArguments': 64,
        'ProcessCreateFlag_UnquotedArguments': 128,
        'ProcessPriority_Invalid': 0,
        'ProcessPriority_Default': 1,
        'SymlinkType_Unknown': 0,
        'SymlinkType_Directory': 1,
        'SymlinkType_File': 2,
        'SymlinkReadFlag_None': 0,
        'SymlinkReadFlag_NoSymlinks': 1,
        'ProcessStatus_Undefined': 0,
        'ProcessStatus_Starting': 10,
        'ProcessStatus_Started': 100,
        'ProcessStatus_Paused': 110,
        'ProcessStatus_Terminating': 480,
        'ProcessStatus_TerminatedNormally': 500,
        'ProcessStatus_TerminatedSignal': 510,
        'ProcessStatus_TerminatedAbnormally': 511,
        'ProcessStatus_TimedOutKilled': 512,
        'ProcessStatus_TimedOutAbnormally': 513,
        'ProcessStatus_Down': 600,
        'ProcessStatus_Error': 800,
        'ProcessInputStatus_Undefined': 0,
        'ProcessInputStatus_Broken': 1,
        'ProcessInputStatus_Available': 10,
        'ProcessInputStatus_Written': 50,
        'ProcessInputStatus_Overflow': 100,
        'PathStyle_DOS': 1,
        'PathStyle_UNIX': 2,
        'PathStyle_Unknown': 8,
        'FileAccessMode_ReadOnly': 1,
        'FileAccessMode_WriteOnly': 2,
        'FileAccessMode_ReadWrite': 3,
        'FileAccessMode_AppendOnly': 4,
        'FileAccessMode_AppendRead': 5,
        'FileOpenAction_OpenExisting': 1,
        'FileOpenAction_OpenOrCreate': 2,
        'FileOpenAction_CreateNew': 3,
        'FileOpenAction_CreateOrReplace': 4,
        'FileOpenAction_OpenExistingTruncated': 5,
        'FileOpenAction_AppendOrCreate': 99,
        'FileSharingMode_Read': 1,
        'FileSharingMode_Write': 2,
        'FileSharingMode_ReadWrite': 3,
        'FileSharingMode_Delete': 4,
        'FileSharingMode_ReadDelete': 5,
        'FileSharingMode_WriteDelete': 6,
        'FileSharingMode_All': 7,
        'FileOpenExFlag_None': 0,
        'FileStatus_Undefined': 0,
        'FileStatus_Opening': 10,
        'FileStatus_Open': 100,
        'FileStatus_Closing': 150,
        'FileStatus_Closed': 200,
        'FileStatus_Down': 600,
        'FileStatus_Error': 800,
        'FsObjType_Unknown': 1,
        'FsObjType_Fifo': 2,
        'FsObjType_DevChar': 3,
        'FsObjType_Directory': 4,
        'FsObjType_DevBlock': 5,
        'FsObjType_File': 6,
        'FsObjType_Symlink': 7,
        'FsObjType_Socket': 8,
        'FsObjType_WhiteOut': 9,
        'DnDAction_Ignore': 0,
        'DnDAction_Copy': 1,
        'DnDAction_Move': 2,
        'DnDAction_Link': 3,
        'DirectoryOpenFlag_None': 0,
        'DirectoryOpenFlag_NoSymlinks': 1,
        'MediumState_NotCreated': 0,
        'MediumState_Created': 1,
        'MediumState_LockedRead': 2,
        'MediumState_LockedWrite': 3,
        'MediumState_Inaccessible': 4,
        'MediumState_Creating': 5,
        'MediumState_Deleting': 6,
        'MediumType_Normal': 0,
        'MediumType_Immutable': 1,
        'MediumType_Writethrough': 2,
        'MediumType_Shareable': 3,
        'MediumType_Readonly': 4,
        'MediumType_MultiAttach': 5,
        'MediumVariant_Standard': 0,
        'MediumVariant_VmdkSplit2G': 0x01,
        'MediumVariant_VmdkRawDisk': 0x02,
        'MediumVariant_VmdkStreamOptimized': 0x04,
        'MediumVariant_VmdkESX': 0x08,
        'MediumVariant_VdiZeroExpand': 0x100,
        'MediumVariant_Fixed': 0x10000,
        'MediumVariant_Diff': 0x20000,
        'MediumVariant_Formatted': 0x20000000,
        'MediumVariant_NoCreateDir': 0x40000000,
        'DataType_Int32': 0,
        'DataType_Int8': 1,
        'DataType_String': 2,
        'DataFlags_None': 0x00,
        'DataFlags_Mandatory': 0x01,
        'DataFlags_Expert': 0x02,
        'DataFlags_Array': 0x04,
        'DataFlags_FlagMask': 0x07,
        'MediumFormatCapabilities_Uuid': 0x01,
        'MediumFormatCapabilities_CreateFixed': 0x02,
        'MediumFormatCapabilities_CreateDynamic': 0x04,
        'MediumFormatCapabilities_CreateSplit2G': 0x08,
        'MediumFormatCapabilities_Differencing': 0x10,
        'MediumFormatCapabilities_Asynchronous': 0x20,
        'MediumFormatCapabilities_File': 0x40,
        'MediumFormatCapabilities_Properties': 0x80,
        'MediumFormatCapabilities_TcpNetworking': 0x100,
        'MediumFormatCapabilities_VFS': 0x200,
        'MediumFormatCapabilities_Discard': 0x400,
        'MediumFormatCapabilities_Preferred': 0x800,
        'MediumFormatCapabilities_CapabilityMask': 0xFFF,
        'PartitionTableType_MBR': 1,
        'PartitionTableType_GPT': 2,
        'KeyboardLED_NumLock': 0x01,
        'KeyboardLED_CapsLock': 0x02,
        'KeyboardLED_ScrollLock': 0x04,
        'MouseButtonState_LeftButton': 0x01,
        'MouseButtonState_RightButton': 0x02,
        'MouseButtonState_MiddleButton': 0x04,
        'MouseButtonState_WheelUp': 0x08,
        'MouseButtonState_WheelDown': 0x10,
        'MouseButtonState_XButton1': 0x20,
        'MouseButtonState_XButton2': 0x40,
        'MouseButtonState_MouseStateMask': 0x7F,
        'TouchContactState_None': 0x00,
        'TouchContactState_InContact': 0x01,
        'TouchContactState_InRange': 0x02,
        'TouchContactState_ContactStateMask': 0x03,
        'FramebufferCapabilities_UpdateImage': 0x01,
        'FramebufferCapabilities_VHWA': 0x02,
        'FramebufferCapabilities_VisibleRegion': 0x04,
        'FramebufferCapabilities_RenderCursor': 0x08,
        'FramebufferCapabilities_MoveCursor': 0x10,
        'GuestMonitorStatus_Disabled': 0,
        'GuestMonitorStatus_Enabled': 1,
        'GuestMonitorStatus_Blank': 2,
        'ScreenLayoutMode_Apply': 0,
        'ScreenLayoutMode_Reset': 1,
        'ScreenLayoutMode_Attach': 2,
        'NetworkAttachmentType_Null': 0,
        'NetworkAttachmentType_NAT': 1,
        'NetworkAttachmentType_Bridged': 2,
        'NetworkAttachmentType_Internal': 3,
        'NetworkAttachmentType_HostOnly': 4,
        'NetworkAttachmentType_Generic': 5,
        'NetworkAttachmentType_NATNetwork': 6,
        'NetworkAdapterType_Null': 0,
        'NetworkAdapterType_Am79C970A': 1,
        'NetworkAdapterType_Am79C973': 2,
        'NetworkAdapterType_I82540EM': 3,
        'NetworkAdapterType_I82543GC': 4,
        'NetworkAdapterType_I82545EM': 5,
        'NetworkAdapterType_Virtio': 6,
        'NetworkAdapterPromiscModePolicy_Deny': 1,
        'NetworkAdapterPromiscModePolicy_AllowNetwork': 2,
        'NetworkAdapterPromiscModePolicy_AllowAll': 3,
        'PortMode_Disconnected': 0,
        'PortMode_HostPipe': 1,
        'PortMode_HostDevice': 2,
        'PortMode_RawFile': 3,
        'PortMode_TCP': 4,
        'UartType_U16450': 0,
        'UartType_U16550A': 1,
        'UartType_U16750': 2,
        'VMExecutionEngine_NotSet': 0,
        'VMExecutionEngine_RawMode': 1,
        'VMExecutionEngine_HwVirt': 2,
        'VMExecutionEngine_NativeApi': 3,
        'USBControllerType_Null': 0,
        'USBControllerType_OHCI': 1,
        'USBControllerType_EHCI': 2,
        'USBControllerType_XHCI': 3,
        'USBControllerType_Last': 4,
        'USBConnectionSpeed_Null': 0,
        'USBConnectionSpeed_Low': 1,
        'USBConnectionSpeed_Full': 2,
        'USBConnectionSpeed_High': 3,
        'USBConnectionSpeed_Super': 4,
        'USBConnectionSpeed_SuperPlus': 5,
        'USBDeviceState_NotSupported': 0,
        'USBDeviceState_Unavailable': 1,
        'USBDeviceState_Busy': 2,
        'USBDeviceState_Available': 3,
        'USBDeviceState_Held': 4,
        'USBDeviceState_Captured': 5,
        'USBDeviceFilterAction_Null': 0,
        'USBDeviceFilterAction_Ignore': 1,
        'USBDeviceFilterAction_Hold': 2,
        'AudioDriverType_Null': 0,
        'AudioDriverType_WinMM': 1,
        'AudioDriverType_OSS': 2,
        'AudioDriverType_ALSA': 3,
        'AudioDriverType_DirectSound': 4,
        'AudioDriverType_CoreAudio': 5,
        'AudioDriverType_MMPM': 6,
        'AudioDriverType_Pulse': 7,
        'AudioDriverType_SolAudio': 8,
        'AudioControllerType_AC97': 0,
        'AudioControllerType_SB16': 1,
        'AudioControllerType_HDA': 2,
        'AudioCodecType_Null': 0,
        'AudioCodecType_SB16': 1,
        'AudioCodecType_STAC9700': 2,
        'AudioCodecType_AD1980': 3,
        'AudioCodecType_STAC9221': 4,
        'AuthType_Null': 0,
        'AuthType_External': 1,
        'AuthType_Guest': 2,
        'Reason_Unspecified': 0,
        'Reason_HostSuspend': 1,
        'Reason_HostResume': 2,
        'Reason_HostBatteryLow': 3,
        'Reason_Snapshot': 4,
        'StorageBus_Null': 0,
        'StorageBus_IDE': 1,
        'StorageBus_SATA': 2,
        'StorageBus_SCSI': 3,
        'StorageBus_Floppy': 4,
        'StorageBus_SAS': 5,
        'StorageBus_USB': 6,
        'StorageBus_PCIe': 7,
        'StorageControllerType_Null': 0,
        'StorageControllerType_LsiLogic': 1,
        'StorageControllerType_BusLogic': 2,
        'StorageControllerType_IntelAhci': 3,
        'StorageControllerType_PIIX3': 4,
        'StorageControllerType_PIIX4': 5,
        'StorageControllerType_ICH6': 6,
        'StorageControllerType_I82078': 7,
        'StorageControllerType_LsiLogicSas': 8,
        'StorageControllerType_USB': 9,
        'StorageControllerType_NVMe': 10,
        'ChipsetType_Null': 0,
        'ChipsetType_PIIX3': 1,
        'ChipsetType_ICH9': 2,
        'NATAliasMode_AliasLog': 0x1,
        'NATAliasMode_AliasProxyOnly': 0x02,
        'NATAliasMode_AliasUseSamePorts': 0x04,
        'NATProtocol_UDP': 0,
        'NATProtocol_TCP': 1,
        'BandwidthGroupType_Null': 0,
        'BandwidthGroupType_Disk': 1,
        'BandwidthGroupType_Network': 2,
        'VBoxEventType_Invalid': 0,
        'VBoxEventType_Any': 1,
        'VBoxEventType_Vetoable': 2,
        'VBoxEventType_MachineEvent': 3,
        'VBoxEventType_SnapshotEvent': 4,
        'VBoxEventType_InputEvent': 5,
        'VBoxEventType_LastWildcard': 31,
        'VBoxEventType_OnMachineStateChanged': 32,
        'VBoxEventType_OnMachineDataChanged': 33,
        'VBoxEventType_OnExtraDataChanged': 34,
        'VBoxEventType_OnExtraDataCanChange': 35,
        'VBoxEventType_OnMediumRegistered': 36,
        'VBoxEventType_OnMachineRegistered': 37,
        'VBoxEventType_OnSessionStateChanged': 38,
        'VBoxEventType_OnSnapshotTaken': 39,
        'VBoxEventType_OnSnapshotDeleted': 40,
        'VBoxEventType_OnSnapshotChanged': 41,
        'VBoxEventType_OnGuestPropertyChanged': 42,
        'VBoxEventType_OnMousePointerShapeChanged': 43,
        'VBoxEventType_OnMouseCapabilityChanged': 44,
        'VBoxEventType_OnKeyboardLedsChanged': 45,
        'VBoxEventType_OnStateChanged': 46,
        'VBoxEventType_OnAdditionsStateChanged': 47,
        'VBoxEventType_OnNetworkAdapterChanged': 48,
        'VBoxEventType_OnSerialPortChanged': 49,
        'VBoxEventType_OnParallelPortChanged': 50,
        'VBoxEventType_OnStorageControllerChanged': 51,
        'VBoxEventType_OnMediumChanged': 52,
        'VBoxEventType_OnVRDEServerChanged': 53,
        'VBoxEventType_OnUSBControllerChanged': 54,
        'VBoxEventType_OnUSBDeviceStateChanged': 55,
        'VBoxEventType_OnSharedFolderChanged': 56,
        'VBoxEventType_OnRuntimeError': 57,
        'VBoxEventType_OnCanShowWindow': 58,
        'VBoxEventType_OnShowWindow': 59,
        'VBoxEventType_OnCPUChanged': 60,
        'VBoxEventType_OnVRDEServerInfoChanged': 61,
        'VBoxEventType_OnEventSourceChanged': 62,
        'VBoxEventType_OnCPUExecutionCapChanged': 63,
        'VBoxEventType_OnGuestKeyboard': 64,
        'VBoxEventType_OnGuestMouse': 65,
        'VBoxEventType_OnNATRedirect': 66,
        'VBoxEventType_OnHostPCIDevicePlug': 67,
        'VBoxEventType_OnVBoxSVCAvailabilityChanged': 68,
        'VBoxEventType_OnBandwidthGroupChanged': 69,
        'VBoxEventType_OnGuestMonitorChanged': 70,
        'VBoxEventType_OnStorageDeviceChanged': 71,
        'VBoxEventType_OnClipboardModeChanged': 72,
        'VBoxEventType_OnDnDModeChanged': 73,
        'VBoxEventType_OnNATNetworkChanged': 74,
        'VBoxEventType_OnNATNetworkStartStop': 75,
        'VBoxEventType_OnNATNetworkAlter': 76,
        'VBoxEventType_OnNATNetworkCreationDeletion': 77,
        'VBoxEventType_OnNATNetworkSetting': 78,
        'VBoxEventType_OnNATNetworkPortForward': 79,
        'VBoxEventType_OnGuestSessionStateChanged': 80,
        'VBoxEventType_OnGuestSessionRegistered': 81,
        'VBoxEventType_OnGuestProcessRegistered': 82,
        'VBoxEventType_OnGuestProcessStateChanged': 83,
        'VBoxEventType_OnGuestProcessInputNotify': 84,
        'VBoxEventType_OnGuestProcessOutput': 85,
        'VBoxEventType_OnGuestFileRegistered': 86,
        'VBoxEventType_OnGuestFileStateChanged': 87,
        'VBoxEventType_OnGuestFileOffsetChanged': 88,
        'VBoxEventType_OnGuestFileRead': 89,
        'VBoxEventType_OnGuestFileWrite': 90,
        'VBoxEventType_OnRecordingChanged': 91,
        'VBoxEventType_OnGuestUserStateChanged': 92,
        'VBoxEventType_OnGuestMultiTouch': 93,
        'VBoxEventType_OnHostNameResolutionConfigurationChange': 94,
        'VBoxEventType_OnSnapshotRestored': 95,
        'VBoxEventType_OnMediumConfigChanged': 96,
        'VBoxEventType_OnAudioAdapterChanged': 97,
        'VBoxEventType_OnProgressPercentageChanged': 98,
        'VBoxEventType_OnProgressTaskCompleted': 99,
        'VBoxEventType_OnCursorPositionChanged': 100,
        'VBoxEventType_Last': 101,
        'GuestMouseEventMode_Relative': 0,
        'GuestMouseEventMode_Absolute': 1,
        'GuestMonitorChangedEventType_Enabled': 0,
        'GuestMonitorChangedEventType_Disabled': 1,
        'GuestMonitorChangedEventType_NewOrigin': 2,
        # Result constants:
        'VBOX_E_OBJECT_NOT_FOUND': 0x80BB0001,
        'VBOX_E_INVALID_VM_STATE': 0x80BB0002,
        'VBOX_E_VM_ERROR': 0x80BB0003,
        'VBOX_E_FILE_ERROR': 0x80BB0004,
        'VBOX_E_IPRT_ERROR': 0x80BB0005,
        'VBOX_E_PDM_ERROR': 0x80BB0006,
        'VBOX_E_INVALID_OBJECT_STATE': 0x80BB0007,
        'VBOX_E_HOST_ERROR': 0x80BB0008,
        'VBOX_E_NOT_SUPPORTED': 0x80BB0009,
        'VBOX_E_XML_ERROR': 0x80BB000A,
        'VBOX_E_INVALID_SESSION_STATE': 0x80BB000B,
        'VBOX_E_OBJECT_IN_USE': 0x80BB000C,
        'VBOX_E_PASSWORD_INCORRECT': 0x80BB000D,
        'VBOX_E_MAXIMUM_REACHED': 0x80BB000E,
        'VBOX_E_GSTCTL_GUEST_ERROR': 0x80BB000F,
        'VBOX_E_TIMEOUT': 0x80BB0010,
    }

    __dValuesFlatSym = {
        'SettingsVersion_Null': 'Null',
        'SettingsVersion_v1_0': 'v1_0',
        'SettingsVersion_v1_1': 'v1_1',
        'SettingsVersion_v1_2': 'v1_2',
        'SettingsVersion_v1_3pre': 'v1_3pre',
        'SettingsVersion_v1_3': 'v1_3',
        'SettingsVersion_v1_4': 'v1_4',
        'SettingsVersion_v1_5': 'v1_5',
        'SettingsVersion_v1_6': 'v1_6',
        'SettingsVersion_v1_7': 'v1_7',
        'SettingsVersion_v1_8': 'v1_8',
        'SettingsVersion_v1_9': 'v1_9',
        'SettingsVersion_v1_10': 'v1_10',
        'SettingsVersion_v1_11': 'v1_11',
        'SettingsVersion_v1_12': 'v1_12',
        'SettingsVersion_v1_13': 'v1_13',
        'SettingsVersion_v1_14': 'v1_14',
        'SettingsVersion_v1_15': 'v1_15',
        'SettingsVersion_v1_16': 'v1_16',
        'SettingsVersion_v1_17': 'v1_17',
        'SettingsVersion_Future': 'Future',
        'AccessMode_ReadOnly': 'ReadOnly',
        'AccessMode_ReadWrite': 'ReadWrite',
        'MachineState_Null': 'Null',
        'MachineState_PoweredOff': 'PoweredOff',
        'MachineState_Saved': 'Saved',
        'MachineState_Teleported': 'Teleported',
        'MachineState_Aborted': 'Aborted',
        'MachineState_Running': 'Running',
        'MachineState_Paused': 'Paused',
        'MachineState_Stuck': 'Stuck',
        'MachineState_Teleporting': 'Teleporting',
        'MachineState_LiveSnapshotting': 'LiveSnapshotting',
        'MachineState_Starting': 'Starting',
        'MachineState_Stopping': 'Stopping',
        'MachineState_Saving': 'Saving',
        'MachineState_Restoring': 'Restoring',
        'MachineState_TeleportingPausedVM': 'TeleportingPausedVM',
        'MachineState_TeleportingIn': 'TeleportingIn',
        'MachineState_FaultTolerantSyncing': 'FaultTolerantSyncing',
        'MachineState_DeletingSnapshotOnline': 'DeletingSnapshotOnline',
        'MachineState_DeletingSnapshotPaused': 'DeletingSnapshotPaused',
        'MachineState_OnlineSnapshotting': 'OnlineSnapshotting',
        'MachineState_RestoringSnapshot': 'RestoringSnapshot',
        'MachineState_DeletingSnapshot': 'DeletingSnapshot',
        'MachineState_SettingUp': 'SettingUp',
        'MachineState_Snapshotting': 'Snapshotting',
        'MachineState_FirstOnline': 'FirstOnline',
        'MachineState_LastOnline': 'LastOnline',
        'MachineState_FirstTransient': 'FirstTransient',
        'MachineState_LastTransient': 'LastTransient',
        'SessionState_Null': 'Null',
        'SessionState_Unlocked': 'Unlocked',
        'SessionState_Locked': 'Locked',
        'SessionState_Spawning': 'Spawning',
        'SessionState_Unlocking': 'Unlocking',
        'CPUPropertyType_Null': 'Null',
        'CPUPropertyType_PAE': 'PAE',
        'CPUPropertyType_LongMode': 'LongMode',
        'CPUPropertyType_TripleFaultReset': 'TripleFaultReset',
        'CPUPropertyType_APIC': 'APIC',
        'CPUPropertyType_X2APIC': 'X2APIC',
        'CPUPropertyType_IBPBOnVMExit': 'IBPBOnVMExit',
        'CPUPropertyType_IBPBOnVMEntry': 'IBPBOnVMEntry',
        'CPUPropertyType_HWVirt': 'HWVirt',
        'CPUPropertyType_SpecCtrl': 'SpecCtrl',
        'CPUPropertyType_SpecCtrlByHost': 'SpecCtrlByHost',
        'CPUPropertyType_L1DFlushOnEMTScheduling': 'L1DFlushOnEMTScheduling',
        'CPUPropertyType_L1DFlushOnVMEntry': 'L1DFlushOnVMEntry',
        'HWVirtExPropertyType_Null': 'Null',
        'HWVirtExPropertyType_Enabled': 'Enabled',
        'HWVirtExPropertyType_VPID': 'VPID',
        'HWVirtExPropertyType_NestedPaging': 'NestedPaging',
        'HWVirtExPropertyType_UnrestrictedExecution': 'UnrestrictedExecution',
        'HWVirtExPropertyType_LargePages': 'LargePages',
        'HWVirtExPropertyType_Force': 'Force',
        'HWVirtExPropertyType_UseNativeApi': 'UseNativeApi',
        'ParavirtProvider_None': 'None',
        'ParavirtProvider_Default': 'Default',
        'ParavirtProvider_Legacy': 'Legacy',
        'ParavirtProvider_Minimal': 'Minimal',
        'ParavirtProvider_HyperV': 'HyperV',
        'ParavirtProvider_KVM': 'KVM',
        'FaultToleranceState_Inactive': 'Inactive',
        'FaultToleranceState_Master': 'Master',
        'FaultToleranceState_Standby': 'Standby',
        'LockType_Null': 'Null',
        'LockType_Shared': 'Shared',
        'LockType_Write': 'Write',
        'LockType_VM': 'VM',
        'SessionType_Null': 'Null',
        'SessionType_WriteLock': 'WriteLock',
        'SessionType_Remote': 'Remote',
        'SessionType_Shared': 'Shared',
        'DeviceType_Null': 'Null',
        'DeviceType_Floppy': 'Floppy',
        'DeviceType_DVD': 'DVD',
        'DeviceType_HardDisk': 'HardDisk',
        'DeviceType_Network': 'Network',
        'DeviceType_USB': 'USB',
        'DeviceType_SharedFolder': 'SharedFolder',
        'DeviceType_Graphics3D': 'Graphics3D',
        'DeviceActivity_Null': 'Null',
        'DeviceActivity_Idle': 'Idle',
        'DeviceActivity_Reading': 'Reading',
        'DeviceActivity_Writing': 'Writing',
        'ClipboardMode_Disabled': 'Disabled',
        'ClipboardMode_HostToGuest': 'HostToGuest',
        'ClipboardMode_GuestToHost': 'GuestToHost',
        'ClipboardMode_Bidirectional': 'Bidirectional',
        'DnDMode_Disabled': 'Disabled',
        'DnDMode_HostToGuest': 'HostToGuest',
        'DnDMode_GuestToHost': 'GuestToHost',
        'DnDMode_Bidirectional': 'Bidirectional',
        'Scope_Global': 'Global',
        'Scope_Machine': 'Machine',
        'Scope_Session': 'Session',
        'BIOSBootMenuMode_Disabled': 'Disabled',
        'BIOSBootMenuMode_MenuOnly': 'MenuOnly',
        'BIOSBootMenuMode_MessageAndMenu': 'MessageAndMenu',
        'APICMode_Disabled': 'Disabled',
        'APICMode_APIC': 'APIC',
        'APICMode_X2APIC': 'X2APIC',
        'ProcessorFeature_HWVirtEx': 'HWVirtEx',
        'ProcessorFeature_PAE': 'PAE',
        'ProcessorFeature_LongMode': 'LongMode',
        'ProcessorFeature_NestedPaging': 'NestedPaging',
        'ProcessorFeature_UnrestrictedGuest': 'UnrestrictedGuest',
        'ProcessorFeature_NestedHWVirt': 'NestedHWVirt',
        'FirmwareType_BIOS': 'BIOS',
        'FirmwareType_EFI': 'EFI',
        'FirmwareType_EFI32': 'EFI32',
        'FirmwareType_EFI64': 'EFI64',
        'FirmwareType_EFIDUAL': 'EFIDUAL',
        'PointingHIDType_None': 'None',
        'PointingHIDType_PS2Mouse': 'PS2Mouse',
        'PointingHIDType_USBMouse': 'USBMouse',
        'PointingHIDType_USBTablet': 'USBTablet',
        'PointingHIDType_ComboMouse': 'ComboMouse',
        'PointingHIDType_USBMultiTouch': 'USBMultiTouch',
        'KeyboardHIDType_None': 'None',
        'KeyboardHIDType_PS2Keyboard': 'PS2Keyboard',
        'KeyboardHIDType_USBKeyboard': 'USBKeyboard',
        'KeyboardHIDType_ComboKeyboard': 'ComboKeyboard',
        'BitmapFormat_Opaque': 'Opaque',
        'BitmapFormat_BGR': 'BGR',
        'BitmapFormat_BGR0': 'BGR0',
        'BitmapFormat_BGRA': 'BGRA',
        'BitmapFormat_RGBA': 'RGBA',
        'BitmapFormat_PNG': 'PNG',
        'BitmapFormat_JPEG': 'JPEG',
        'DhcpOpt_SubnetMask': 'SubnetMask',
        'DhcpOpt_TimeOffset': 'TimeOffset',
        'DhcpOpt_Router': 'Router',
        'DhcpOpt_TimeServer': 'TimeServer',
        'DhcpOpt_NameServer': 'NameServer',
        'DhcpOpt_DomainNameServer': 'DomainNameServer',
        'DhcpOpt_LogServer': 'LogServer',
        'DhcpOpt_Cookie': 'Cookie',
        'DhcpOpt_LPRServer': 'LPRServer',
        'DhcpOpt_ImpressServer': 'ImpressServer',
        'DhcpOpt_ResourseLocationServer': 'ResourseLocationServer',
        'DhcpOpt_HostName': 'HostName',
        'DhcpOpt_BootFileSize': 'BootFileSize',
        'DhcpOpt_MeritDumpFile': 'MeritDumpFile',
        'DhcpOpt_DomainName': 'DomainName',
        'DhcpOpt_SwapServer': 'SwapServer',
        'DhcpOpt_RootPath': 'RootPath',
        'DhcpOpt_ExtensionPath': 'ExtensionPath',
        'DhcpOpt_IPForwardingEnableDisable': 'IPForwardingEnableDisable',
        'DhcpOpt_NonLocalSourceRoutingEnableDisable': 'NonLocalSourceRoutingEnableDisable',
        'DhcpOpt_PolicyFilter': 'PolicyFilter',
        'DhcpOpt_MaximumDatagramReassemblySize': 'MaximumDatagramReassemblySize',
        'DhcpOpt_DefaultIPTime2Live': 'DefaultIPTime2Live',
        'DhcpOpt_PathMTUAgingTimeout': 'PathMTUAgingTimeout',
        'DhcpOpt_IPLayerParametersPerInterface': 'IPLayerParametersPerInterface',
        'DhcpOpt_InterfaceMTU': 'InterfaceMTU',
        'DhcpOpt_AllSubnetsAreLocal': 'AllSubnetsAreLocal',
        'DhcpOpt_BroadcastAddress': 'BroadcastAddress',
        'DhcpOpt_PerformMaskDiscovery': 'PerformMaskDiscovery',
        'DhcpOpt_MaskSupplier': 'MaskSupplier',
        'DhcpOpt_PerformRouteDiscovery': 'PerformRouteDiscovery',
        'DhcpOpt_RouterSolicitationAddress': 'RouterSolicitationAddress',
        'DhcpOpt_StaticRoute': 'StaticRoute',
        'DhcpOpt_TrailerEncapsulation': 'TrailerEncapsulation',
        'DhcpOpt_ARPCacheTimeout': 'ARPCacheTimeout',
        'DhcpOpt_EthernetEncapsulation': 'EthernetEncapsulation',
        'DhcpOpt_TCPDefaultTTL': 'TCPDefaultTTL',
        'DhcpOpt_TCPKeepAliveInterval': 'TCPKeepAliveInterval',
        'DhcpOpt_TCPKeepAliveGarbage': 'TCPKeepAliveGarbage',
        'DhcpOpt_NetworkInformationServiceDomain': 'NetworkInformationServiceDomain',
        'DhcpOpt_NetworkInformationServiceServers': 'NetworkInformationServiceServers',
        'DhcpOpt_NetworkTimeProtocolServers': 'NetworkTimeProtocolServers',
        'DhcpOpt_VendorSpecificInformation': 'VendorSpecificInformation',
        'DhcpOpt_Option_44': 'Option_44',
        'DhcpOpt_Option_45': 'Option_45',
        'DhcpOpt_Option_46': 'Option_46',
        'DhcpOpt_Option_47': 'Option_47',
        'DhcpOpt_Option_48': 'Option_48',
        'DhcpOpt_Option_49': 'Option_49',
        'DhcpOpt_IPAddressLeaseTime': 'IPAddressLeaseTime',
        'DhcpOpt_Option_64': 'Option_64',
        'DhcpOpt_Option_65': 'Option_65',
        'DhcpOpt_TFTPServerName': 'TFTPServerName',
        'DhcpOpt_BootfileName': 'BootfileName',
        'DhcpOpt_Option_68': 'Option_68',
        'DhcpOpt_Option_69': 'Option_69',
        'DhcpOpt_Option_70': 'Option_70',
        'DhcpOpt_Option_71': 'Option_71',
        'DhcpOpt_Option_72': 'Option_72',
        'DhcpOpt_Option_73': 'Option_73',
        'DhcpOpt_Option_74': 'Option_74',
        'DhcpOpt_Option_75': 'Option_75',
        'DhcpOpt_Option_119': 'Option_119',
        'DhcpOptEncoding_Legacy': 'Legacy',
        'DhcpOptEncoding_Hex': 'Hex',
        'VFSType_File': 'File',
        'VFSType_Cloud': 'Cloud',
        'VFSType_S3': 'S3',
        'VFSType_WebDav': 'WebDav',
        'VFSType_OCI': 'OCI',
        'ImportOptions_KeepAllMACs': 'KeepAllMACs',
        'ImportOptions_KeepNATMACs': 'KeepNATMACs',
        'ImportOptions_ImportToVDI': 'ImportToVDI',
        'ExportOptions_CreateManifest': 'CreateManifest',
        'ExportOptions_ExportDVDImages': 'ExportDVDImages',
        'ExportOptions_StripAllMACs': 'StripAllMACs',
        'ExportOptions_StripAllNonNATMACs': 'StripAllNonNATMACs',
        'CertificateVersion_V1': 'V1',
        'CertificateVersion_V2': 'V2',
        'CertificateVersion_V3': 'V3',
        'CertificateVersion_Unknown': 'Unknown',
        'VirtualSystemDescriptionType_Ignore': 'Ignore',
        'VirtualSystemDescriptionType_OS': 'OS',
        'VirtualSystemDescriptionType_Name': 'Name',
        'VirtualSystemDescriptionType_Product': 'Product',
        'VirtualSystemDescriptionType_Vendor': 'Vendor',
        'VirtualSystemDescriptionType_Version': 'Version',
        'VirtualSystemDescriptionType_ProductUrl': 'ProductUrl',
        'VirtualSystemDescriptionType_VendorUrl': 'VendorUrl',
        'VirtualSystemDescriptionType_Description': 'Description',
        'VirtualSystemDescriptionType_License': 'License',
        'VirtualSystemDescriptionType_Miscellaneous': 'Miscellaneous',
        'VirtualSystemDescriptionType_CPU': 'CPU',
        'VirtualSystemDescriptionType_Memory': 'Memory',
        'VirtualSystemDescriptionType_HardDiskControllerIDE': 'HardDiskControllerIDE',
        'VirtualSystemDescriptionType_HardDiskControllerSATA': 'HardDiskControllerSATA',
        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 'HardDiskControllerSCSI',
        'VirtualSystemDescriptionType_HardDiskControllerSAS': 'HardDiskControllerSAS',
        'VirtualSystemDescriptionType_HardDiskImage': 'HardDiskImage',
        'VirtualSystemDescriptionType_Floppy': 'Floppy',
        'VirtualSystemDescriptionType_CDROM': 'CDROM',
        'VirtualSystemDescriptionType_NetworkAdapter': 'NetworkAdapter',
        'VirtualSystemDescriptionType_USBController': 'USBController',
        'VirtualSystemDescriptionType_SoundCard': 'SoundCard',
        'VirtualSystemDescriptionType_SettingsFile': 'SettingsFile',
        'VirtualSystemDescriptionType_BaseFolder': 'BaseFolder',
        'VirtualSystemDescriptionType_PrimaryGroup': 'PrimaryGroup',
        'VirtualSystemDescriptionType_CloudInstanceShape': 'CloudInstanceShape',
        'VirtualSystemDescriptionType_CloudDomain': 'CloudDomain',
        'VirtualSystemDescriptionType_CloudBootDiskSize': 'CloudBootDiskSize',
        'VirtualSystemDescriptionType_CloudBucket': 'CloudBucket',
        'VirtualSystemDescriptionType_CloudOCIVCN': 'CloudOCIVCN',
        'VirtualSystemDescriptionType_CloudPublicIP': 'CloudPublicIP',
        'VirtualSystemDescriptionType_CloudProfileName': 'CloudProfileName',
        'VirtualSystemDescriptionType_CloudOCISubnet': 'CloudOCISubnet',
        'VirtualSystemDescriptionType_CloudKeepObject': 'CloudKeepObject',
        'VirtualSystemDescriptionType_CloudLaunchInstance': 'CloudLaunchInstance',
        'VirtualSystemDescriptionValueType_Reference': 'Reference',
        'VirtualSystemDescriptionValueType_Original': 'Original',
        'VirtualSystemDescriptionValueType_Auto': 'Auto',
        'VirtualSystemDescriptionValueType_ExtraConfig': 'ExtraConfig',
        'RecordingDestination_None': 'None',
        'RecordingDestination_File': 'File',
        'RecordingFeature_None': 'None',
        'RecordingFeature_Video': 'Video',
        'RecordingFeature_Audio': 'Audio',
        'RecordingAudioCodec_None': 'None',
        'RecordingAudioCodec_WavPCM': 'WavPCM',
        'RecordingAudioCodec_Opus': 'Opus',
        'RecordingVideoCodec_None': 'None',
        'RecordingVideoCodec_VP8': 'VP8',
        'RecordingVideoCodec_VP9': 'VP9',
        'RecordingVideoCodec_AV1': 'AV1',
        'RecordingVideoScalingMethod_None': 'None',
        'RecordingVideoScalingMethod_NearestNeighbor': 'NearestNeighbor',
        'RecordingVideoScalingMethod_Bilinear': 'Bilinear',
        'RecordingVideoScalingMethod_Bicubic': 'Bicubic',
        'RecordingVideoRateControlMode_CBR': 'CBR',
        'RecordingVideoRateControlMode_VBR': 'VBR',
        'GraphicsControllerType_Null': 'Null',
        'GraphicsControllerType_VBoxVGA': 'VBoxVGA',
        'GraphicsControllerType_VMSVGA': 'VMSVGA',
        'GraphicsControllerType_VBoxSVGA': 'VBoxSVGA',
        'CleanupMode_UnregisterOnly': 'UnregisterOnly',
        'CleanupMode_DetachAllReturnNone': 'DetachAllReturnNone',
        'CleanupMode_DetachAllReturnHardDisksOnly': 'DetachAllReturnHardDisksOnly',
        'CleanupMode_Full': 'Full',
        'CloneMode_MachineState': 'MachineState',
        'CloneMode_MachineAndChildStates': 'MachineAndChildStates',
        'CloneMode_AllStates': 'AllStates',
        'CloneOptions_Link': 'Link',
        'CloneOptions_KeepAllMACs': 'KeepAllMACs',
        'CloneOptions_KeepNATMACs': 'KeepNATMACs',
        'CloneOptions_KeepDiskNames': 'KeepDiskNames',
        'CloneOptions_KeepHwUUIDs': 'KeepHwUUIDs',
        'AutostopType_Disabled': 'Disabled',
        'AutostopType_SaveState': 'SaveState',
        'AutostopType_PowerOff': 'PowerOff',
        'AutostopType_AcpiShutdown': 'AcpiShutdown',
        'HostNetworkInterfaceMediumType_Unknown': 'Unknown',
        'HostNetworkInterfaceMediumType_Ethernet': 'Ethernet',
        'HostNetworkInterfaceMediumType_PPP': 'PPP',
        'HostNetworkInterfaceMediumType_SLIP': 'SLIP',
        'HostNetworkInterfaceStatus_Unknown': 'Unknown',
        'HostNetworkInterfaceStatus_Up': 'Up',
        'HostNetworkInterfaceStatus_Down': 'Down',
        'HostNetworkInterfaceType_Bridged': 'Bridged',
        'HostNetworkInterfaceType_HostOnly': 'HostOnly',
        'ProxyMode_System': 'System',
        'ProxyMode_NoProxy': 'NoProxy',
        'ProxyMode_Manual': 'Manual',
        'AdditionsFacilityType_None': 'None',
        'AdditionsFacilityType_VBoxGuestDriver': 'VBoxGuestDriver',
        'AdditionsFacilityType_AutoLogon': 'AutoLogon',
        'AdditionsFacilityType_VBoxService': 'VBoxService',
        'AdditionsFacilityType_VBoxTrayClient': 'VBoxTrayClient',
        'AdditionsFacilityType_Seamless': 'Seamless',
        'AdditionsFacilityType_Graphics': 'Graphics',
        'AdditionsFacilityType_MonitorAttach': 'MonitorAttach',
        'AdditionsFacilityType_All': 'All',
        'AdditionsFacilityClass_None': 'None',
        'AdditionsFacilityClass_Driver': 'Driver',
        'AdditionsFacilityClass_Service': 'Service',
        'AdditionsFacilityClass_Program': 'Program',
        'AdditionsFacilityClass_Feature': 'Feature',
        'AdditionsFacilityClass_ThirdParty': 'ThirdParty',
        'AdditionsFacilityClass_All': 'All',
        'AdditionsFacilityStatus_Inactive': 'Inactive',
        'AdditionsFacilityStatus_Paused': 'Paused',
        'AdditionsFacilityStatus_PreInit': 'PreInit',
        'AdditionsFacilityStatus_Init': 'Init',
        'AdditionsFacilityStatus_Active': 'Active',
        'AdditionsFacilityStatus_Terminating': 'Terminating',
        'AdditionsFacilityStatus_Terminated': 'Terminated',
        'AdditionsFacilityStatus_Failed': 'Failed',
        'AdditionsFacilityStatus_Unknown': 'Unknown',
        'AdditionsRunLevelType_None': 'None',
        'AdditionsRunLevelType_System': 'System',
        'AdditionsRunLevelType_Userland': 'Userland',
        'AdditionsRunLevelType_Desktop': 'Desktop',
        'AdditionsUpdateFlag_None': 'None',
        'AdditionsUpdateFlag_WaitForUpdateStartOnly': 'WaitForUpdateStartOnly',
        'GuestSessionStatus_Undefined': 'Undefined',
        'GuestSessionStatus_Starting': 'Starting',
        'GuestSessionStatus_Started': 'Started',
        'GuestSessionStatus_Terminating': 'Terminating',
        'GuestSessionStatus_Terminated': 'Terminated',
        'GuestSessionStatus_TimedOutKilled': 'TimedOutKilled',
        'GuestSessionStatus_TimedOutAbnormally': 'TimedOutAbnormally',
        'GuestSessionStatus_Down': 'Down',
        'GuestSessionStatus_Error': 'Error',
        'GuestSessionWaitForFlag_None': 'None',
        'GuestSessionWaitForFlag_Start': 'Start',
        'GuestSessionWaitForFlag_Terminate': 'Terminate',
        'GuestSessionWaitForFlag_Status': 'Status',
        'GuestSessionWaitResult_None': 'None',
        'GuestSessionWaitResult_Start': 'Start',
        'GuestSessionWaitResult_Terminate': 'Terminate',
        'GuestSessionWaitResult_Status': 'Status',
        'GuestSessionWaitResult_Error': 'Error',
        'GuestSessionWaitResult_Timeout': 'Timeout',
        'GuestSessionWaitResult_WaitFlagNotSupported': 'WaitFlagNotSupported',
        'GuestUserState_Unknown': 'Unknown',
        'GuestUserState_LoggedIn': 'LoggedIn',
        'GuestUserState_LoggedOut': 'LoggedOut',
        'GuestUserState_Locked': 'Locked',
        'GuestUserState_Unlocked': 'Unlocked',
        'GuestUserState_Disabled': 'Disabled',
        'GuestUserState_Idle': 'Idle',
        'GuestUserState_InUse': 'InUse',
        'GuestUserState_Created': 'Created',
        'GuestUserState_Deleted': 'Deleted',
        'GuestUserState_SessionChanged': 'SessionChanged',
        'GuestUserState_CredentialsChanged': 'CredentialsChanged',
        'GuestUserState_RoleChanged': 'RoleChanged',
        'GuestUserState_GroupAdded': 'GroupAdded',
        'GuestUserState_GroupRemoved': 'GroupRemoved',
        'GuestUserState_Elevated': 'Elevated',
        'FileSeekOrigin_Begin': 'Begin',
        'FileSeekOrigin_Current': 'Current',
        'FileSeekOrigin_End': 'End',
        'ProcessInputFlag_None': 'None',
        'ProcessInputFlag_EndOfFile': 'EndOfFile',
        'ProcessOutputFlag_None': 'None',
        'ProcessOutputFlag_StdErr': 'StdErr',
        'ProcessWaitForFlag_None': 'None',
        'ProcessWaitForFlag_Start': 'Start',
        'ProcessWaitForFlag_Terminate': 'Terminate',
        'ProcessWaitForFlag_StdIn': 'StdIn',
        'ProcessWaitForFlag_StdOut': 'StdOut',
        'ProcessWaitForFlag_StdErr': 'StdErr',
        'ProcessWaitResult_None': 'None',
        'ProcessWaitResult_Start': 'Start',
        'ProcessWaitResult_Terminate': 'Terminate',
        'ProcessWaitResult_Status': 'Status',
        'ProcessWaitResult_Error': 'Error',
        'ProcessWaitResult_Timeout': 'Timeout',
        'ProcessWaitResult_StdIn': 'StdIn',
        'ProcessWaitResult_StdOut': 'StdOut',
        'ProcessWaitResult_StdErr': 'StdErr',
        'ProcessWaitResult_WaitFlagNotSupported': 'WaitFlagNotSupported',
        'FileCopyFlag_None': 'None',
        'FileCopyFlag_NoReplace': 'NoReplace',
        'FileCopyFlag_FollowLinks': 'FollowLinks',
        'FileCopyFlag_Update': 'Update',
        'FsObjMoveFlag_None': 'None',
        'FsObjMoveFlag_Replace': 'Replace',
        'FsObjMoveFlag_FollowLinks': 'FollowLinks',
        'FsObjMoveFlag_AllowDirectoryMoves': 'AllowDirectoryMoves',
        'DirectoryCreateFlag_None': 'None',
        'DirectoryCreateFlag_Parents': 'Parents',
        'DirectoryCopyFlag_None': 'None',
        'DirectoryCopyFlag_CopyIntoExisting': 'CopyIntoExisting',
        'DirectoryRemoveRecFlag_None': 'None',
        'DirectoryRemoveRecFlag_ContentAndDir': 'ContentAndDir',
        'DirectoryRemoveRecFlag_ContentOnly': 'ContentOnly',
        'FsObjRenameFlag_NoReplace': 'NoReplace',
        'FsObjRenameFlag_Replace': 'Replace',
        'ProcessCreateFlag_None': 'None',
        'ProcessCreateFlag_WaitForProcessStartOnly': 'WaitForProcessStartOnly',
        'ProcessCreateFlag_IgnoreOrphanedProcesses': 'IgnoreOrphanedProcesses',
        'ProcessCreateFlag_Hidden': 'Hidden',
        'ProcessCreateFlag_Profile': 'Profile',
        'ProcessCreateFlag_WaitForStdOut': 'WaitForStdOut',
        'ProcessCreateFlag_WaitForStdErr': 'WaitForStdErr',
        'ProcessCreateFlag_ExpandArguments': 'ExpandArguments',
        'ProcessCreateFlag_UnquotedArguments': 'UnquotedArguments',
        'ProcessPriority_Invalid': 'Invalid',
        'ProcessPriority_Default': 'Default',
        'SymlinkType_Unknown': 'Unknown',
        'SymlinkType_Directory': 'Directory',
        'SymlinkType_File': 'File',
        'SymlinkReadFlag_None': 'None',
        'SymlinkReadFlag_NoSymlinks': 'NoSymlinks',
        'ProcessStatus_Undefined': 'Undefined',
        'ProcessStatus_Starting': 'Starting',
        'ProcessStatus_Started': 'Started',
        'ProcessStatus_Paused': 'Paused',
        'ProcessStatus_Terminating': 'Terminating',
        'ProcessStatus_TerminatedNormally': 'TerminatedNormally',
        'ProcessStatus_TerminatedSignal': 'TerminatedSignal',
        'ProcessStatus_TerminatedAbnormally': 'TerminatedAbnormally',
        'ProcessStatus_TimedOutKilled': 'TimedOutKilled',
        'ProcessStatus_TimedOutAbnormally': 'TimedOutAbnormally',
        'ProcessStatus_Down': 'Down',
        'ProcessStatus_Error': 'Error',
        'ProcessInputStatus_Undefined': 'Undefined',
        'ProcessInputStatus_Broken': 'Broken',
        'ProcessInputStatus_Available': 'Available',
        'ProcessInputStatus_Written': 'Written',
        'ProcessInputStatus_Overflow': 'Overflow',
        'PathStyle_DOS': 'DOS',
        'PathStyle_UNIX': 'UNIX',
        'PathStyle_Unknown': 'Unknown',
        'FileAccessMode_ReadOnly': 'ReadOnly',
        'FileAccessMode_WriteOnly': 'WriteOnly',
        'FileAccessMode_ReadWrite': 'ReadWrite',
        'FileAccessMode_AppendOnly': 'AppendOnly',
        'FileAccessMode_AppendRead': 'AppendRead',
        'FileOpenAction_OpenExisting': 'OpenExisting',
        'FileOpenAction_OpenOrCreate': 'OpenOrCreate',
        'FileOpenAction_CreateNew': 'CreateNew',
        'FileOpenAction_CreateOrReplace': 'CreateOrReplace',
        'FileOpenAction_OpenExistingTruncated': 'OpenExistingTruncated',
        'FileOpenAction_AppendOrCreate': 'AppendOrCreate',
        'FileSharingMode_Read': 'Read',
        'FileSharingMode_Write': 'Write',
        'FileSharingMode_ReadWrite': 'ReadWrite',
        'FileSharingMode_Delete': 'Delete',
        'FileSharingMode_ReadDelete': 'ReadDelete',
        'FileSharingMode_WriteDelete': 'WriteDelete',
        'FileSharingMode_All': 'All',
        'FileOpenExFlag_None': 'None',
        'FileStatus_Undefined': 'Undefined',
        'FileStatus_Opening': 'Opening',
        'FileStatus_Open': 'Open',
        'FileStatus_Closing': 'Closing',
        'FileStatus_Closed': 'Closed',
        'FileStatus_Down': 'Down',
        'FileStatus_Error': 'Error',
        'FsObjType_Unknown': 'Unknown',
        'FsObjType_Fifo': 'Fifo',
        'FsObjType_DevChar': 'DevChar',
        'FsObjType_Directory': 'Directory',
        'FsObjType_DevBlock': 'DevBlock',
        'FsObjType_File': 'File',
        'FsObjType_Symlink': 'Symlink',
        'FsObjType_Socket': 'Socket',
        'FsObjType_WhiteOut': 'WhiteOut',
        'DnDAction_Ignore': 'Ignore',
        'DnDAction_Copy': 'Copy',
        'DnDAction_Move': 'Move',
        'DnDAction_Link': 'Link',
        'DirectoryOpenFlag_None': 'None',
        'DirectoryOpenFlag_NoSymlinks': 'NoSymlinks',
        'MediumState_NotCreated': 'NotCreated',
        'MediumState_Created': 'Created',
        'MediumState_LockedRead': 'LockedRead',
        'MediumState_LockedWrite': 'LockedWrite',
        'MediumState_Inaccessible': 'Inaccessible',
        'MediumState_Creating': 'Creating',
        'MediumState_Deleting': 'Deleting',
        'MediumType_Normal': 'Normal',
        'MediumType_Immutable': 'Immutable',
        'MediumType_Writethrough': 'Writethrough',
        'MediumType_Shareable': 'Shareable',
        'MediumType_Readonly': 'Readonly',
        'MediumType_MultiAttach': 'MultiAttach',
        'MediumVariant_Standard': 'Standard',
        'MediumVariant_VmdkSplit2G': 'VmdkSplit2G',
        'MediumVariant_VmdkRawDisk': 'VmdkRawDisk',
        'MediumVariant_VmdkStreamOptimized': 'VmdkStreamOptimized',
        'MediumVariant_VmdkESX': 'VmdkESX',
        'MediumVariant_VdiZeroExpand': 'VdiZeroExpand',
        'MediumVariant_Fixed': 'Fixed',
        'MediumVariant_Diff': 'Diff',
        'MediumVariant_Formatted': 'Formatted',
        'MediumVariant_NoCreateDir': 'NoCreateDir',
        'DataType_Int32': 'Int32',
        'DataType_Int8': 'Int8',
        'DataType_String': 'String',
        'DataFlags_None': 'None',
        'DataFlags_Mandatory': 'Mandatory',
        'DataFlags_Expert': 'Expert',
        'DataFlags_Array': 'Array',
        'DataFlags_FlagMask': 'FlagMask',
        'MediumFormatCapabilities_Uuid': 'Uuid',
        'MediumFormatCapabilities_CreateFixed': 'CreateFixed',
        'MediumFormatCapabilities_CreateDynamic': 'CreateDynamic',
        'MediumFormatCapabilities_CreateSplit2G': 'CreateSplit2G',
        'MediumFormatCapabilities_Differencing': 'Differencing',
        'MediumFormatCapabilities_Asynchronous': 'Asynchronous',
        'MediumFormatCapabilities_File': 'File',
        'MediumFormatCapabilities_Properties': 'Properties',
        'MediumFormatCapabilities_TcpNetworking': 'TcpNetworking',
        'MediumFormatCapabilities_VFS': 'VFS',
        'MediumFormatCapabilities_Discard': 'Discard',
        'MediumFormatCapabilities_Preferred': 'Preferred',
        'MediumFormatCapabilities_CapabilityMask': 'CapabilityMask',
        'PartitionTableType_MBR': 'MBR',
        'PartitionTableType_GPT': 'GPT',
        'KeyboardLED_NumLock': 'NumLock',
        'KeyboardLED_CapsLock': 'CapsLock',
        'KeyboardLED_ScrollLock': 'ScrollLock',
        'MouseButtonState_LeftButton': 'LeftButton',
        'MouseButtonState_RightButton': 'RightButton',
        'MouseButtonState_MiddleButton': 'MiddleButton',
        'MouseButtonState_WheelUp': 'WheelUp',
        'MouseButtonState_WheelDown': 'WheelDown',
        'MouseButtonState_XButton1': 'XButton1',
        'MouseButtonState_XButton2': 'XButton2',
        'MouseButtonState_MouseStateMask': 'MouseStateMask',
        'TouchContactState_None': 'None',
        'TouchContactState_InContact': 'InContact',
        'TouchContactState_InRange': 'InRange',
        'TouchContactState_ContactStateMask': 'ContactStateMask',
        'FramebufferCapabilities_UpdateImage': 'UpdateImage',
        'FramebufferCapabilities_VHWA': 'VHWA',
        'FramebufferCapabilities_VisibleRegion': 'VisibleRegion',
        'FramebufferCapabilities_RenderCursor': 'RenderCursor',
        'FramebufferCapabilities_MoveCursor': 'MoveCursor',
        'GuestMonitorStatus_Disabled': 'Disabled',
        'GuestMonitorStatus_Enabled': 'Enabled',
        'GuestMonitorStatus_Blank': 'Blank',
        'ScreenLayoutMode_Apply': 'Apply',
        'ScreenLayoutMode_Reset': 'Reset',
        'ScreenLayoutMode_Attach': 'Attach',
        'NetworkAttachmentType_Null': 'Null',
        'NetworkAttachmentType_NAT': 'NAT',
        'NetworkAttachmentType_Bridged': 'Bridged',
        'NetworkAttachmentType_Internal': 'Internal',
        'NetworkAttachmentType_HostOnly': 'HostOnly',
        'NetworkAttachmentType_Generic': 'Generic',
        'NetworkAttachmentType_NATNetwork': 'NATNetwork',
        'NetworkAdapterType_Null': 'Null',
        'NetworkAdapterType_Am79C970A': 'Am79C970A',
        'NetworkAdapterType_Am79C973': 'Am79C973',
        'NetworkAdapterType_I82540EM': 'I82540EM',
        'NetworkAdapterType_I82543GC': 'I82543GC',
        'NetworkAdapterType_I82545EM': 'I82545EM',
        'NetworkAdapterType_Virtio': 'Virtio',
        'NetworkAdapterPromiscModePolicy_Deny': 'Deny',
        'NetworkAdapterPromiscModePolicy_AllowNetwork': 'AllowNetwork',
        'NetworkAdapterPromiscModePolicy_AllowAll': 'AllowAll',
        'PortMode_Disconnected': 'Disconnected',
        'PortMode_HostPipe': 'HostPipe',
        'PortMode_HostDevice': 'HostDevice',
        'PortMode_RawFile': 'RawFile',
        'PortMode_TCP': 'TCP',
        'UartType_U16450': 'U16450',
        'UartType_U16550A': 'U16550A',
        'UartType_U16750': 'U16750',
        'VMExecutionEngine_NotSet': 'NotSet',
        'VMExecutionEngine_RawMode': 'RawMode',
        'VMExecutionEngine_HwVirt': 'HwVirt',
        'VMExecutionEngine_NativeApi': 'NativeApi',
        'USBControllerType_Null': 'Null',
        'USBControllerType_OHCI': 'OHCI',
        'USBControllerType_EHCI': 'EHCI',
        'USBControllerType_XHCI': 'XHCI',
        'USBControllerType_Last': 'Last',
        'USBConnectionSpeed_Null': 'Null',
        'USBConnectionSpeed_Low': 'Low',
        'USBConnectionSpeed_Full': 'Full',
        'USBConnectionSpeed_High': 'High',
        'USBConnectionSpeed_Super': 'Super',
        'USBConnectionSpeed_SuperPlus': 'SuperPlus',
        'USBDeviceState_NotSupported': 'NotSupported',
        'USBDeviceState_Unavailable': 'Unavailable',
        'USBDeviceState_Busy': 'Busy',
        'USBDeviceState_Available': 'Available',
        'USBDeviceState_Held': 'Held',
        'USBDeviceState_Captured': 'Captured',
        'USBDeviceFilterAction_Null': 'Null',
        'USBDeviceFilterAction_Ignore': 'Ignore',
        'USBDeviceFilterAction_Hold': 'Hold',
        'AudioDriverType_Null': 'Null',
        'AudioDriverType_WinMM': 'WinMM',
        'AudioDriverType_OSS': 'OSS',
        'AudioDriverType_ALSA': 'ALSA',
        'AudioDriverType_DirectSound': 'DirectSound',
        'AudioDriverType_CoreAudio': 'CoreAudio',
        'AudioDriverType_MMPM': 'MMPM',
        'AudioDriverType_Pulse': 'Pulse',
        'AudioDriverType_SolAudio': 'SolAudio',
        'AudioControllerType_AC97': 'AC97',
        'AudioControllerType_SB16': 'SB16',
        'AudioControllerType_HDA': 'HDA',
        'AudioCodecType_Null': 'Null',
        'AudioCodecType_SB16': 'SB16',
        'AudioCodecType_STAC9700': 'STAC9700',
        'AudioCodecType_AD1980': 'AD1980',
        'AudioCodecType_STAC9221': 'STAC9221',
        'AuthType_Null': 'Null',
        'AuthType_External': 'External',
        'AuthType_Guest': 'Guest',
        'Reason_Unspecified': 'Unspecified',
        'Reason_HostSuspend': 'HostSuspend',
        'Reason_HostResume': 'HostResume',
        'Reason_HostBatteryLow': 'HostBatteryLow',
        'Reason_Snapshot': 'Snapshot',
        'StorageBus_Null': 'Null',
        'StorageBus_IDE': 'IDE',
        'StorageBus_SATA': 'SATA',
        'StorageBus_SCSI': 'SCSI',
        'StorageBus_Floppy': 'Floppy',
        'StorageBus_SAS': 'SAS',
        'StorageBus_USB': 'USB',
        'StorageBus_PCIe': 'PCIe',
        'StorageControllerType_Null': 'Null',
        'StorageControllerType_LsiLogic': 'LsiLogic',
        'StorageControllerType_BusLogic': 'BusLogic',
        'StorageControllerType_IntelAhci': 'IntelAhci',
        'StorageControllerType_PIIX3': 'PIIX3',
        'StorageControllerType_PIIX4': 'PIIX4',
        'StorageControllerType_ICH6': 'ICH6',
        'StorageControllerType_I82078': 'I82078',
        'StorageControllerType_LsiLogicSas': 'LsiLogicSas',
        'StorageControllerType_USB': 'USB',
        'StorageControllerType_NVMe': 'NVMe',
        'ChipsetType_Null': 'Null',
        'ChipsetType_PIIX3': 'PIIX3',
        'ChipsetType_ICH9': 'ICH9',
        'NATAliasMode_AliasLog': 'AliasLog',
        'NATAliasMode_AliasProxyOnly': 'AliasProxyOnly',
        'NATAliasMode_AliasUseSamePorts': 'AliasUseSamePorts',
        'NATProtocol_UDP': 'UDP',
        'NATProtocol_TCP': 'TCP',
        'BandwidthGroupType_Null': 'Null',
        'BandwidthGroupType_Disk': 'Disk',
        'BandwidthGroupType_Network': 'Network',
        'VBoxEventType_Invalid': 'Invalid',
        'VBoxEventType_Any': 'Any',
        'VBoxEventType_Vetoable': 'Vetoable',
        'VBoxEventType_MachineEvent': 'MachineEvent',
        'VBoxEventType_SnapshotEvent': 'SnapshotEvent',
        'VBoxEventType_InputEvent': 'InputEvent',
        'VBoxEventType_LastWildcard': 'LastWildcard',
        'VBoxEventType_OnMachineStateChanged': 'OnMachineStateChanged',
        'VBoxEventType_OnMachineDataChanged': 'OnMachineDataChanged',
        'VBoxEventType_OnExtraDataChanged': 'OnExtraDataChanged',
        'VBoxEventType_OnExtraDataCanChange': 'OnExtraDataCanChange',
        'VBoxEventType_OnMediumRegistered': 'OnMediumRegistered',
        'VBoxEventType_OnMachineRegistered': 'OnMachineRegistered',
        'VBoxEventType_OnSessionStateChanged': 'OnSessionStateChanged',
        'VBoxEventType_OnSnapshotTaken': 'OnSnapshotTaken',
        'VBoxEventType_OnSnapshotDeleted': 'OnSnapshotDeleted',
        'VBoxEventType_OnSnapshotChanged': 'OnSnapshotChanged',
        'VBoxEventType_OnGuestPropertyChanged': 'OnGuestPropertyChanged',
        'VBoxEventType_OnMousePointerShapeChanged': 'OnMousePointerShapeChanged',
        'VBoxEventType_OnMouseCapabilityChanged': 'OnMouseCapabilityChanged',
        'VBoxEventType_OnKeyboardLedsChanged': 'OnKeyboardLedsChanged',
        'VBoxEventType_OnStateChanged': 'OnStateChanged',
        'VBoxEventType_OnAdditionsStateChanged': 'OnAdditionsStateChanged',
        'VBoxEventType_OnNetworkAdapterChanged': 'OnNetworkAdapterChanged',
        'VBoxEventType_OnSerialPortChanged': 'OnSerialPortChanged',
        'VBoxEventType_OnParallelPortChanged': 'OnParallelPortChanged',
        'VBoxEventType_OnStorageControllerChanged': 'OnStorageControllerChanged',
        'VBoxEventType_OnMediumChanged': 'OnMediumChanged',
        'VBoxEventType_OnVRDEServerChanged': 'OnVRDEServerChanged',
        'VBoxEventType_OnUSBControllerChanged': 'OnUSBControllerChanged',
        'VBoxEventType_OnUSBDeviceStateChanged': 'OnUSBDeviceStateChanged',
        'VBoxEventType_OnSharedFolderChanged': 'OnSharedFolderChanged',
        'VBoxEventType_OnRuntimeError': 'OnRuntimeError',
        'VBoxEventType_OnCanShowWindow': 'OnCanShowWindow',
        'VBoxEventType_OnShowWindow': 'OnShowWindow',
        'VBoxEventType_OnCPUChanged': 'OnCPUChanged',
        'VBoxEventType_OnVRDEServerInfoChanged': 'OnVRDEServerInfoChanged',
        'VBoxEventType_OnEventSourceChanged': 'OnEventSourceChanged',
        'VBoxEventType_OnCPUExecutionCapChanged': 'OnCPUExecutionCapChanged',
        'VBoxEventType_OnGuestKeyboard': 'OnGuestKeyboard',
        'VBoxEventType_OnGuestMouse': 'OnGuestMouse',
        'VBoxEventType_OnNATRedirect': 'OnNATRedirect',
        'VBoxEventType_OnHostPCIDevicePlug': 'OnHostPCIDevicePlug',
        'VBoxEventType_OnVBoxSVCAvailabilityChanged': 'OnVBoxSVCAvailabilityChanged',
        'VBoxEventType_OnBandwidthGroupChanged': 'OnBandwidthGroupChanged',
        'VBoxEventType_OnGuestMonitorChanged': 'OnGuestMonitorChanged',
        'VBoxEventType_OnStorageDeviceChanged': 'OnStorageDeviceChanged',
        'VBoxEventType_OnClipboardModeChanged': 'OnClipboardModeChanged',
        'VBoxEventType_OnDnDModeChanged': 'OnDnDModeChanged',
        'VBoxEventType_OnNATNetworkChanged': 'OnNATNetworkChanged',
        'VBoxEventType_OnNATNetworkStartStop': 'OnNATNetworkStartStop',
        'VBoxEventType_OnNATNetworkAlter': 'OnNATNetworkAlter',
        'VBoxEventType_OnNATNetworkCreationDeletion': 'OnNATNetworkCreationDeletion',
        'VBoxEventType_OnNATNetworkSetting': 'OnNATNetworkSetting',
        'VBoxEventType_OnNATNetworkPortForward': 'OnNATNetworkPortForward',
        'VBoxEventType_OnGuestSessionStateChanged': 'OnGuestSessionStateChanged',
        'VBoxEventType_OnGuestSessionRegistered': 'OnGuestSessionRegistered',
        'VBoxEventType_OnGuestProcessRegistered': 'OnGuestProcessRegistered',
        'VBoxEventType_OnGuestProcessStateChanged': 'OnGuestProcessStateChanged',
        'VBoxEventType_OnGuestProcessInputNotify': 'OnGuestProcessInputNotify',
        'VBoxEventType_OnGuestProcessOutput': 'OnGuestProcessOutput',
        'VBoxEventType_OnGuestFileRegistered': 'OnGuestFileRegistered',
        'VBoxEventType_OnGuestFileStateChanged': 'OnGuestFileStateChanged',
        'VBoxEventType_OnGuestFileOffsetChanged': 'OnGuestFileOffsetChanged',
        'VBoxEventType_OnGuestFileRead': 'OnGuestFileRead',
        'VBoxEventType_OnGuestFileWrite': 'OnGuestFileWrite',
        'VBoxEventType_OnRecordingChanged': 'OnRecordingChanged',
        'VBoxEventType_OnGuestUserStateChanged': 'OnGuestUserStateChanged',
        'VBoxEventType_OnGuestMultiTouch': 'OnGuestMultiTouch',
        'VBoxEventType_OnHostNameResolutionConfigurationChange': 'OnHostNameResolutionConfigurationChange',
        'VBoxEventType_OnSnapshotRestored': 'OnSnapshotRestored',
        'VBoxEventType_OnMediumConfigChanged': 'OnMediumConfigChanged',
        'VBoxEventType_OnAudioAdapterChanged': 'OnAudioAdapterChanged',
        'VBoxEventType_OnProgressPercentageChanged': 'OnProgressPercentageChanged',
        'VBoxEventType_OnProgressTaskCompleted': 'OnProgressTaskCompleted',
        'VBoxEventType_OnCursorPositionChanged': 'OnCursorPositionChanged',
        'VBoxEventType_Last': 'Last',
        'GuestMouseEventMode_Relative': 'Relative',
        'GuestMouseEventMode_Absolute': 'Absolute',
        'GuestMonitorChangedEventType_Enabled': 'Enabled',
        'GuestMonitorChangedEventType_Disabled': 'Disabled',
        'GuestMonitorChangedEventType_NewOrigin': 'NewOrigin',
        # Result constants:
        'VBOX_E_OBJECT_NOT_FOUND': 'VBOX_E_OBJECT_NOT_FOUND',
        'VBOX_E_INVALID_VM_STATE': 'VBOX_E_INVALID_VM_STATE',
        'VBOX_E_VM_ERROR': 'VBOX_E_VM_ERROR',
        'VBOX_E_FILE_ERROR': 'VBOX_E_FILE_ERROR',
        'VBOX_E_IPRT_ERROR': 'VBOX_E_IPRT_ERROR',
        'VBOX_E_PDM_ERROR': 'VBOX_E_PDM_ERROR',
        'VBOX_E_INVALID_OBJECT_STATE': 'VBOX_E_INVALID_OBJECT_STATE',
        'VBOX_E_HOST_ERROR': 'VBOX_E_HOST_ERROR',
        'VBOX_E_NOT_SUPPORTED': 'VBOX_E_NOT_SUPPORTED',
        'VBOX_E_XML_ERROR': 'VBOX_E_XML_ERROR',
        'VBOX_E_INVALID_SESSION_STATE': 'VBOX_E_INVALID_SESSION_STATE',
        'VBOX_E_OBJECT_IN_USE': 'VBOX_E_OBJECT_IN_USE',
        'VBOX_E_PASSWORD_INCORRECT': 'VBOX_E_PASSWORD_INCORRECT',
        'VBOX_E_MAXIMUM_REACHED': 'VBOX_E_MAXIMUM_REACHED',
        'VBOX_E_GSTCTL_GUEST_ERROR': 'VBOX_E_GSTCTL_GUEST_ERROR',
        'VBOX_E_TIMEOUT': 'VBOX_E_TIMEOUT',
    }

    def __getattr__(self, sAttrName):
        if self.__fIsSym:
            oValue = self.__dValuesFlatSym.get(sAttrName)
        else:
            oValue = self.__dValuesFlat.get(sAttrName)
        if oValue is None:
            raise AttributeError
        return oValue

    def all_values(self, sEnumName):
        """ Returns a dictionary with all the value names for a given enum type. """
        if self.__fIsSym:
            dValues = self.__dValuesSym.get(sEnumName)
        else:
            dValues = self.__dValues.get(sEnumName)
        if dValues is None:
            dValues = {}
        return dValues

