/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParsingException;
import org.editorconfig.core.VersionException;

public class EditorConfig {
    private static boolean DEBUG = System.getProperty("editorconfig.debug") != null;
    public static String VERSION = "0.12.0-final";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\s*\\[(([^#;]|\\\\#|\\\\;)+)].*");
    private static final int HEADER = 1;
    private static final Pattern OPTION_PATTERN = Pattern.compile("\\s*([^:=\\s][^:=]*)\\s*[:=]\\s*(.*)");
    private static final int OPTION = 1;
    private static final int VAL = 2;
    private static final Pattern OPENING_BRACES = Pattern.compile("(?:^|[^\\\\])\\{");
    private static final Pattern CLOSING_BRACES = Pattern.compile("(?:^|[^\\\\])}");
    private final String configFilename;
    private final String version;

    public EditorConfig() {
        this(".editorconfig", VERSION);
    }

    public EditorConfig(String configFilename, String version) {
        this.configFilename = configFilename;
        this.version = version;
    }

    public List<OutPair> getProperties(String filePath) throws EditorConfigException {
        return this.getProperties(filePath, Collections.<String>emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutPair> getProperties(String filePath, Set<String> explicitRootDirs) throws EditorConfigException {
        this.checkAssertions();
        Map<String, String> oldOptions = Collections.emptyMap();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        try {
            String dir = new File(filePath).getParent();
            for (boolean root = false; dir != null && !root; root |= explicitRootDirs.contains(dir)) {
                File configFile = new File(dir, this.configFilename);
                if (configFile.exists()) {
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"));
                        root = EditorConfig.parseFile(bufferedReader, dir + "/", filePath, options);
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                }
                options.putAll(oldOptions);
                oldOptions = options;
                options = new LinkedHashMap();
                dir = new File(dir).getParent();
            }
        }
        catch (IOException e) {
            throw new EditorConfigException(null, e);
        }
        this.preprocessOptions(oldOptions);
        ArrayList<OutPair> result = new ArrayList<OutPair>();
        for (Map.Entry<String, String> keyValue : oldOptions.entrySet()) {
            result.add(new OutPair(keyValue.getKey(), keyValue.getValue()));
        }
        return result;
    }

    private void checkAssertions() throws VersionException {
        if (EditorConfig.compareVersions(this.version, VERSION) > 0) {
            throw new VersionException("Required version is greater than the current version.");
        }
    }

    private static int compareVersions(String version1, String version2) {
        String[] version1Components = version1.split("([.-])");
        String[] version2Components = version2.split("([.-])");
        for (int i = 0; i < 3; ++i) {
            String version1Component = version1Components[i];
            String version2Component = version2Components[i];
            int v1 = -1;
            int v2 = -1;
            try {
                v1 = Integer.parseInt(version1Component);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                v2 = Integer.parseInt(version2Component);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (v1 == v2) continue;
            return v1 - v2;
        }
        return 0;
    }

    private void preprocessOptions(Map<String, String> options) {
        String indent_size;
        for (String key : new String[]{"end_of_line", "indent_style", "indent_size", "insert_final_newline", "trim_trailing_whitespace", "charset"}) {
            String value = options.get(key);
            if (value == null) continue;
            options.put(key, value.toLowerCase(Locale.US));
        }
        if ("tab".equals(options.get("indent_style")) && !options.containsKey("indent_size") && EditorConfig.compareVersions(this.version, "0.10.0") >= 0) {
            options.put("indent_size", "tab");
        }
        if ((indent_size = options.get("indent_size")) != null && !"tab".equals(indent_size) && !options.containsKey("tab_width")) {
            options.put("tab_width", indent_size);
        }
        String tab_width = options.get("tab_width");
        if ("tab".equals(indent_size) && tab_width != null) {
            options.put("indent_size", tab_width);
        }
    }

    private static boolean parseFile(BufferedReader bufferedReader, String dirName, String filePath, Map<String, String> result) throws IOException, EditorConfigException {
        String line;
        StringBuilder malformedLines = new StringBuilder();
        boolean root = false;
        boolean inSection = false;
        boolean matchingSection = false;
        while ((line = bufferedReader.readLine()) != null) {
            if ((line = line.trim()).startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (line.isEmpty() || line.startsWith("#") || line.startsWith(";")) continue;
            Matcher matcher = SECTION_PATTERN.matcher(line);
            if (matcher.matches()) {
                inSection = true;
                try {
                    matchingSection = EditorConfig.filenameMatches(dirName, matcher.group(1), filePath);
                }
                catch (PatternSyntaxException e) {
                    malformedLines.append(line).append("\n");
                }
                continue;
            }
            matcher = OPTION_PATTERN.matcher(line);
            if (matcher.matches()) {
                String key = matcher.group(1).trim().toLowerCase(Locale.US);
                String value = matcher.group(2);
                String string = value = value.equals("\"\"") ? "" : value;
                if (!inSection && "root".equals(key)) {
                    root = true;
                    continue;
                }
                if (!matchingSection) continue;
                int commentPos = value.indexOf(" ;");
                commentPos = commentPos < 0 ? value.indexOf(" #") : commentPos;
                value = commentPos >= 0 ? value.substring(0, commentPos) : value;
                result.put(key, value);
                continue;
            }
            malformedLines.append(line).append("\n");
        }
        if (malformedLines.length() > 0) {
            throw new ParsingException(malformedLines.toString(), null);
        }
        return root;
    }

    static boolean filenameMatches(String configDirname, String pattern, String filePath) {
        Matcher matcher;
        pattern = pattern.replace(File.separatorChar, '/');
        pattern = pattern.replaceAll("\\\\#", "#");
        int separator = (pattern = pattern.replaceAll("\\\\;", ";")).indexOf("/");
        pattern = separator >= 0 ? configDirname.replace(File.separatorChar, '/') + (separator == 0 ? pattern.substring(1) : pattern) : "**/" + pattern;
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        String regex = EditorConfig.convertGlobToRegEx(pattern, ranges);
        if (DEBUG) {
            System.err.println(regex);
            for (int[] range : ranges) {
                System.err.println("numeric range: {" + range[0] + ".." + range[1] + "}");
            }
        }
        if ((matcher = Pattern.compile(regex).matcher(filePath)).matches()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                int[] range = ranges.get(i);
                String numberString = matcher.group(i + 1);
                if (numberString == null || numberString.startsWith("0")) {
                    return false;
                }
                int number = Integer.parseInt(numberString);
                if (number >= range[0] && number <= range[1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String convertGlobToRegEx(String pattern, ArrayList<int[]> ranges) {
        int length = pattern.length();
        StringBuilder result = new StringBuilder(length);
        int i = 0;
        int braceLevel = 0;
        boolean matchingBraces = EditorConfig.countAll(OPENING_BRACES, pattern) == EditorConfig.countAll(CLOSING_BRACES, pattern);
        boolean escaped = false;
        boolean inBrackets = false;
        while (i < length) {
            char current = pattern.charAt(i);
            ++i;
            if ('*' == current) {
                if (i < length && pattern.charAt(i) == '*') {
                    result.append(".*");
                    ++i;
                } else {
                    result.append("[^/]*");
                }
            } else if ('?' == current) {
                result.append(".");
            } else if ('[' == current) {
                boolean seenSlash;
                boolean bl = seenSlash = EditorConfig.findChar('/', ']', pattern, length, i) >= 0;
                if (seenSlash || escaped) {
                    result.append("\\[");
                } else if (i < length && "!^".indexOf(pattern.charAt(i)) >= 0) {
                    ++i;
                    result.append("[^");
                } else {
                    result.append("[");
                }
                inBrackets = true;
            } else if (']' == current || '-' == current && inBrackets) {
                if (escaped) {
                    result.append("\\");
                }
                result.append(current);
                inBrackets = current != ']' || escaped;
            } else if ('{' == current) {
                int j = EditorConfig.findChar(',', '}', pattern, length, i);
                if (j < 0 && -j < length) {
                    String choice = pattern.substring(i, -j);
                    int[] range = EditorConfig.getNumericRange(choice);
                    if (range != null) {
                        result.append("(\\d+)");
                        ranges.add(range);
                    } else {
                        result = new StringBuilder(result);
                        result.append("\\{");
                        result.append(EditorConfig.convertGlobToRegEx(choice, ranges));
                        result.append("\\}");
                    }
                    i = -j + 1;
                } else if (matchingBraces) {
                    result.append("(?:");
                    ++braceLevel;
                } else {
                    result.append("\\{");
                }
            } else if (',' == current) {
                if (braceLevel > 0 && !escaped) {
                    result.append("|");
                    while (i < length && pattern.charAt(i) == ' ') {
                        ++i;
                    }
                } else {
                    result.append(",");
                }
            } else if ('/' == current) {
                if (i < length && pattern.charAt(i) == '*') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '*' && i + 2 < length && pattern.charAt(i + 2) == '/') {
                        result.append("(?:/|/.*/)");
                        i += 3;
                    } else {
                        result.append(current);
                    }
                } else {
                    result.append(current);
                }
            } else if ('}' == current) {
                if (braceLevel > 0 && !escaped) {
                    result.append(")");
                    --braceLevel;
                } else {
                    result.append("}");
                }
            } else if ('\\' != current) {
                result.append(EditorConfig.escapeToRegex(String.valueOf(current)));
            }
            if ('\\' == current) {
                if (escaped) {
                    result.append("\\\\");
                }
                escaped = !escaped;
                continue;
            }
            escaped = false;
        }
        return result.toString();
    }

    private static int[] getNumericRange(String choice) {
        int separator = choice.indexOf("..");
        if (separator < 0) {
            return null;
        }
        try {
            int start = Integer.parseInt(choice.substring(0, separator));
            int end = Integer.parseInt(choice.substring(separator + 2));
            return new int[]{start, end};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int findChar(char c, char stopAt, String pattern, int length, int start) {
        int j;
        boolean escapedChar = false;
        for (j = start; j < length && (pattern.charAt(j) != stopAt || escapedChar); ++j) {
            if (pattern.charAt(j) == c && !escapedChar) {
                return j;
            }
            escapedChar = pattern.charAt(j) == '\\' && !escapedChar;
        }
        return -j;
    }

    private static String escapeToRegex(String group) {
        StringBuilder builder = new StringBuilder(group.length());
        for (char c : group.toCharArray()) {
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            builder.append("\\").append(c);
        }
        return builder.toString();
    }

    private static int countAll(Pattern regex, String pattern) {
        Matcher matcher = regex.matcher(pattern);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static class OutPair {
        private final String key;
        private final String val;

        public OutPair(String key, String val) {
            this.key = key;
            this.val = val;
        }

        public String getKey() {
            return this.key;
        }

        public String getVal() {
            return this.val;
        }
    }
}

