/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Alarm;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

class ThrottlingListenerWrapper
implements SESearcher.Listener {
    public final int myThrottlingDelay;
    private final SESearcher.Listener myDelegateListener;
    private final Executor myDelegateExecutor;
    private final Buffer myBuffer = new Buffer();
    private final BiConsumer<List<SESearcher.ElementInfo>, List<SESearcher.ElementInfo>> myFlushConsumer;
    private final Alarm flushAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean flushScheduled;

    ThrottlingListenerWrapper(int throttlingDelay, SESearcher.Listener delegateListener, Executor delegateExecutor) {
        this.myThrottlingDelay = throttlingDelay;
        this.myDelegateListener = delegateListener;
        this.myDelegateExecutor = delegateExecutor;
        this.myFlushConsumer = (added, removed) -> {
            if (!added.isEmpty()) {
                this.myDelegateExecutor.execute(() -> this.myDelegateListener.elementsAdded((List<SESearcher.ElementInfo>)added));
            }
            if (!removed.isEmpty()) {
                this.myDelegateExecutor.execute(() -> this.myDelegateListener.elementsRemoved((List<SESearcher.ElementInfo>)removed));
            }
        };
    }

    public void clearBuffer() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.clear();
        this.cancelScheduledFlush();
    }

    @Override
    public void elementsAdded(@NotNull List<SESearcher.ElementInfo> list2) {
        if (list2 == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.addEvent(new Event(1, list2));
        this.scheduleFlushBuffer();
    }

    @Override
    public void elementsRemoved(@NotNull List<SESearcher.ElementInfo> list2) {
        if (list2 == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.addEvent(new Event(0, list2));
        this.scheduleFlushBuffer();
    }

    @Override
    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        if (hasMoreContributors == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.flush(this.myFlushConsumer);
        this.myDelegateExecutor.execute(() -> this.myDelegateListener.searchFinished(hasMoreContributors));
        this.cancelScheduledFlush();
    }

    private void scheduleFlushBuffer() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Runnable flushTask = () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!this.flushScheduled) {
                return;
            }
            this.flushScheduled = false;
            this.myBuffer.flush(this.myFlushConsumer);
        };
        if (!this.flushScheduled) {
            this.flushAlarm.addRequest(flushTask, this.myThrottlingDelay);
            this.flushScheduled = true;
        }
    }

    private void cancelScheduledFlush() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.flushAlarm.cancelAllRequests();
        this.flushScheduled = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasMoreContributors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ThrottlingListenerWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "elementsAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "elementsRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "searchFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Buffer {
        private final Queue<Event> myQueue = new ArrayDeque<Event>();

        private Buffer() {
        }

        public void addEvent(Event event) {
            this.myQueue.add(event);
        }

        public void flush(BiConsumer<List<SESearcher.ElementInfo>, List<SESearcher.ElementInfo>> consumer) {
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            this.myQueue.forEach(event -> {
                if (event.type == 1) {
                    added.addAll(event.items);
                } else {
                    event.items.forEach(removing -> {
                        if (!added.removeIf(existing -> existing.getContributor() == removing.getContributor() && existing.getElement() == removing.getElement())) {
                            removed.add(removing);
                        }
                    });
                }
            });
            this.myQueue.clear();
            consumer.accept(added, removed);
        }

        public void clear() {
            this.myQueue.clear();
        }
    }

    private static class Event {
        static final int REMOVE = 0;
        static final int ADD = 1;
        final int type;
        final List<SESearcher.ElementInfo> items;

        Event(int type, List<SESearcher.ElementInfo> items) {
            this.type = type;
            this.items = items;
        }
    }
}

