/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.PyRerunFailedTestsAction;
import com.jetbrains.python.testing.PythonTRunnerConsoleProperties;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonTestCommandLineStateBase<T extends AbstractPythonRunConfiguration<?>>
extends PythonCommandLineState {
    protected final T myConfiguration;

    public T getConfiguration() {
        return this.myConfiguration;
    }

    public PythonTestCommandLineStateBase(T configuration, ExecutionEnvironment env) {
        super((AbstractPythonRunConfiguration)configuration, env);
        this.myConfiguration = configuration;
        this.setRunWithPty(false);
    }

    @Override
    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        PythonTRunnerConsoleProperties consoleProperties = this.createConsoleProperties(executor);
        if (this.isDebug()) {
            BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)"PythonUnitTestRunner", (TestConsoleProperties)consoleProperties);
            PythonDebugLanguageConsoleView consoleView = new PythonDebugLanguageConsoleView(project, PythonSdkType.findSdkByPath(((AbstractPythonRunConfiguration)this.myConfiguration).getInterpreterPath()), (ConsoleView)testsOutputConsoleView, true);
            consoleView.attachToProcess(processHandler);
            this.addTracebackFilter(project, (ConsoleView)consoleView, processHandler);
            PythonDebugLanguageConsoleView pythonDebugLanguageConsoleView = consoleView;
            if (pythonDebugLanguageConsoleView == null) {
                PythonTestCommandLineStateBase.$$$reportNull$$$0(0);
            }
            return pythonDebugLanguageConsoleView;
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"PythonUnitTestRunner", (ProcessHandler)processHandler, (TestConsoleProperties)consoleProperties);
        this.addTracebackFilter(project, (ConsoleView)consoleView, processHandler);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            PythonTestCommandLineStateBase.$$$reportNull$$$0(1);
        }
        return baseTestsOutputConsoleView;
    }

    protected PythonTRunnerConsoleProperties createConsoleProperties(Executor executor) {
        PythonTRunnerConsoleProperties properties = new PythonTRunnerConsoleProperties((ModuleRunConfiguration)this.myConfiguration, executor, true, this.getTestLocator());
        if (((AbstractPythonRunConfiguration)this.myConfiguration).isIdTestBased()) {
            properties.makeIdTestBased();
        }
        return properties;
    }

    @Nullable
    protected SMTestLocator getTestLocator() {
        return null;
    }

    @Override
    @NotNull
    public GeneralCommandLine generateCommandLine() {
        GeneralCommandLine cmd = super.generateCommandLine();
        this.setWorkingDirectory(cmd);
        ParamsGroup exe_options = cmd.getParametersList().getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(((AbstractPythonRunConfiguration)this.myConfiguration).getInterpreterOptions());
        this.addTestRunnerParameters(cmd);
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            PythonTestCommandLineStateBase.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    protected void setWorkingDirectory(@NotNull GeneralCommandLine cmd) {
        String workingDirectory;
        if (cmd == null) {
            PythonTestCommandLineStateBase.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)(workingDirectory = ((AbstractPythonRunConfiguration)this.myConfiguration).getWorkingDirectory()))) {
            workingDirectory = ((AbstractPythonRunConfiguration)this.myConfiguration).getWorkingDirectorySafe();
        }
        cmd.withWorkDirectory(workingDirectory);
    }

    @Override
    public ExecutionResult execute(Executor executor, PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(processStarter, patchers);
        ConsoleView console = this.createAndAttachConsole(this.myConfiguration.getProject(), processHandler, executor);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler));
        PyRerunFailedTestsAction rerunFailedTestsAction = new PyRerunFailedTestsAction((ComponentContainer)console);
        if (console instanceof SMTRunnerConsoleView) {
            rerunFailedTestsAction.init(((BaseTestsOutputConsoleView)console).getProperties());
            rerunFailedTestsAction.setModelProvider(() -> ((SMTRunnerConsoleView)console).getResultsViewer());
        }
        executionResult.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction()});
        return executionResult;
    }

    protected void addBeforeParameters(GeneralCommandLine cmd) {
    }

    protected void addAfterParameters(GeneralCommandLine cmd) {
    }

    protected void addTestRunnerParameters(GeneralCommandLine cmd) {
        ParamsGroup scriptParams = cmd.getParametersList().getParamsGroup("Script");
        assert (scriptParams != null);
        this.getRunner().addToGroup(scriptParams, cmd);
        this.addBeforeParameters(cmd);
        ((AbstractPythonRunConfiguration)this.myConfiguration).addTestSpecsAsParameters(scriptParams, this.getTestSpecs());
        this.addAfterParameters(cmd);
    }

    @Override
    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        envs.put("PYCHARM_HELPERS_DIR", PythonHelpersLocator.getHelperPath("pycharm"));
    }

    protected abstract HelperPackage getRunner();

    @NotNull
    protected abstract List<String> getTestSpecs();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/PythonTestCommandLineStateBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/PythonTestCommandLineStateBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

