/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.stdlib;

import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleTypeProvider;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/inspections/stdlib/PyStdlibInspectionExtension;", "Lcom/jetbrains/python/inspections/PyInspectionExtension;", "()V", "ignoreInitNewSignatures", "", "original", "Lcom/jetbrains/python/psi/PyFunction;", "complementary", "ignoreProtectedSymbol", "expression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "ignoreUnresolvedMember", "type", "Lcom/jetbrains/python/psi/types/PyType;", "name", "", "intellij.python.community.impl"})
public final class PyStdlibInspectionExtension
extends PyInspectionExtension {
    @Override
    public boolean ignoreInitNewSignatures(@NotNull PyFunction original, @NotNull PyFunction complementary) {
        Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
        Intrinsics.checkParameterIsNotNull((Object)complementary, (String)"complementary");
        PyClass pyClass = complementary.getContainingClass();
        return Intrinsics.areEqual((Object)"enum.Enum", (Object)(pyClass != null ? pyClass.getQualifiedName() : null));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ignoreUnresolvedMember(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        Object element$iv;
        PyNamedTupleType it;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(type instanceof PyClassLikeType)) return false;
        if (type instanceof PyNamedTupleType) {
            if (((PyNamedTupleType)type).getFields().containsKey(name)) return true;
        }
        List<PyClassLikeType> list = ((PyClassLikeType)type).getAncestorTypes(context);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"type.getAncestorTypes(context)");
        Iterable $receiver$iv = list;
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PyNamedTupleType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        object = $receiver$iv.iterator();
        do {
            if (!object.hasNext()) return false;
        } while (!(it = (PyNamedTupleType)(element$iv = object.next())).getFields().containsKey(name));
        return true;
    }

    @Override
    public boolean ignoreProtectedSymbol(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PyExpression qualifier = expression.getQualifier();
        return qualifier != null && PyNamedTupleType.NAMEDTUPLE_SPECIAL_ATTRIBUTES.contains(expression.getReferencedName()) && PyNamedTupleTypeProvider.Companion.isNamedTuple(context.getType(qualifier), context);
    }
}

